( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"usmapviii_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + us_map_iii_config[id]['title']);
        var _abb = $('#' + us_map_iii_config[id]['title']);
        $('#usmapwrapper-iii').css({'opacity': '1'});

        if(us_map_iii_config['default']['usshowvisns_iii'] === true) {
            $('#usvisns-iii').css({'fill': us_map_iii_config['default']['usvisns_iii']});
            $('#usvisns-iii').css({'opacity': '1'});
        } else {
            $('#usvisns-iii').css({'opacity': '0'});
        }

        if(us_map_iii_config['default']['usshowlakes_iii'] === true) {
            $('#uslakes-iii path').css({'stroke': us_map_iii_config['default']['usbrdrclr_iii']});
            $('#uslakes-iii').css({'fill': us_map_iii_config['default']['uslakesfill_iii']});
            $('#uslakes-iii').css({'visibility': 'visible'});
        } else {
            $('#uslakes-iii').css({'visibility': 'hidden'});
        }

        if(us_map_iii_config['default']['usshowalaska_iii'] === true) {
            $('#usmapviii_2' + ',' + '#usvnviii_2').css({'visibility': 'visible'});
        } else {
            $('#usmapviii_2' + ',' + '#usvnviii_2').css({'visibility': 'hidden'});
        }

        if(us_map_iii_config['default']['usshowhawaii_iii'] === true) {
            $('#usmapviii_11' + ',' + '#usvnviii_11').css({'visibility': 'visible'});
        } else {
            $('#usmapviii_11' + ',' + '#usvnviii_11').css({'visibility': 'hidden'});
        }

        if(us_map_iii_config['default']['usshowdc_iii'] === true) {
            $('#usmapviii_51' + ',' + '#usvnviii_51').css({'visibility': 'visible'});
        } else {
            $('#usmapviii_51' + ',' + '#usvnviii_51').css({'visibility': 'hidden'});
        }

        if(us_map_iii_config['default']['uscallouts_iii'] === true) {
            $('#uscallouts-iii').css({'visibility': 'hidden'});
        } else {
            $('#uscallouts-iii').css({'visibility': 'visible'});
        }

        _obj.attr({'fill': us_map_iii_config[id]['upclr'], 'stroke': us_map_iii_config['default']['usbrdrclr_iii']});

        _Textobj.attr({'cursor': 'default'});

        if (us_map_iii_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $usmtip = $('#tipusmap-iii');
                            let usmaptipw = $usmtip.outerWidth(),
                                usmaptiph = $usmtip.outerHeight();

                            x = (x + usmaptipw > $(document).scrollLeft() + $(window).width()) ? x - usmaptipw - (20 * 2) : x
                            y = (y + usmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - usmaptiph - 10 : y

                            if (us_map_iii_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': us_map_iii_config[id]['dwnclr']});
                            }
                            $usmtip.show().html(us_map_iii_config[id]['hover']);
                            $usmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': us_map_iii_config[id]['upclr']});
                            if (us_map_iii_config[id]['targt'] === '_blank') {
                                window.open(us_map_iii_config[id]['url']);
                            } else if (us_map_iii_config[id]['targt'] === '_self') {
                                window.parent.location.href = us_map_iii_config[id]['url'];
                            }
                            $('#tipusmap-iii').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipusmap-iii').show().html(us_map_iii_config[id]['hover']);
                _obj.css({'fill': us_map_iii_config[id]['ovrclr']});
                _abb.css({'fill': us_map_iii_config['default']['usvisnshover_iii']});
            }).on('mouseleave', function () {
                $('#tipusmap-iii').hide();
                _obj.css({'fill': us_map_iii_config[id]['upclr']});
                _abb.css({'fill': us_map_iii_config['default']['usvisns_iii']});
            });
            if (us_map_iii_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': us_map_iii_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': us_map_iii_config[id]['ovrclr']});
                if (us_map_iii_config[id]['targt'] === '_blank') {
                    window.open(us_map_iii_config[id]['url']);
                } else if (us_map_iii_config[id]['targt'] === '_self') {
                    window.parent.location.href = us_map_iii_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mus = $('#tipusmap-iii');
                let usmaptipw = $mus.outerWidth(), usmaptiph = $mus.outerHeight();

                x = (x + usmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - usmaptipw - (20 * 2) : x
                y = (y + usmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - usmaptiph - 10 : y

                $mus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
