( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"usmapvii_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + us_map_ii_config[id]['title']);
        var _abb = $('#' + us_map_ii_config[id]['title']);
        $('#usmapwrapper-ii').css({'opacity': '1'});

        if(us_map_ii_config['default']['usshowvisns_ii'] === true) {
            $('#usvisns-ii').css({'fill': us_map_ii_config['default']['usvisns_ii']});
            $('#usvisns-ii').css({'opacity': '1'});
        } else {
            $('#usvisns-ii').css({'opacity': '0'});
        }

        if(us_map_ii_config['default']['usshowlakes_ii'] === true) {
            $('#uslakes-ii path').css({'stroke': us_map_ii_config['default']['usbrdrclr_ii']});
            $('#uslakes-ii').css({'fill': us_map_ii_config['default']['uslakesfill_ii']});
            $('#uslakes-ii').css({'visibility': 'visible'});
        } else {
            $('#uslakes-ii').css({'visibility': 'hidden'});
        }

        if(us_map_ii_config['default']['usshowalaska_ii'] === true) {
            $('#usmapvii_2' + ',' + '#usvnvii_2').css({'visibility': 'visible'});
        } else {
            $('#usmapvii_2' + ',' + '#usvnvii_2').css({'visibility': 'hidden'});
        }

        if(us_map_ii_config['default']['usshowhawaii_ii'] === true) {
            $('#usmapvii_11' + ',' + '#usvnvii_11').css({'visibility': 'visible'});
        } else {
            $('#usmapvii_11' + ',' + '#usvnvii_11').css({'visibility': 'hidden'});
        }

        if(us_map_ii_config['default']['usshowdc_ii'] === true) {
            $('#usmapvii_51' + ',' + '#usvnvii_51').css({'visibility': 'visible'});
        } else {
            $('#usmapvii_51' + ',' + '#usvnvii_51').css({'visibility': 'hidden'});
        }

        if(us_map_ii_config['default']['uscallouts_ii'] === true) {
            $('#uscallouts-ii').css({'visibility': 'hidden'});
        } else {
            $('#uscallouts-ii').css({'visibility': 'visible'});
        }

        _obj.attr({'fill': us_map_ii_config[id]['upclr'], 'stroke': us_map_ii_config['default']['usbrdrclr_ii']});

        _Textobj.attr({'cursor': 'default'});

        if (us_map_ii_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $usmtip = $('#tipusmap-ii');
                            let usmaptipw = $usmtip.outerWidth(),
                                usmaptiph = $usmtip.outerHeight();

                            x = (x + usmaptipw > $(document).scrollLeft() + $(window).width()) ? x - usmaptipw - (20 * 2) : x
                            y = (y + usmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - usmaptiph - 10 : y

                            if (us_map_ii_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': us_map_ii_config[id]['dwnclr']});
                            }
                            $usmtip.show().html(us_map_ii_config[id]['hover']);
                            $usmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': us_map_ii_config[id]['upclr']});
                            if (us_map_ii_config[id]['targt'] === '_blank') {
                                window.open(us_map_ii_config[id]['url']);
                            } else if (us_map_ii_config[id]['targt'] === '_self') {
                                window.parent.location.href = us_map_ii_config[id]['url'];
                            }
                            $('#tipusmap-ii').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipusmap-ii').show().html(us_map_ii_config[id]['hover']);
                _obj.css({'fill': us_map_ii_config[id]['ovrclr']});
                _abb.css({'fill': us_map_ii_config['default']['usvisnshover_ii']});
            }).on('mouseleave', function () {
                $('#tipusmap-ii').hide();
                _obj.css({'fill': us_map_ii_config[id]['upclr']});
                _abb.css({'fill': us_map_ii_config['default']['usvisns_ii']});
            });
            if (us_map_ii_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': us_map_ii_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': us_map_ii_config[id]['ovrclr']});
                if (us_map_ii_config[id]['targt'] === '_blank') {
                    window.open(us_map_ii_config[id]['url']);
                } else if (us_map_ii_config[id]['targt'] === '_self') {
                    window.parent.location.href = us_map_ii_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mus = $('#tipusmap-ii');
                let usmaptipw = $mus.outerWidth(), usmaptiph = $mus.outerHeight();

                x = (x + usmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - usmaptipw - (20 * 2) : x
                y = (y + usmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - usmaptiph - 10 : y

                $mus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
