jQuery(document).ready(function() {
	var vColorPickerOptions = {
    	defaultColor: false,
    	change: function(event, ui){},
    	clear: function() {},
		hide: true,
		palettes: true
	};
	
	jQuery('.mailing_fields').hide();
	if (jQuery('#mail_lists').length > 0) {
		jQuery('#mail_lists').on('change', function() {
			var vCurrVal = jQuery(this).val();
			jQuery('.mailing_fields').each(function() {
				if (jQuery(this).data('mailind') == vCurrVal) {
					jQuery(this).show();
				} else {
					jQuery(this).hide();
				}
			});
		});
		
		jQuery('#mail_lists').change();
	}
	
	jQuery('.input_video_type').prop( "disabled", true );
	
	jQuery('.video_type_field').hide();
	if (jQuery('#single_link_video_container').length > 0) {
		jQuery('#single_link_video_container').on('change', function() {
			var vCurrVal = jQuery(this).val();
			jQuery('.video_type_field').each(function() {
				if (jQuery(this).data('video-type') == vCurrVal) {
					if(jQuery(this).hasClass('input_video_type')) {
						jQuery(this).prop( "disabled", false );
					}
					jQuery(this).show();
				} else {
					if(jQuery(this).hasClass('input_video_type')) {
						jQuery(this).prop( "disabled", true );
					}
					jQuery(this).hide();
				}
			});
			
		});
		
		jQuery('#single_link_video_container').change();
	}


	
	
	jQuery('#soverlay').select2({});
	
  //jQuery('#get-lists').prop( "disabled", true );
	jQuery('#get-lists').on('click', function() {
		var eArr = {};
		var vClientID = jQuery('#campaignmonitor_client_id').val();
		var vApiKey   = jQuery('#campaignmonitor_api_key').val();
		var data = { 
					 action: 'get_cm_list', 
					 client_id : vClientID,
					 api_key : vApiKey
				  };
			
			jQuery('#campaignmonitor_list_id').find('option').remove();
			jQuery.post(ajaxurl, data, function(array_in) {
					var array_in = jQuery.parseJSON(array_in);
					jQuery('#campaignmonitor_list_id').find('option').remove();
					
					jQuery.each(array_in, function(index, item) {
						jQuery('#campaignmonitor_list_id').append(jQuery('<option>', {value:item['ListID'], text: item['Name']}));
					});
					jQuery('#campaignmonitor_list_id').select2("open");
					
			});							
			
		return false;
	});


	jQuery('#get-companies').on('click', function() {
		var eArr = {};
		var vApiKey   = jQuery('#getresponse_api_key').val();
		var data = {
					 action: 'get_gr_companies',
					 api_key : vApiKey
				  };

			jQuery('#getresponse_company_id').find('option').remove();
			jQuery.post(ajaxurl, data, function(array_in) {
					var array_in = jQuery.parseJSON(array_in);
					jQuery('#getresponse_company_id').find('option').remove();

					jQuery.each(array_in, function(index, item) {
						jQuery('#getresponse_company_id').append(jQuery('<option>', {value:item['ID'], text: item['Name']}));
					});
					jQuery('#getresponse_company_id').select2("open");

			});

		return false;
	});

	jQuery('#export-emails').on('click', function() {
		var eArr = {};
		var mailLists   = jQuery('#mail_lists').val();
        var grApiKey   = jQuery('#getresponse_api_key').val();
        var cmApiKey   = jQuery('#campaignmonitor_api_key').val();
        var cmListId   = jQuery('#campaignmonitor_list_id').val();
        var chApiKey   = jQuery('#mailchimp_app_id').val();
        var chListId   = jQuery('#mailchimp_list_id').val();
		var data = {
					action: 'export_emails',
            		mail_lists : mailLists,
            		gr_api_key : grApiKey,
            		cm_api_key : cmApiKey,
            		cm_list_id : cmListId,
            		ch_api_key : chApiKey,
            		ch_list_id : chListId,

				  };

			jQuery('#getresponse_company_id').find('option').remove();
			// jQuery.post(ajaxurl, data, function(array_in) {});
        jQuery.ajax({
            type : "post",
            url : ajaxurl,
            data : data,
            success: function(response) {
                console.log('response', response);
                jQuery('#export-emails').next().show();
            },
			beforeSend: function(){
            	jQuery('#export-emails').next().hide();
			}
        })

        return false;
	});




	jQuery('#color-countdown').wpColorPicker(vColorPickerOptions);
	jQuery('#color-font-countdown').wpColorPicker(vColorPickerOptions);
	
	if (jQuery('.remove-btn').length > 0) {
		jQuery('.remove-btn').on('click', function() {
			jQuery(this).closest('.input-group.date').find('input').val('');
			return false;
		});
	}	
	
	jQuery('#expiry_time_start, #expiry_time_end').datetimepicker({
			pickDate: false
	});
	jQuery('#expiry_date_start, #expiry_date_end').datetimepicker({
			sideBySide: true,		 
			useSeconds: false,
			useStrict: 	true,
			pickTime:   false
	});
	
	jQuery("#mt-gallery-tabs" ).tabs();

	if (jQuery('#enter_button_checkbox').length > 0) {
        if (jQuery('#enter_button_checkbox').prop("checked")) {
            jQuery('#enter_site_text').prop('disabled', false);
        } else {
            jQuery('#enter_site_text').prop('disabled', true);
        }
    }
    
    jQuery('#enter_button_checkbox').on('change', function() {
        if (jQuery(this).prop("checked")) {
            jQuery('#enter_site_text').prop('disabled', false);
        } else {
            jQuery('#enter_site_text').prop('disabled', true);
        }
        
    });

	if (jQuery('#503_enabled').length > 0) {
        if (jQuery('#503_enabled').prop("checked")) {
            jQuery('#enter_button_checkbox, #enter_site_text').prop('disabled', true);
        } else {
            jQuery('#enter_button_checkbox, #enter_site_text').prop('disabled', false);
        }
    }
    
    jQuery('#503_enabled').on('change', function() {
        if (jQuery(this).prop("checked")) {
            jQuery('#enter_button_checkbox, #enter_site_text').prop('disabled', true);
        } else {
            jQuery('#enter_button_checkbox, #enter_site_text').prop('disabled', false);
        }
        
    });

});