(function($) {
  
  // helper functions

  var trim = function(str)
  {
      return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g,'');
  };

  var hasClass = function(el, cn)
  {
      return (' ' + el.className + ' ').indexOf(' ' + cn + ' ') !== -1;
  };

  var addClass = function(el, cn)
  {
      if (!hasClass(el, cn)) {
          el.className = (el.className === '') ? cn : el.className + ' ' + cn;
      }
  };

  var removeClass = function(el, cn)
  {
      el.className = trim((' ' + el.className + ' ').replace(' ' + cn + ' ', ' '));
  };

  var hasParent = function(el, id)
  {
      if (el) {
          do {
              if (el.id === id) {
                  return true;
              }
              if (el.nodeType === 9) {
                  break;
              }
          }
          while((el = el.parentNode));
      }
      return false;
  };
  
  var doc = document.documentElement;
  
  var transform_prop = window.Modernizr.prefixed('transform'),
      transition_prop = window.Modernizr.prefixed('transition'),
      transition_end = (function() {
          var props = {
              'WebkitTransition' : 'webkitTransitionEnd',
              'MozTransition'    : 'transitionend',
              'OTransition'      : 'oTransitionEnd otransitionend',
              'msTransition'     : 'MSTransitionEnd',
              'transition'       : 'transitionend'
          };
          return props.hasOwnProperty(transition_prop) ? props[transition_prop] : false;
      })();
  
  var OffCanvasMenu = {
    
    _init: false,
    app: { },
    menu_bar: null,
    inner: function() {
      return MobileSmartPro.site_container_id ? document.getElementById(MobileSmartPro.site_container_id) : false; 
    },
    nav_open: false,
    nav_class: 'js-nav',
    
    init: function() {
      this.hideDesktopMenu();
      this.initOffCanvasMenu();
    },
    
    hideDesktopMenu: function() {
      // off_canvas_menu_hide set in Mobile Smart Pro settings
      if (MobileSmartPro.off_canvas_menu_hide) {
        $(MobileSmartPro.off_canvas_menu_hide).hide();
      }
    },
    
    closeNavEnd: function(e, echo_from) {
      var self = this;
      if (e && e.target === OffCanvasMenu.inner()) {
          document.removeEventListener(transition_end, OffCanvasMenu.closeNavEnd, false);
      }
      OffCanvasMenu.nav_open = false;
      console.log('setting as false', echo_from);
    },
    
    closeNav: function() {
      var self = this;
      if (this.nav_open) {
          // close navigation after transition or immediately
          var duration = (transition_end && transition_prop) ? parseFloat(window.getComputedStyle(this.inner(), '')[transition_prop + 'Duration']) : 0;
          if (duration > 0) {
              document.addEventListener(transition_end, OffCanvasMenu.closeNavEnd, false);
          } else {
              this.closeNavEnd(null, 'null');
          }
      }
      removeClass(doc, this.nav_class);
    },
    
    openNav: function() {
      if (this.nav_open) {
          return;
      }
      addClass(doc, this.nav_class);
      this.nav_open = true;
    },
    
    toggleNav: function(e) {
      console.log('toggleNav', this.nav_open);
      if (this.nav_open && hasClass(doc, this.nav_class)) {
        this.closeNav();
      } else {
        this.openNav();
      }
      if (e) {
        e.preventDefault();
      }
    },
    
    initOffCanvasMenu: function() {
      var self = this;
    
      if (this._init) {
          return;
      }
      this._init = true;
      
      this.menu_bar = $('#mobile-smart-pro-title-bar.menu-type-bar');
      
      if (this.menu_bar.length) {
        //this.menu_bar.appendTo('body');
      }

      // open nav with main "nav" button
      document.getElementById('mobile-smart-pro-nav-open-btn').addEventListener('click', function(e) { self.toggleNav(e); } , false);

      // close nav with main "close" button
      document.getElementById('mobile-smart-pro-nav-close-btn').addEventListener('click', function(e) { self.toggleNav(e); }, false);

      // close nav by touching the partial off-screen content
      document.addEventListener('click', function(e)
      {
          if (self.nav_open && !hasParent(e.target, 'mobile-smart-pro-off-canvas-nav')) {
              e.preventDefault();
              self.closeNav();
          }
      },
      true);

      addClass(doc, 'js-ready');

    },
    
  };
  
  $(function() {
    
    OffCanvasMenu.init();
    
  });
  
})(jQuery);