<?php
/**
 * Manages the Mobile Smart Admin
 */
 
class MobileSmartAdmin extends MobileSmartAdminBase {
  
  const TAB_MOBILE_THEME = 1;
  const TAB_DOMAIN_SWITCHING = 2;
  const TAB_MANUAL_SWITCHING = 3;
  const TAB_TRANSCODING = 4;
  const TAB_MOBILE_PAGES = 5;
  const TAB_MOBILE_PLUGINS = 6;
  const TAB_MOBILE_MENUS = 7;
  
  var $admin_optionsName = "MobileSmartOptions";
  
  
  /**
   * constructor
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
     
    add_action('admin_menu', array($this, 'createAdminPanel'));
  }
  
  
  /**
   * getMobileSmartInstance function.
   * 
   * @access protected
   * @return void
   */
  protected function getMobileSmartInstance() {
    global $mobile_smart;
    
    if (!isset($this->mobile_smart) || !$this->mobile_smart) {
      $this->mobile_smart = $mobile_smart;
    }
    
    return $this->mobile_smart;
  }
  
  
  /**
   * create the admin panel
   * 
   * @access public
   * @return void
   */
  public function createAdminPanel()
  {
    if (is_plugin_active(MOBILESMART_PLUGIN_FOLDER.'/'.MOBILESMART_BASENAME)) {
      add_options_page("Mobile Smart Pro", "Mobile Smart Pro", 'manage_options', MOBILESMART_BASENAME, array($this, 'displayAdminOptions'));
    }
  }
  
  // -------------------------------------------------------------------------
  // Method: displayAdminOptions
  // Description: displays the admin panel
  // -------------------------------------------------------------------------
  public function displayAdminOptions()
  {
    $options = $this->getAdminOptions();
    
    if (is_multisite()) {
      $args = array('allowed'=>true, 'errors'=>false);
    }
    else {
      $args = null;
    }
    
    $themes = wp_get_themes($args);
    
    $current_tab = (isset($_GET['tab']) ? filter_var($_GET['tab'], FILTER_SANITIZE_STRING) : 1);
    
    /*echo '<pre>';
    print_r($_POST);
    echo '</pre>';*/

    if (isset($_POST['submit']))
    {
      $status_messages = array();
      
      switch ($current_tab)
      {
        case self::TAB_MOBILE_THEME:
          // Enable / Disable theme switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_theme_switching', __('Theme switching', MOBILESMART_DOMAIN));
          
          // Save theme
          $status_messages[] = $this->adminSaveTheme($options);
          
          // Enable / Disable switching for tablets
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'switch_for_tablets', __('Switching for Tablets', MOBILESMART_DOMAIN));
          
          // Add google Vary Header
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'add_vary_header', __('Add Vary Header', MOBILESMART_DOMAIN));
          
          // Switch for admin 
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'switch_for_admin', __('Switch for Admin', MOBILESMART_DOMAIN));
          break;
        case self::TAB_DOMAIN_SWITCHING:
          // Enable / Disable domain switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_domain_switching', __('Domain Redirect', MOBILESMART_DOMAIN));
          
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_domain_switching_only', __('Only Switch on Mobile Domain', MOBILESMART_DOMAIN));
          
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'only_switch_domain_on_valid_device', __('Only Switch Domain on Valid Device', MOBILESMART_DOMAIN));
          
          // Save Domain Switching URL
          $status_messages[] = $this->adminSetOptionFromTextboxURL($options, 'mobile_domain', __('Mobile Domain', MOBILESMART_DOMAIN));
          
          // desktop switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_domain_switching_to_desktop', __('Desktop Domain Redirect', MOBILESMART_DOMAIN));
          $status_messages[] = $this->adminSetOptionFromTextboxURL($options, 'desktop_domain', __('Desktop Domain', MOBILESMART_DOMAIN));
          
          // Save Domain Switching schema
          //$status_messages[] = $this->adminSetOptionFromDropdown($options, 'mobile_domain_schema', __('URL Schema', MOBILESMART_DOMAIN));
          
          // Save hide from SEO
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'hide_mobile_domain_from_search_engines', __('Hide Mobile Domain from Search Engines', MOBILESMART_DOMAIN));
          break;
        case self::TAB_MANUAL_SWITCHING:
          // Enable / Disable manual switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_manual_switch', __('Manual theme switching', MOBILESMART_DOMAIN));
          
          // Enable / Disable footer manual switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_manual_switch_in_footer', __('Manual theme switching in footer', MOBILESMART_DOMAIN));

          // Enable / Disable desktop manual switching
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'allow_desktop_switcher', __('Manual theme switching on desktop', MOBILESMART_DOMAIN));
          break;
        case self::TAB_TRANSCODING:
          // Enable / Disable image transcoding
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_image_transcoding', __('Image transcoding', MOBILESMART_DOMAIN));
          
          // width and height settings
          /*$status_messages[] = $this->adminSetOptionFromInput($options, 'transcoding_mobile_width', __('Image transcoding mobile width', MOBILESMART_DOMAIN));
          $status_messages[] = $this->adminSetOptionFromInput($options, 'transcoding_mobile_height', __('Image transcoding mobile height', MOBILESMART_DOMAIN));
          $status_messages[] = $this->adminSetOptionFromInput($options, 'transcoding_tablet_width', __('Image transcoding tablet width', MOBILESMART_DOMAIN));
          $status_messages[] = $this->adminSetOptionFromInput($options, 'transcoding_tablet_height', __('Image transcoding tablet height', MOBILESMART_DOMAIN));*/
          break;
        case self::TAB_MOBILE_PAGES:
          // Enable / Disable mobile pages
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_mobile_pages', __('Mobile Pages', MOBILESMART_DOMAIN));
          
          // Set mobile home page
          $status_messages[] = $this->adminSetOptionFromDropdown($options, 'mobile_home_page', __('Mobile Home Page', MOBILESMART_DOMAIN));
          
          // Set tablet home page
          $status_messages[] = $this->adminSetOptionFromDropdown($options, 'tablet_home_page', __('Tablet Home Page', MOBILESMART_DOMAIN));
          break;
        case self::TAB_MOBILE_PLUGINS:
          $status_messages = array_merge($status_messages, $this->adminSetDisabledPlugins($options, __('Mobile Plugins', MOBILESMART_DOMAIN)));
          break;
        case self::TAB_MOBILE_MENUS:
          // Enable / Disable mobile menus
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_mobile_menus', __('Mobile Menus', MOBILESMART_DOMAIN));
          
          // Enable / Disable responsive menu
          $status_messages[] = $this->adminSetOptionFromCheckbox($options, 'enable_responsive_menus', __('Off Canvas Menu Menu', MOBILESMART_DOMAIN));
          
          // Save menu mapping
          $status_messages[] = $this->adminSaveMenuMapping($options, 'menu_mapping', __('Menu mapping', MOBILESMART_DOMAIN));
          break;
      }

      // output status messages
      if (!empty($status_messages))
      {
        ?>
          <div class="updated">
            <?php foreach ($status_messages as $message) : ?>
              <p><strong><?php echo isset($message[1]) ? $message[1] : ''; ?></strong></p>
            <?php endforeach; ?>
          </div>
        <?php
      }

      // update the options
      $this->updateOptions($options);
    }

    // Display the admin page
    ?>
    <script type="text/javascript">
    </script>
    <div class="wrap">
      <style type="text/css" media="all">
        
        #mobilesmart_infobox {
          border: 1px solid #999;
          padding: 10px; margin: 10px;
          background-color: #efefef;
          float: right;
          width: 250px;
        }
        
        #mobilesmart_infobox .subsection {
          border: 1px solid #cdcdcd;
          padding: 10px; margin: 10px 0;
        }
        
        #mobilesmart_main_container h4 {
          font-size: 1.1em;
          margin-top: 2em;
        }
        
        #mobilesmart_main_container fieldset {
          background-color: white;
          padding: 15px;
          margin-bottom: 10px;
        }
        
        #mobilesmart_main_container fieldset.disabled {
          background-color: #ededed;
        }
        
        #mobilesmart_main_container fieldset.disabled input {
          pointer-events:none;
          color:#AAA;
          background:#F5F5F5;
        }
      </style>
        <h2>Mobile Smart Pro</h2>
        <div id="mobilesmart_infobox">
          <div class="subsection clearfix">
            <h3>Mobile Smart Newsletter</h3>
            <!-- Begin MailChimp Signup Form -->
            <div id="mc_embed_signup">
            <form action="http://dansmart.us2.list-manage.com/subscribe/post?u=d2059b426acf8c7232bd417a2&amp;id=eddd2b41ad" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank">
                <p><label for="mce-EMAIL">Sign up for Mobile Smart updates, plus articles on developing websites for mobile devices and WordPress. </label>
                <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="email address" required/></p>
                <div class="clear"><input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe" class="button"></div>
            </form>
            </div>

            <!--End mc_embed_signup-->
          </div>
        </div>
        <div id="mobilesmart_main_container">
          <p><em><strong>Mobile theme switching and more</strong></em></p>
          <p><strong>Tabs overview:</strong><br/><em>Mobile Theme: Set the mobile theme to be displayed when viewed on a mobile device</br>
            Domain Switching: Redirect to a mobile domain (e.g. m.yourdomain.com) when viewed on a mobile device<br/>
            Manual Switching: Add a link in footer (or widget) allowing user to switch between mobile and desktop versions<br/>
            Transcoding: Resize images to mobile scale<br/>
            Mobile Pages: Mobile versions of normal page content, mobile shortcodes, mobile home page<br/>
            Plugins: Disable selected plugins when you're on a mobile theme<br/>
            Mobile Menus: Manage mobile-only menus, replace your menu with a hamburger style off-canvas menu, and map theme locations</em>
          </p>
          <br class="clearfix"/>
          <?php
            function display_active_tab($tab, $current_tab)
            { 
              if ($current_tab == $tab) {
                echo 'nav-tab-active';
              }
            }
          ?>
          <h3 class="nav-tab-wrapper">
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_MOBILE_THEME)); ?>" class="nav-tab <?php display_active_tab(self::TAB_MOBILE_THEME, $current_tab); ?>">Mobile Theme</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_DOMAIN_SWITCHING)); ?>" class="nav-tab <?php display_active_tab(self::TAB_DOMAIN_SWITCHING, $current_tab); ?>">Domain Switching</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_MANUAL_SWITCHING)); ?>" class="nav-tab <?php display_active_tab(self::TAB_MANUAL_SWITCHING, $current_tab); ?>">Manual Switching</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_TRANSCODING)); ?>" class="nav-tab <?php display_active_tab(self::TAB_TRANSCODING, $current_tab); ?>">Transcoding</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_MOBILE_PAGES)); ?>" class="nav-tab <?php display_active_tab(self::TAB_MOBILE_PAGES, $current_tab); ?>">Mobile Pages</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_MOBILE_PLUGINS)); ?>" class="nav-tab <?php display_active_tab(self::TAB_MOBILE_PLUGINS, $current_tab); ?>">Mobile Plugins</a>
            <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_MOBILE_MENUS)); ?>" class="nav-tab <?php display_active_tab(self::TAB_MOBILE_MENUS, $current_tab); ?>">Mobile Menus</a>
          </h3>
          <form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
            <?php
              switch ($current_tab)
              {
                case self::TAB_MOBILE_THEME: $this->displayAdminTabMobileTheme($options, $themes); break;
                case self::TAB_DOMAIN_SWITCHING: $this->displayAdminTabDomainSwitching($options); break;
                case self::TAB_MANUAL_SWITCHING: $this->displayAdminTabManualSwitching($options); break;
                case self::TAB_TRANSCODING: $this->displayAdminTabTranscoding($options); break;
                case self::TAB_MOBILE_PAGES: $this->displayAdminTabMobilePages($options); break;
                case self::TAB_MOBILE_PLUGINS: $this->displayAdminTabMobilePlugins($options); break;
                case self::TAB_MOBILE_MENUS: $this->displayAdminTabMobileMenus($options); break;
                default: $this->displayAdminTabMobileTheme($options, $themes); break;
              }
            ?>

            <div class="submit">
              <input type="submit" name="submit" value="<?php _e('Update Settings', 'MobileSmart'); ?>" class="button button-primary"/>
            </div>
          </form>
        </div>
        
        <?php
/*
            echo "<pre>";                  
            var_dump($this->getAdminOptions());
            echo "</pre>";
*/
        ?>
    </div>
    <?php
  }
  
  /**
   * display mobile theme admin tab
   * @param type $options
   * @param type $themes 
   */
  public function displayAdminTabMobileTheme($options, $themes)
  {
    ?>
    <h3>Mobile Theme</h3>
    
    <h4>Mobile Switching</h4>
    <p>Enable switching via user agent detection:</p>
    <fieldset>
      <label for="enable_theme_switching">Enable <input type="checkbox" name="enable_theme_switching" id="enable_theme_switching" <?php if ($this->getOption('enable_theme_switching')) { echo "checked"; } ?>/></label>
    </fieldset>
    
    <p>Choose the mobile theme that will be displayed when a mobile device is detected.</p>
    <fieldset>      
      <label for="theme">Mobile theme: <select id="theme" name="theme">
          <?php            
            foreach ($themes as $theme_name => $theme)
            {
              ?>
              <option value="<?php echo $theme_name; ?>" <?php if ($theme->stylesheet == $this->getOption('mobile_theme')) { echo "selected"; } ?>><?php echo $theme['Name']; ?></option>
              <?php
            }
          ?>
        </select></label>
    </fieldset>
    
    <h4>Switch Theme for Tablets</h4>
    <p>
      <em>Most people choose to show the desktop theme on tablets such as iPads. You may wish to enable your mobile theme and pull
      in a tablet specific stylesheet and/or other content via the mobile theme.</em></p>
    <fieldset>
      <label for="switch_for_tablets">Enable theme switching for tablets (e.g. iPad):  <input type="checkbox" name="switch_for_tablets" id="switch_for_tablets" <?php if ($this->getOption('switch_for_tablets')) { echo "checked"; } ?>/></label>
    </fieldset>
    
    <h4>Advanced: Vary Header</h4>
    <p>
      If you have theme switching enabled, you can choose to add the 'Vary: User Agent' HTTP header which
      <a href="https://developers.google.com/webmasters/mobile-sites/mobile-seo/configurations/dynamic-serving?hl=en" target="_blank">Google recommends</a>a>
      to notify it that you are dynamically serving up different content depending on the device.  
    </p>
    <p><em>Please be aware of <a href="http://searchengineland.com/mobile-site-configuration-the-varies-header-for-enterprise-seo-163004" target="_blank">potential downsides</a> to enabling this header for CDNs</em></p>
    <fieldset>
      <label for="add_vary_header">Enable Vary Header:  <input type="checkbox" name="add_vary_header" id="add_vary_header" <?php if ($this->getOption('add_vary_header')) { echo "checked"; } ?>/></label>
    </fieldset>
    
    <h4>Developers test mode: </h4>
    <p>
	    There are two options. You can do one of the following:
    </p>
    <ol>
	    <li>
	    	<label for="switch_for_admin">Display mobile when viewing site as admin:  <input type="checkbox" name="switch_for_admin" id="switch_for_admin" <?php if ($this->getOption('switch_for_admin')) { echo "checked"; } ?>/></label>
	    </li>
	    <li>You can append a query parameter of 'testmobile=true' to your URL, e.g. <a href="<?php echo site_url(); ?>?testmobile=true"><?php echo site_url(); ?>?testmobile=true</a>.
	      This will enable you to view the site in mobile mode, before enabling switching above.
	    </li>
    </ol>
    <?php
  }
  
  /**
   * Display domain switching tab
   * @param type $options 
   */
  public function displayAdminTabDomainSwitching($options)
  {
    ?>
    <h3>Domain Switching</h3>
    
    <p>There are two ways to run your site with a mobile domain:
	    <ol>
		    <li>Recommended: One instance of WordPress, that serves up the desktop site to desktop users, and mobile site to mobile users. This enables you to re-use your content. <br/>
		    With this option, you can have a desktop domain and mobile domain, that point to the same instance of WordPress.<br/>
		    To do this, set up the mobile switching options below.</li>
		    <li>Two instances of WordPress, each with separate content, with a redirect between the two.<br/>
		    To do this, set up the mobile redirect and the desktop switching options below.
	    </ol>
    </p>
    
    <h4>Mobile Domain Switching</h4>
    <p>Enter your mobile domain and enable redirecting to the mobile domain. Use this if you are keeping <strong>one instance of WordPress</strong> for both
	    mobile and desktop versions of the site, with different URLs.</p>
	  <p>Make sure you read the notes <a href="#subdomains_dns">Subdomains and DNS</a>. Also check out the FAQ at <a href="http://mobile-smart.co.uk/frequently-asked-questions/">http://mobile-smart.co.uk/frequently-asked-questions/</a></p>
    <fieldset>
      <label for="mobile_domain"><strong>Your mobile domain: </strong><br/>
      <input type="text" name="mobile_domain" value="<?php echo $this->getOption('mobile_domain'); ?>"/></label><br/>
      <em>Leave blank if you're not using a mobile domain.</em>
    </fieldset>
       
    <fieldset>
      <label for="enable_domain_switching"><strong>Enable redirecting to mobile domain: </strong> <input type="checkbox" name="enable_domain_switching" id="enable_domain_switching" <?php if ($this->getOption('enable_domain_switching')) { echo "checked"; } ?>/></label><br/>
      <em>If a user arrives at your mobile subdomain, you can automatically redirect to the mobile theme by enabling domain redirecting.</em>
      <br/>
      <em>If you also have manual switching enabled, manual switching will take priority - so they will be redirected to the desktop version of the site
         until they switch back.
      </em>
    </fieldset>
    
    <fieldset>
      <label for="enable_domain_switching_only"><strong>Only switch theme on mobile domain: </strong> <input type="checkbox" name="enable_domain_switching_only" id="enable_domain_switching_only" <?php if ($this->getOption('enable_domain_switching_only')) { echo "checked"; } ?>/></label><br/>
      <em>Enable this if you do not want the mobile theme to display at any time other than when the user is on the mobile domain.</em>
    </fieldset>
    
    <fieldset>
      <label for="only_switch_domain_on_valid_device"><strong>Always redirect domain for device: </strong> <input type="checkbox" name="only_switch_domain_on_valid_device" id="only_switch_domain_on_valid_device" <?php if ($this->getOption('only_switch_domain_on_valid_device')) { echo "checked"; } ?>/></label><br/>
      <em>Enable this if you only want mobile users going to the mobile domain, and desktop users going to the desktop domain.</em>
    </fieldset>
    
    <hr/>
    <h4>Desktop Domain Switching</h4>
    <p>Some people want to maintain two WordPress sites - and just use Mobile Smart Pro to switch between them, dependent on the URL that is entered.<br/>
    If this is your <strong>mobile WordPress site only</strong>, then you can enter the desktop site information below to switch to it if a user arrives on a desktop device.
    </p>
    <fieldset>
      <label for="desktop_domain"><strong>Desktop domain: </strong><br/>
      <input type="text" name="desktop_domain" value="<?php echo $this->getOption('desktop_domain'); ?>"/></label><br/>
    </fieldset>
       
    <fieldset>
      <label for="enable_domain_switching_to_desktop"><strong>Enable redirecting to desktop domain: </strong> <input type="checkbox" name="enable_domain_switching_to_desktop" id="enable_domain_switching_to_desktop" <?php if ($this->getOption('enable_domain_switching_to_desktop')) { echo "checked"; } ?>/></label><br/>
      <em>If a user arrives at your mobile subdomain, you can automatically redirect to the desktop site.</em>
    </fieldset>
    
    <hr/>
    
    <h4 id="subdomains_dns"><em>Notes on subdomains and DNS</em></h4>
    <p><em>To use a mobile subdomain, you'll need to go to your DNS control panel (domain name), and create either an A record or a CNAME record
       pointing to the same location. An A record would point the to the same IP address, a CNAME record would point to the main domain.</em></p>
    <p><em>You will also need to configure your server to point the subdomain to your main account. This is called 'parking' on WHM, and 'domain alias' on Plesk, and 'add-on' domain on Hostgator.<br/>
      If you're on shared hosting, you may need to contact your hosting provider to do this.</em></p>
    
    <h3>Search Engines - Privacy</h3>
    <p>Currently your site is <?php echo get_option('blog_public') == '0' ? 'hidden from' : 'visible to'; ?> search engines.</p>
    <?php if (get_option('blog_public') !== '0') : ?>
    <fieldset>
      <label for="hide_mobile_domain_from_search_engines"><strong>Hide Mobile Domain from Search Engines: </strong></label>
      <input type="checkbox" name="hide_mobile_domain_from_search_engines" value="yes" <?php echo $this->getOption('hide_mobile_domain_from_search_engines') ? 'checked="checked"' : ''; ?>/>
    </fieldset>
    <?php endif; ?> 
    <?php
  }
  
  /**
   * display Transcoding admin tab
   * @param type $options 
   */
  public function displayAdminTabTranscoding($options)
  {
    ?>
    <h3>Transcoding</h3>
    
    <h4>Enable image transcoding</h4>
    
    <p><em>Manual switching (above) must be enabled for this to work properly.</em></p>
    <fieldset>
      <label for="enable_image_transcoding">Enable image transcoding <input type="checkbox" name="enable_image_transcoding" id="enable_image_transcoding" <?php if ($this->getOption('enable_image_transcoding')) { echo "checked"; } ?>/></label>
    </fieldset>
    <!--<h4>Image sizes</h4>
    <p><em>The following settings determine the maximum size of images for each tier, though your theme's CSS will determine the actual display. If you change the sizes here, you may need to <a href="https://wordpress.org/plugins/regenerate-thumbnails/">Regenerate your thumbnails</a>
       to resize all the images to your new sizes. Images will be resized rather than cropped.</em></p>
    <fieldset class="<?php echo $this->getOption('enable_image_transcoding') ? '' : 'disabled'; ?>">
      <strong>Mobile device image max width / height</strong><br/>
      <label for="transcoding_mobile_width">Width</label> <input type="text" name="transcoding_mobile_width" value="<?php echo $this->getOption('transcoding_mobile_width') ? $this->getOption('transcoding_mobile_width') : MOBILE_DEVICE_TIER_TOUCH_MAX_WIDTH; ?>" />
      <label for="transcoding_mobile_height">Height</label> <input type="text" name="transcoding_mobile_height" value="<?php echo $this->getOption('transcoding_mobile_height') ? $this->getOption('transcoding_mobile_height') : MOBILE_DEVICE_TIER_TOUCH_MAX_HEIGHT; ?>" />
    </fieldset>
    <fieldset class="<?php echo $this->getOption('enable_image_transcoding') ? '' : 'disabled'; ?>">
      <strong>Tablet image max width / height</strong><br/>
      <label for="transcoding_tablet_width">Width</label> <input type="text" name="transcoding_tablet_width" value="<?php echo $this->getOption('transcoding_tablet_width') ? $this->getOption('transcoding_tablet_width') : MOBILE_DEVICE_TIER_TABLET_MAX_WIDTH; ?>" />
      <label for="transcoding_tablet_height">Height</label> <input type="text" name="transcoding_tablet_height" value="<?php echo $this->getOption('transcoding_tablet_height') ? $this->getOption('transcoding_tablet_height') : MOBILE_DEVICE_TIER_TABLET_MAX_HEIGHT; ?>" />
    </fieldset>-->
    <?php
  }
  
  /**
   * Display Manual Switching admin tab
   * @param type $options 
   */
  public function displayAdminTabManualSwitching($options)
  {
    ?>
    <h3>Manual Switching</h3>
    
    <h4>Enable Manual Switcher</h4>
    <p>You can add a link to your pages which will allow the user to manually select the version
     (desktop or mobile) that they want. Once you enable Manual Switching, you can use either the
     footer link or the Mobile Smart Manual Switcher widget.</p>
    <fieldset>
      <label for="enable_manual_switch"><strong>Enable Manual Switcher:</strong> <input type="checkbox" name="enable_manual_switch" id="enable_manual_switch" <?php if ($this->getOption('enable_manual_switch')) { echo "checked"; } ?>/></label>
    </fieldset>

    <h4>Enable a Manual Switcher link in the footer</h4>
    <p><em>Manual switching (above) must be enabled for this to work properly.</em></p>
    <fieldset>
      <label for="enable_manual_switch_in_footer"><strong>Enable Manual Switcher in footer:</strong> <input type="checkbox" name="enable_manual_switch_in_footer" id="enable_manual_switch_in_footer" <?php if ($this->getOption('enable_manual_switch_in_footer')) { echo "checked"; } ?>/></label>
    </fieldset>

    <h4>Allow manual switching on desktop</h4>
    <p>This is most useful for debugging your themes. You probably
    do not want to allow your users to switch to the mobile version whilst viewing on a desktop in other cases.</p>
    <p><em>Manual switching (above) must be enabled for this to work properly.</em></p>
    <fieldset>
      <label for="allow_desktop_switcher"><strong>Enable Manual Switcher Link whilst on Desktop</strong> <input type="checkbox" name="allow_desktop_switcher" id="allow_desktop_switcher" <?php if ($this->getOption('allow_desktop_switcher')) { echo "checked"; } ?>/></label>
    </fieldset>
    <?php
  }
  
  /**
   * Display Mobile Pages admin tab
   * @param type $options 
   */
  public function displayAdminTabMobilePages($options)
  {
    ?>
    <h3>Mobile Pages</h3>
    
    <h4>Mobile content</h4>
    <p>It can be beneficial to have mobile versions of your content, specifically targeted at the smaller mobile pages. Once enabled, on each Edit Post or Edit Page (or other custom post types) screen
       you will see a box called 'Mobile Pages', which you can enter mobile-specific content in. If you do not add any content, it will just use
       the existing content.</p>
    <fieldset>
      <label for="enable_mobile_pages"><strong>Enable Mobile content:</strong> <input type="checkbox" name="enable_mobile_pages" <?php if ($this->getOption('enable_mobile_pages')) { echo "checked"; } ?>/></label>
    </fieldset>
    <h4>Mobile Shortcodes</h4>
    <p>Note that you can also use the shortcodes whether or not mobile switching or mobile pages is enabled. The following shortcodes are available:
    </p>
    <h5>[is_mobile]</h5>
    <pre>[is_mobile]some content for mobile devices[/is_mobile]</pre>
    <p>This displays the content only if switched to a mobile device (unless user has manually switched to desktop theme)</p>
    <h5>[is_tablet]</h5>
    <pre>[is_tablet]some content for tablets[/is_tablet]</pre>
    <p>This displays the content only if viewing from a tablet</p>
    <h5>[is_desktop]</h5>
    <pre>[is_desktop]some content for desktops[/is_desktop]</pre>
    <p>This displays the content only if viewing from a desktop, or the user has manually switched to the desktop theme</p>
    
    <h4>Mobile home page</h4>
    <p>You can change which page is designated as your static home page, which will override the setting in <a href="<?php echo admin_url(); ?>/options-reading.php">Settings -> Reading</a> when on a mobile device.</p>
    <fieldset>
      <label for="mobile_home_page"><strong>Mobile home page:</strong>
      <?php 
          $args = array('name'=>'mobile_home_page', 'show_option_none'=>'Do not override', 'option_none_value'=>'');
          if ($this->getOption('mobile_home_page')) {
            $args['selected'] = $this->getOption('mobile_home_page');
          }
          wp_dropdown_pages($args); ?></label>
    </fieldset>
    <h4>Tablet home page</h4>
    <p>If set, this will override the 'Mobile home page' setting.</p>
    <fieldset>
      <label for="tablet_home_page"><strong>Tablet home page:</strong>
      <?php 
          $args = array('name'=>'tablet_home_page', 'show_option_none'=>'Do not override', 'option_none_value'=>'');
          if ($this->getOption('tablet_home_page')) {
            $args['selected'] = $this->getOption('tablet_home_page');
          }
          wp_dropdown_pages($args); ?></label>
    </fieldset>

    <?php
  }
  
  /**
   * display plugins admin tab
   * @param type $options 
   */
  public function displayAdminTabMobilePlugins($options)
  {
    ?>
    <h3>Mobile Plugins</h3>
    
    <h4>Mobile Device: Disable plugins</h4>
    
    <p>Check the box of any plugin you want to temporarily disable when your site is being viewed by a mobile device. The plugin will <em>not</em> be disabled or deactivated, and will not run its deactivation routine. This is
       purely a temporary disabling for the individual user viewing the site with a mobile device.</p>
    <fieldset>
    <?php $plugins = get_plugins();
    
        if (! current_user_can( 'activate_plugins' ) ) {
          echo 'You do not have privileges to manage plugins';
          return;
        }
    
        if (!empty($plugins)) : ?>
        <ul>
    <?php foreach ($plugins as $plugin_key => $plugin) : 
            $checked = (isset($options['plugins']) && $options['plugins'] && in_array($plugin_key, $options['plugins']) ? 'checked="checked"' : '');
    ?>
          <li><input type="checkbox" <?php echo $checked; ?> name="plugins[]" value="<?php echo $plugin_key; ?>"/> <label for="plugin"><?php echo $plugin['Name']; ?>
              - <small><?php if ( is_plugin_active($plugin_key) ) : echo 'Currently Active'; else : echo 'Currently Inactive'; endif; ?></small></li>      
    <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    </fieldset>
    
    <h4>Tablets: Disable plugins</h4>
    
    <p>Check the box of any plugin you want to temporarily disable when your site is being viewed by a tablet.</p>

    <fieldset>
    <?php $plugins = get_plugins();
    
        if (! current_user_can( 'activate_plugins' ) ) {
          echo 'You do not have privileges to manage plugins';
          return;
        }
    
        if (!empty($plugins)) : ?>
        <ul>
    <?php foreach ($plugins as $plugin_key => $plugin) : 
            $checked = (isset($options['tablet_plugins']) && $options['tablet_plugins'] && in_array($plugin_key, $options['tablet_plugins']) ? 'checked="checked"' : '');
    ?>
          <li><input type="checkbox" <?php echo $checked; ?> name="tablet_plugins[]" value="<?php echo $plugin_key; ?>"/> <label for="tablet_plugin"><?php echo $plugin['Name']; ?>
              - <small><?php if ( is_plugin_active($plugin_key) ) : echo 'Currently Active'; else : echo 'Currently Inactive'; endif; ?></small></li>      
    <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    </fieldset>
    <?php
  }
  
  
  /**
   * displayAdminTabMobileMenus function.
   * 
   * @access public
   * @param mixed $options
   * @return void
   */
  public function displayAdminTabMobileMenus($options) {
    
    $desktop_theme_locations = get_registered_nav_menus();
    
    ?>
    <h3>Mobile Menus</h3>
    
    <h4>Enable Mobile menus</h4>
    <p>You may wish to have mobile-only menus. This adds mobile-specific versions of your theme locations, so that
       you can assign mobile-specific menus to them. If there is no menu assigned, it will use your existing menu.
       <em>Note: this only works with wp_nav_menu().</em><br/>
       <a href="<?php echo admin_url(); ?>nav-menus.php">Manage your mobile menus</a></p>
    <fieldset>
      <label for="enable_mobile_menus"><strong>Enable Mobile menus:</strong> <input type="checkbox" name="enable_mobile_menus" <?php if ($this->getOption('enable_mobile_menus')) { echo "checked"; } ?>/></label>
    </fieldset>
    
    <?php if (RESPONSIVE_MENUS_ENABLED) : ?>
    <h4>Display Mobile Responsive Off-Canvas Menu</h4>
    <p>You can replace your normal nav menu with a mobile "hamburger" menu icon that opens an off-canvas navigation menu. If you enable this here,
       you can then configure the responsive off-canvas menu on the Appearance -> Mobile Smart Pro Menu screen.
    </p>
    <fieldset>
      <p>
        <label for="enable_responsive_menu"><strong>Enable Off-Canvas Menu:</strong> <input type="checkbox" name="enable_responsive_menus" <?php if ($this->getOption('enable_responsive_menus')) { echo "checked"; } ?>/></label>
      </p>
      <?php if ($this->getOption('enable_responsive_menus')) : ?>
        <p>Now you can configure the menu on the Appearance -> Mobile Smart Pro Menu screen.</p>
      <?php endif; ?>
    </fieldset>
    <?php endif; ?>

    <h4>Menu Theme Location mapping</h4>
    <p>Nav menus are assigned in the Menu -> Appearances If the themes have the same theme location names, they will automatically map. Sometimes themes
      have different nav menu names - if your mobile menu isn't appearing on your mobile device, you may want to assign a mapping from the desktop theme location to the mobile theme location.</p>
    
    <fieldset>
      <?php
        $menu_mapping = $options['menu_mapping'];
        
        //$mobile_theme_locations = $this->getMobileThemeMenus($options);
        
        if (count($desktop_theme_locations)) :        
          foreach ($desktop_theme_locations as $desktop_theme_key => $desktop_theme_location) : 
            if (stripos($desktop_theme_key, 'mobile-') === false) : ?>
            <p>
              <strong>Map <code><?php echo $desktop_theme_key; ?></code>  ("<?php echo $desktop_theme_location; ?>") to: </strong><input type="text" name="menu_mapping[<?php echo $desktop_theme_key; ?>]" value="<?php echo isset($menu_mapping[$desktop_theme_key]) ? $menu_mapping[$desktop_theme_key] : $desktop_theme_key; ?>"/>
            </p>
        <?php        
            endif;
          endforeach; 
        else :  ?>
        <p>Your current theme doesn't have any menu theme locations attached.</p>
        <?php
        endif; ?>
        
    </fieldset>
    <p>
      <strong>Notes:</strong> To do this, you'll have to look for register_nav_menu() in your mobile theme's PHP code (often - but not always - in functions.php), and look for some code like the following:
    </p>
    <pre>
      register_nav_menus( array(
  			'primary' => ( 'Main Navigation' ),
  			'footer-nav' => ( 'Footer Navigation' ),
  		) );
    </pre>
    <p>The value you want is the bit before the =>, e.g. <code>primary</code> or <code>footer-nav</code> - it will depend on your theme. You may want to
      ask a developer to help you.
    </p>

    <?php
  }
  
  
  /**
   * save the theme.
   * 
   * @access protected
   * @param mixed $options
   * @return void
   */
  protected function adminSaveTheme(&$options) {
    $status_message = '';
    
    // Get choice of mobile theme
    if ($this->getOption('mobile_theme') != $_POST['theme'])
    {
      $theme_name = $_POST['theme'];
      
      $theme = wp_get_theme($theme_name);

      $options['mobile_theme'] = $theme->stylesheet;
      $options['mobile_theme_template'] = $theme['Template'];
      $options['mobile_theme_stylesheet'] = $theme->stylesheet;

      $status_message = array('updated', __('Mobile theme updated to: ', MOBILESMART_DOMAIN) . $theme['Name']);
    }
    
    return $status_message;
  }
  
  
  /**
   * adminSaveMenuMapping function.
   * 
   * @access private
   * @param mixed &$options
   * @param mixed $meta_key
   * @param mixed $label
   * @return void
   */
  private function adminSaveMenuMapping(&$options, $meta_key, $label) {
    $status_message = array();
    
    if (isset($_POST[$meta_key])) {
      $options[$meta_key] = $_POST[$meta_key];
      
      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }
    else {
      $options[$meta_key] = null;
      
      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }
    
    return $status_message;
  }
  
  /**
   * Set the disabled plugin meta data option from the admin
   * @param array $options
   * @param type $label
   * @return array status message array
   */
  private function adminSetDisabledPlugins(&$options, $label)
  {
    $status_message = array();
    if (isset($_POST['plugins']))
    {
      $options['plugins'] = $_POST['plugins'];
      
      $status_message[] = array('updated', $label.' : '.__('added plugins to the disabled list for mobile', MOBILESMART_DOMAIN));
    }
    else
    {
      // disable theme switching
      if ($this->getOption('plugins') != false)
      {
        $options['plugins'] = false;

        $status_message[] = array('updated', $label.' : '.__('all active plugins enabled on mobile', MOBILESMART_DOMAIN));
      }
    }
    
    if (isset($_POST['tablet_plugins']))
    {
      $options['tablet_plugins'] = $_POST['tablet_plugins'];
      
      $status_message[] = array('updated', $label.' : '.__('added plugins to the disabled list for tablets', MOBILESMART_DOMAIN));
    }
    else
    {
      // disable theme switching
      if ($this->getOption('tablet_plugins') != false)
      {
        $options['tablet_plugins'] = false;

        $status_message[] = array('updated', $label.' : '.__('all active plugins enabled on tablet', MOBILESMART_DOMAIN));
      }
    }

    return $status_message;
  }
  
  
  /**
   * getMobileThemeMenus function.
   * 
   * @access private
   * @return void
   */
  protected function getMobileThemeMenus($options) {
    
    global $dantest;
    $dantest = true;
    
    // get themes
    $current_theme = wp_get_theme();
    $current_stylesheet = $current_theme['Stylesheet'];
    $mobile_theme_stylesheet = $this->getOption('mobile_theme_stylesheet');
    $mobile_theme = wp_get_theme($mobile_theme_stylesheet);
    
    echo "<pre>";                  
    print_r($mobile_theme);
    echo "</pre>";
    die();
    
    // switch temporarily to mobile theme - this doesn't work as it doesn't re-run the functions.php
    switch_theme($mobile_theme_stylesheet);
    
    // get nav menus
    $theme_locations = get_registered_nav_menus();
    $nav_menu_locations = get_nav_menu_locations();
    
    global $_wp_registered_nav_menus;
    echo "<pre>";
    print_r($_wp_registered_nav_menus);
    echo "</pre>";
    
    // go back to current theme
    switch_theme($current_stylesheet);
    
    die('die - getMobileThemeMenus');
    
    return $nav_menu_locations;
  }

}