<?php
/**
 * MobileSmartAdminBase - base class for admin
 */
 
class MobileSmartAdminBase extends MobileSmartPluginBase {
  
  /**
   * Set meta data option from a checkbox in the admin
   * @param array $options
   * @param type $meta_key
   * @param type $label
   * @return array status message array
   */
  protected function adminSetOptionFromCheckbox(&$options, $meta_key, $label = '')
  {
    $status_message = array();
    if (isset($_POST[$meta_key]))
    {
      // enable option
      if (!isset($options[$meta_key]) || $options[$meta_key] != true)
      {
        $options[$meta_key] = true;

        $status_message = array('updated', $label.' : '.__('enabled', MOBILESMART_DOMAIN));
      }
    }
    else
    {
      // disable option
      if (!isset($options[$meta_key]) || $options[$meta_key] != false)
      {
        $options[$meta_key] = false;

        $status_message = array('updated', $label.' : '.__('disabled', MOBILESMART_DOMAIN));
      }
    }

    return $status_message;
  }
  
  /**
   * Set meta data option from a text input in the admin
   * @param array $options
   * @param type $meta_key
   * @param type $label
   * @return array status message array
   */
  protected function adminSetOptionFromInput(&$options, $meta_key, $label = '')
  {
    $status_message = array();
    if (isset($_POST[$meta_key]))
    {
      $options[$meta_key] = filter_var($_POST[$meta_key], FILTER_SANITIZE_STRING);

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }
    else
    {
      $options[$meta_key] = '';

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }

    return $status_message;
  }
  
  /**
   * Set meta data option from a URL
   * @param array $options
   * @param type $meta_key
   * @param type $label
   * @return array status message array
   */
  protected function adminSetOptionFromTextboxURL(&$options, $meta_key, $label = '')
  {
    $status_message = array();
    if (isset($_POST[$meta_key]))
    {
      $options[$meta_key] = filter_var($_POST[$meta_key], FILTER_SANITIZE_URL);

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }
    else
    {
      $options[$meta_key] = '';

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }

    return $status_message;
  }
  
  
  /**
   * adminSetOptionFromDropdown function.
   * 
   * @access private
   * @param mixed &$options
   * @param mixed $meta_key
   * @param mixed $label
   * @return void
   */
  protected function adminSetOptionFromDropdown(&$options, $meta_key, $label = '') {
    $status_message = array();
    if (isset($_POST[$meta_key]))
    {
      $options[$meta_key] = filter_var($_POST[$meta_key], FILTER_SANITIZE_URL);

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }
    else
    {
      $options[$meta_key] = '';

      $status_message = array('updated', $label.' : '.__('saved', MOBILESMART_DOMAIN));
    }

    return $status_message;
  }
  
}