<?php
  /**
 * Mobile Smart - Body Class class
 * - updates the HTML body class with some useful CSS classes
 */
 
class MobileSmartBodyClass extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    add_filter('body_class', array(&$this, 'filter_addBodyClasses'));
  }
  
  /**
   * adds device specific CSS class to the body
   * 
   * @access public
   * @param mixed $classes
   * @return void
   */
  function filter_addBodyClasses($classes)
  {
    global $mobile_smart;
    
    // if theme switching enabled
    if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_THEME_SWITCHING) == true)
    {
      // if is a mobile device
      if ($this->isMobile())
      {
        $classes[] .= "mobile" ;
      }

      // add current device string to body class
      $classes[] .= $mobile_smart->getCurrentDevice();

      // add the tier of device also to body class
      $classes[] .= $mobile_smart->getCurrentDeviceTier();
    }

    return $classes;
  }
  
}