<?php
/**
 * Mobile Smart current user role - provides a way to get the role even when in MU plugin
 */
 
class MobileSmartCurrentUserRole extends MobileSmartPluginBase {
	
	const ROLE_COOKIE_NAME = 'mobile_smart_cu';
	
	
	/**
	 * __construct function.
	 * 
	 * @access public
	 * @return void
	 */
	public function __construct() {
		add_action('wp_login', array($this, 'user_logged_in'), 99, 2);
		add_action('wp_logout', array($this, 'user_logged_out'));
	}
	
	/**
    * set cookie upon login to get current role.
    * 
    * @access public
    * @param mixed $login
    * @param mixed $user (default: null)
    * @return void
    */
   public function user_logged_in($login, $user=null) {
			if (is_null($user)) {
				$user=wp_get_current_user();
			}
			
			foreach($user->roles as $key=>$role) {
				setcookie(self::ROLE_COOKIE_NAME.'['.$key.']', $role, 0 ,"/");
			}
		}
		
		
		/**
		 * remove logged in cookie.
		 * 
		 * @access public
		 * @return void
		 */
		public function user_logged_out() {
			if (isset($_COOKIE[self::ROLE_COOKIE_NAME]) && is_array($_COOKIE[self::ROLE_COOKIE_NAME])) {
				foreach($_COOKIE[self::ROLE_COOKIE_NAME] as $key=>$cookieVal) {
					setcookie(self::ROLE_COOKIE_NAME.'['.$key.']', '', time()-999999 ,"/");
				}
			}
		}
		
		/**
	  * currentUserHasRole function.
	  * 
	  * @access public
	  * @param mixed $role
	  * @static
	  * @return void
	  */
	 public static function currentUserHasRole( $role ) {
		 $result = false;
		 
		 // if we're in a normal hook (not in MU plugin)
		 if ( function_exists('is_user_logged_in') ) {
			 $result = current_user_can( $role );
		 }
		 // else we're in MU plugin, which is before pluggable functions are loaded, we have to 
		 else {
 			  $assignedRoles = array();
			 	// if a user is logged in
				if (@count(@preg_grep('/^wordpress_logged_in/', @array_keys($_COOKIE))) > 0) {
					if ( isset($_COOKIE[self::ROLE_COOKIE_NAME]) && is_array($_COOKIE[self::ROLE_COOKIE_NAME]) ) {
						$assignedRole = $_COOKIE[self::ROLE_COOKIE_NAME];
					}
				}
				
				if ( in_array( $role, $assignedRoles ) ) {
					$result = true;
				}
		 }
		 
		 return $result;
	 }
	
}