<?php
/**
 * Mobile Smart Detect
 * - manages the detection of devices
 */
 
// OPTIONS
define ('MOBILE_SMART_OPTION_SWITCH_FOR_TABLETS', 'switch_for_tablets');
 
// MAIN DEVICES (for more, see lib/mdetect.php which can be detected directly)
define ('MOBILE_DEVICE_OPERA_MINI', 'operamini');
define ('MOBILE_DEVICE_IPHONE', 'iphone');
define ('MOBILE_DEVICE_IPAD', 'ipad');
define ('MOBILE_DEVICE_IPOD', 'ipod');
define ('MOBILE_DEVICE_ANDROID', 'android');
define ('MOBILE_DEVICE_ANDROID_WEBKIT', 'android_webkit');
define ('MOBILE_DEVICE_ANDROID_TABLET', 'android table');
define ('MOBILE_DEVICE_SERIES60', 'series_60');
define ('MOBILE_DEVICE_SYMBIAN_OS', 'symbian_os');
define ('MOBILE_DEVICE_WINDOWS_MOBILE', 'windows_mobile');
define ('MOBILE_DEVICE_WINDOWS_PHONE_7', 'windows_phone_7');
define ('MOBILE_DEVICE_BLACKBERRY', 'blackberry');
define ('MOBILE_DEVICE_BLACKBERRY_TABLET', 'blackberry_tablet');
define ('MOBILE_DEVICE_BLACKBERRY_WEBKIT', 'blackberry_webkit');
define ('MOBILE_DEVICE_BLACKBERRY_TOUCH', 'blackberry_touch');
define ('MOBILE_DEVICE_PALM_OS', 'palm_os');
define ('MOBILE_DEVICE_OTHER', 'other_mobile');

// TIERS
define ('MOBILE_DEVICE_TIER_TOUCH', 'mobile-tier-touch');
define ('MOBILE_DEVICE_TIER_TABLET', 'mobile-tier-tablet');
define ('MOBILE_DEVICE_TIER_RICH_CSS', 'mobile-tier-rich-css');
define ('MOBILE_DEVICE_TIER_SMARTPHONE', 'mobile-tier-smartphone');
define ('MOBILE_DEVICE_TIER_OTHER', 'mobile-tier-other-mobile');
 
class MobileSmartDetect extends uagent_info {
  
    var $device = ''; // current device
    var $device_tier = ''; // current device tier

    var $switcher_cookie = null;
    
    var $detectmobile = false;
    var $detect_from_domain = false;
    var $detect_from_cookie = false;
    
    var $admin_options;
    var $admin_optionsName = "MobileSmartOptions";
    
    var $debugModeOn = false;
  
    
    /**
     * constructor
     * 
     * @access public
     * @return void
     */
    public function __construct() {
      // init parent constructor
      parent::uagent_info();
      
      $this->initOptions();
      
      //$this->setDebug();

      $this->initSwitcherCookie();
      
      add_action('plugins_loaded', array($this, 'action_handleSwitcherLink'));
    }
    
    /**
     * set the options
     * 
     * @access public
     * @param mixed $options
     * @return void
     */
    public function initOptions() {      
      // get the options from WP
      $wp_options = get_option($this->admin_optionsName);
    
      // set keys based on existing options - for backwards compatibility
      if (!empty($wp_options)) {
        // populate our adminOptions with wp options
        foreach($wp_options as $key=>$wp_option) {
          $this->admin_options[$key] = $wp_option;
        }
      }
    }
    
    /**
     * get all the admin options
     * 
     * @access public
     * @return void
     */
    public function getAdminOptions() {         
      return $this->admin_options;
    }
    
    
    /**
     * shorthand function to get option value by key
     * 
     * @access public
     * @param mixed $option_key
     * @return void
     */
    public function getOption($option_key) {
      $options = $this->getAdminOptions();
      
      if (isset($options[$option_key])) {
        return $options[$option_key];
      }
      
      return false;
    }
    
    /**
     * logDebug function.
     * 
     * @access private
     * @param mixed $message
     * @param mixed $var (default: null)
     * @return void
     */
    protected function logDebug($message, $var = null) {
      if ($this->debugModeOn) {
        echo '<pre>Mobile Smart Pro debug: '.$message;
        if ($var !== null) {
          var_dump($var);
        }
        echo '</pre>';
      }
    }
    
    /**
     * setDebug function.
     * 
     * @access protected
     * @param bool $on (default: true)
     * @return void
     */
    protected function setDebug($on = true) {
      $this->debugModeOn = $on;
    }
    
    //---------------------------------------------------------------------------
     // Function: switcher_isMobile
     // Description: determines whether the mode is mobile or switched
     // ---------------------------------------------------------------------------
     public function switcher_isMobile() {
        /*
  echo "<pre>";
        debug_print_backtrace();
        echo "</pre>";
  */
        $is_mobile = false;
  
        // get the mobile detect value
        $detectmobile = $this->DetectIsMobile();
        
        $this->logDebug('switcher_isMobile: $detectmobile: ', $detectmobile);
        
        $detect_domain = $this->DetectMobileDomain();
        $this->logDebug('switcher_isMobile: $detect_domain: ', $detect_domain);
        
        // if it's not on the mobile domain, and theme switching only enabled for the mobile domain, then we return false
        if (!$detect_domain && $this->getOption(MOBILE_SMART_ENABLE_DOMAIN_SWITCHING_ONLY)) {
          $is_mobile = false;
        }
        else {
/*
	        		echo "<pre>";                  
		          var_dump($detectmobile);
		          var_dump($detect_domain);
		          var_dump($this->getOption(MOBILE_SMART_ONLY_SWITCH_DOMAIN_ON_VALID_DEVICE));
		          echo "</pre>";	
*/
          if ($detect_domain === true)
          {
	          if ($detectmobile && !$this->getOption(MOBILE_SMART_ONLY_SWITCH_DOMAIN_ON_VALID_DEVICE)) {
	            $detectmobile |= $detect_domain;
	          } else if ($detectmobile && $this->getOption(MOBILE_SMART_ONLY_SWITCH_DOMAIN_ON_VALID_DEVICE)) {
		          $detectmobile = true;
	          } else if (!$detectmobile && !$this->getOption(MOBILE_SMART_ONLY_SWITCH_DOMAIN_ON_VALID_DEVICE)) {
		          $detectmobile = true;
	          }
          } else {
	          if (!$detectmobile && $this->getOption(MOBILE_SMART_ONLY_SWITCH_DOMAIN_ON_VALID_DEVICE)) {
	            $detectmobile = $detect_domain;
	          }
          }
  
          // check the switcher cookie
          $is_mobile = $this->switcher_getMobileCookieDetect($detectmobile);
          $this->logDebug('switcher_isMobile after cookie detect: $is_mobile: ', $is_mobile);
        }
        
        // apply filters
        $is_mobile = apply_filters('mobile_smart_switcher_is_mobile', $is_mobile);
        $is_tablet = $this->DetectIsTablet();
        $device_tier = $this->getCurrentDeviceTier();
        
        // run action        
        do_action('mobile_smart_is_mobile', $is_mobile);
        do_action('mobile_smart_is_tablet', $is_tablet);
        do_action('mobile_smart_update_device_tier', $device_tier);
        
        $this->logDebug('switcher_isMobile final: $is_mobile: ', $is_mobile);
  
        return $is_mobile;
     }
     
     
     /**
      * initSwitcherCookie function.
      * 
      * @access public
      * @return void
      */
     public function initSwitcherCookie() {
        $this->logDebug('Constructor: $_COOKIE output: ', $_COOKIE);
      
        if (isset($_COOKIE[MOBILESMART_SWITCHER_COOKIE]))
        {
          $this->logDebug('Constructor: $_COOKIE[MOBILESMART_SWITCHER_COOKIE] is set');
          $this->switcher_cookie = $_COOKIE[MOBILESMART_SWITCHER_COOKIE];
          //echo "Construct cookie: $this->switcher_cookie<br/><br/>";
        }
        else {
          $this->logDebug('Constructor: $_COOKIE[MOBILESMART_SWITCHER_COOKIE] not set');
        }
        
        $this->action_handleSwitcherLink();
     }
     
     /**
     * checks if the html switcher link has been called and acts appropriately
     * 
     * @access public
     * @return void
     */
    public function action_handleSwitcherLink() {
      $this->logDebug('action_handleSwitcherLink: $_GET[MOBILESMART_SWITCHER_GET_PARAM]: '.(isset($_GET[MOBILESMART_SWITCHER_GET_PARAM]) ? $_GET[MOBILESMART_SWITCHER_GET_PARAM] : 'not set'));
      if (isset($_GET[MOBILESMART_SWITCHER_GET_PARAM]))
      {
        // get the version
        $version = $_GET[MOBILESMART_SWITCHER_GET_PARAM];
        
        $blog_url = parse_url(get_bloginfo('url'));
        $blog_domain = str_ireplace('www', '', $blog_url['host']); // this will return www.xxx.com
        
        $cookie_domain = defined(COOKIE_DOMAIN) ? COOKIE_DOMAIN : $blog_domain;
        
        $this->logDebug('action_handleSwitcherLink: $cookie_domain: '.$cookie_domain);
  
        // set the cookie to say which version it is
        setcookie(MOBILESMART_SWITCHER_COOKIE,
                  $version,
                  time()+MOBILESMART_SWITCHER_COOKIE_EXPIRE,
                  '/',
                  $cookie_domain);
  
        // save version in class for viewing the page before a refresh
        $this->switcher_cookie = $version;
  
        //echo "Version to set: $version<br/>";
        //echo "Set version: $this->switcher_cookie<br/><br/>";
      }
    }
     
     /**
      * Detect if it's mobile from the cookie - overrides mobile status
      * @param boolean $detectmobile
      * @return boolean
      */
     function switcher_getMobileCookieDetect($detectmobile)
     {
        $this->logDebug('switcher_getMobileCookieDetect: $detectmobile: ', $detectmobile);
        $this->logDebug('switcher_getMobileCookieDetect: $this->switcher_cookie: ', $this->switcher_cookie);
        $this->logDebug('switcher_getMobileCookieDetect: $this->detect_from_cookie: ', $this->detect_from_cookie);
        
       if (!$this->detect_from_cookie)
       {
          // check the switcher cookie
        if ($detectmobile && $this->switcher_cookie)
        {
          if (($this->switcher_cookie == MOBILESMART_SWITCHER_DESKTOP_STR))
          {
            $is_mobile = false;
          }
          else
          {
            $is_mobile = true;
          }
        }
        // if we're not a mobile, then we invert the check string
        else if (!$detectmobile)
        {
          if (($this->switcher_cookie == MOBILESMART_SWITCHER_MOBILE_STR))
          {
            $is_mobile = true;
          }
          else
          {
            $is_mobile = false;
          }
        }
        else
        {
          $is_mobile = $detectmobile;
        }
          
          $this->detect_from_cookie = $is_mobile;
       }
       
       $this->logDebug('switcher_getMobileCookieDetect: decision: $is_mobile: ', $this->detect_from_cookie);
  
        //echo "Is Mobile: ".($is_mobile ? "true" : "false")."<br/><br/>";
  
        return $this->detect_from_cookie;
     }
  
    // ---------------------------------------------------------------------------
    // Function: get_switcherLink
    // Description: gets the link to display the switcher
    // Parameters: version - should be 'mobile' or 'desktop'
    // ---------------------------------------------------------------------------
    function get_switcherLink($version)
    {
      $switcher_str = add_query_arg (array (MOBILESMART_SWITCHER_GET_PARAM => $version));
  
      return $switcher_str;
    }
  
    // ---------------------------------------------------------------------------
    // Function: getUserAgentString
    // Description: gets the user agent string
    // ---------------------------------------------------------------------------
    public function getUserAgentString()
    {
      return $this->Get_Uagent();
    }

    // ---------------------------------------------------------------------------
    // Function: getAcceptString
    // Description: gets the accept string
    // ---------------------------------------------------------------------------
    public function getAcceptString()
    {
      return $this->Get_HttpAccept();
    }

    // ---------------------------------------------------------------------------
    // Function: getCurrentDevice
    // Description: gets the current device
    // ---------------------------------------------------------------------------
    public function getCurrentDevice()
    {
      if ($this->device == '')
      {
        if ($this->DetectOperaMini())
        {
          $this->device = MOBILE_DEVICE_OPERA_MINI;
        }
        else if ($this->DetectIpad())
        {
          $this->device = MOBILE_DEVICE_IPAD;
        }
        else if ($this->DetectIphone())
        {
          $this->device = MOBILE_DEVICE_IPHONE;
        }
        else if ($this->DetectIpod())
        {
          $this->device = MOBILE_DEVICE_IPOD;
        }
        else if ($this->DetectAndroid())
        {
          $this->device = MOBILE_DEVICE_ANDROID;
        }
        else if ($this->DetectAndroidTablet())
        {
          $this->device = MOBILE_DEVICE_ANDROID_TABLET;
        }
        else if ($this->DetectAndroidWebkit())
        {
          $this->device = MOBILE_DEVICE_ANDROID_WEBKIT;
        }
        else if ($this->DetectSeries60())
        {
          $this->device = MOBILE_DEVICE_SERIES60;
        }
        else if ($this->DetectSymbianOS())
        {
          $this->device = MOBILE_DEVICE_SYMBIAN_OS;
        }
        else if ($this->DetectWindowsMobile())
        {
          $this->device = MOBILE_DEVICE_WINDOWS_MOBILE;
        }
        else if ($this->DetectWindowsPhone7())
        {
          $this->device = MOBILE_DEVICE_WINDOWS_PHONE_7;
        }
        else if ($this->DetectBlackBerry())
        {
          $this->device = MOBILE_DEVICE_BLACKBERRY;
        }
        else if ($this->DetectBlackBerryTablet())
        {
          $this->device = MOBILE_DEVICE_BLACKBERRY_TABLET;
        }
        else if ($this->DetectBlackBerryWebkit())
        {
          $this->device = MOBILE_DEVICE_BLACKBERRY_WEBKIT;
        }
        else if ($this->DetectBlackBerryTouch())
        {
          $this->device = MOBILE_DEVICE_BLACKBERRY_TOUCH;
        }
        else if ($this->DetectPalmOS())
        {
          $this->device = MOBILE_DEVICE_PALM_OS;
        }
        else if ($this->DetectIsMobile())
        {
          $this->device = MOBILE_DEVICE_OTHER;
        }
        // To do...add the rest
      }
      return $this->device;
    }

    // ---------------------------------------------------------------------------
    // Function: getCurrentDeviceTier
    // Description: gets the current device tier
    // ---------------------------------------------------------------------------
    public function getCurrentDeviceTier()
    {
      if ($this->device_tier == '')
      {
        if ($this->DetectTierTablet())
        {
          $this->device_tier = MOBILE_DEVICE_TIER_TABLET;
        }
        if ($this->DetectTierIphone())
        {
          $this->device_tier = MOBILE_DEVICE_TIER_TOUCH;
        }
        if ($this->DetectTierRichCSS())
        {
          $this->device_tier = MOBILE_DEVICE_TIER_RICH_CSS;
        }
        if ($this->DetectTierRichCss())
        {
          $this->device_tier = MOBILE_DEVICE_TIER_SMARTPHONE;
        }
        if ($this->DetectTierOtherPhones())
        {
          $this->device_tier = MOBILE_DEVICE_TIER_OTHER;
        }
      }

      return $this->device_tier;
    }
    
    /**
      * is it a mobile device (including iPad)
      * @return boolean
      */
     public function DetectIsMobile()
     {
       if (!$this->detectmobile)
       {
         $is_mobile = false;

         if ($this->getOption(MOBILE_SMART_OPTION_SWITCH_FOR_TABLETS))
         {
           $is_mobile =  $this->DetectMobileQuick() || $this->DetectIsTablet();
         }
         else
         {
           $is_mobile = $this->DetectMobileQuick();
         }
         
         $this->detectmobile = $is_mobile;
       }
       
       return $this->detectmobile;
     }
     
     
     /**
      * is it a tablet.
      * 
      * @access public
      * @return void
      */
     public function DetectIsTablet() {
       return $this->DetectIpad() || $this->DetectAndroidTablet();
     }
     
     /**
      * Detect if is a mobile domain
      * @return boolean 
      */
     public function DetectMobileDomain()
     {
       if (!$this->detect_from_domain)
       {
         $is_mobilesubdomain = false;

         if (($this->getOption(MOBILE_SMART_ENABLE_DOMAIN_SWITCHING) ||  $this->getOption(MOBILE_SMART_ENABLE_DOMAIN_SWITCHING_ONLY))
             && (isset($_SERVER['HTTP_HOST']) && stripos($_SERVER['HTTP_HOST'], $this->getOption(MOBILE_SMART_OPTION_MOBILE_DOMAIN)) !== false))
         {
            $is_mobilesubdomain = true;
         }
         
         $this->detect_from_domain = $is_mobilesubdomain;
       }
        
       return $this->detect_from_domain;
     }
     
    // ---------------------------------------------------------------------------
    // Function: isTierTablet
    // Description: is the current device tier - table
    // ---------------------------------------------------------------------------
    function isTierTablet()
    {
      return $this->getCurrentDeviceTier() == MOBILE_DEVICE_TIER_TABLET;
    }

    // ---------------------------------------------------------------------------
    // Function: isTierTouch
    // Description: is the current device tier - touch
    // ---------------------------------------------------------------------------
    function isTierTouch()
    {
      return $this->getCurrentDeviceTier() == MOBILE_DEVICE_TIER_TOUCH;
    }
    
    // ---------------------------------------------------------------------------
    // Function: isTierRichCSS
    // Description: is the current device tier - Rich CSS
    // ---------------------------------------------------------------------------
    function isTierRichCSS()
    {
      return $this->getCurrentDeviceTier() == MOBILE_DEVICE_TIER_RICH_CSS;
    }

    // ---------------------------------------------------------------------------
    // Function: isTierSmartphone
    // Description: is the current device tier - smartphone
    // ---------------------------------------------------------------------------
    function isTierSmartphone()
    {
      return $this->getCurrentDeviceTier() == MOBILE_DEVICE_TIER_SMARTPHONE;
    }

    // ---------------------------------------------------------------------------
    // Function: isTierOtherMobile
    // Description: is the current device tier - other mobile devices (non-smartphone / non-touch)
    // ---------------------------------------------------------------------------
    function isTierOtherMobile()
    {
      return $this->getCurrentDeviceTier() == MOBILE_DEVICE_TIER_OTHER;
    }

   /**
    * Magic function - to catch old naming scheme of method with decapitalised first character. Change was caused by inclusion of mdetect.php
    * @param type $name
    * @param type $arguments 
    */
   function __call($name, $arguments)
   {
     $old_naming_scheme = ucwords($name);
     
     // check for method with capitalised first character - for backwards compatibility, as previous plugin had lowercase first characters in method name
     if (method_exists($this, $old_naming_scheme))
     {
       $name($arguments);
     }
   }
}