<?php
  /**
 * Mobile Smart - Menus class
 * - manages mobile menus
 */
 
namespace MobileSmart;

use MobileSmart;
use MobileSmartPluginBase;
 
define('MOBILE_SMART_OPTION_ENABLE_RESPONSIVE_MENUS', 'enable_responsive_menus');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_THEME_LOCATION', 'responsive_menu_theme_location');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_SHOW_CLOSE_BUTTON', 'responsive_menu_show_close_button');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_SKIN', 'responsive_menu_skin');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_HIDE_MENU_SELECTOR', 'responsive_menu_hide_menu_selector');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_CONTAINER_ID', 'responsive_menu_container_id');
define('MOBILE_SMART_OPTION_RESPONSIVE_MENU_TYPE', 'responsive_menu_type');

define('MOBILE_SMART_MENU_TYPE_BUTTON_ONLY', 'button-only');
define('MOBILE_SMART_MENU_TYPE_BAR', 'bar');

class MobileSmartDisplayMenu extends MobileSmartPluginBase {
  var $admin;
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    // Actions
    if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_RESPONSIVE_MENUS) === true) {
      add_action('wp_enqueue_scripts', array($this, 'enqueueScripts'), 100);
      add_action('wp_footer', array($this, 'addOffCanvasMenu'));
    }
    
    if (RESPONSIVE_MENUS_ENABLED && $this->getOption(MOBILE_SMART_OPTION_ENABLE_RESPONSIVE_MENUS) === true) {
      $this->admin = new \MobileSmart\MobileSmartDisplayMenuAdmin();
    }
  }
  
  
  /**
   * add scripts and styles.
   * 
   * @access public
   * @return void
   */
  public function enqueueScripts() {
    if ($this->isMobile()) {
      $plugin_dir_url = MobileSmart::getPluginDirUrl();
    
      wp_enqueue_style('mobile-smart-pro-menu', $plugin_dir_url.'assets/css/menu.css');
      wp_register_script('modernizr', $plugin_dir_url.'assets/js/modernizr-custom.min.js', array(), null, true);
      wp_enqueue_script( 'mobile-smart-pro-menu-js', $plugin_dir_url.'assets/js/menu.js', array('jquery', 'modernizr'), array(), null, true);
      wp_localize_script('mobile-smart-pro-menu-js', 'MobileSmartPro',
                          array(
                            'off_canvas_menu_hide' => $this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_HIDE_MENU_SELECTOR),
                            'site_container_id' => $this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_CONTAINER_ID)
                          ) );
    }
  }
  
  /**
   * addOffCanvasMenu function.
   * 
   * @access public
   * @return void
   */
  public function addOffCanvasMenu() {
    if (!$this->isMobile()) return;
    
    $nav_menu_args = array('theme_location' => $this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_THEME_LOCATION),
                    				'menu_id' => 'off-canvas-menu',
                    				'menu_class' => 'mobile-smart-pro-menu'
                    			);
    
    ?>
    <div id="mobile-smart-pro-title-bar" class="<?php echo 'menu-type-'.$this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_TYPE); ?>">
      <a class="menu-nav-btn" id="mobile-smart-pro-nav-open-btn" href="#mobile-smart-pro-off-canvas-nav">Menu</a>
      <?php if ($this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_TYPE) === MOBILE_SMART_MENU_TYPE_BAR) : ?>
      <div class="title-bar">
        <h1><?php bloginfo('title'); ?></h1>
      </div>
      <?php endif; ?>
    </div>
    <nav id="mobile-smart-pro-off-canvas-nav">
      <div class="block">
        <?php 
          /**
           * Filter: mobile_smart_pro_off_canvas_nav_menu_args
           */
          wp_nav_menu(apply_filters('mobile_smart_pro_off_canvas_nav_menu_args', $nav_menu_args)); 
        ?>
        <a class="close-btn" id="mobile-smart-pro-nav-close-btn" href="#top" style="<?php echo $this->getOption(MOBILE_SMART_OPTION_RESPONSIVE_MENU_SHOW_CLOSE_BUTTON) ? '' : 'display:none;'; ?>">Return to Content</a>
      </div>
    </nav>
    <?php
  }
  
}