<?php
/**
 * DisplayMenuAdmin
 */
 
namespace MobileSmart;

use MobileSmartAdminBase;

class MobileSmartDisplayMenuAdmin extends MobileSmartAdminBase {
  
  const TAB_GENERAL_SETTINGS = 'general-settings';
  
  
  /**
   * constructor
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    add_action('admin_menu', array($this, 'addAdminMenu'));
  }
  
  
  /**
   * addAdminMenu function.
   * 
   * @access public
   * @return void
   */
  public function addAdminMenu() {
    add_theme_page('Mobile Smart Pro Menu', 'Mobile Smart Pro Menu', 'edit_theme_options', 'mobile-smart-pro-menu', array($this, 'displayMenuPage') );
  }
  
  
  /**
   * display the themes menu page.
   * 
   * @access public
   * @return void
   */
  public function displayMenuPage() {
    function display_active_tab($tab, $current_tab) { 
      if ($current_tab == $tab) {
        echo 'nav-tab-active';
      }
    }
    
    $current_tab = (isset($_GET['tab']) ? filter_var($_GET['tab'], FILTER_SANITIZE_STRING) : 1);
    
    // handle any post settings required
    if (isset($_POST['save-settings'])) {
      switch ($current_tab) {
        case self::TAB_GENERAL_SETTINGS: // fall through to default
        default: 
          $this->handlePostGeneralSettingsPage();
      }
    }
    
    ?>
    <style type="text/css">
      .wrap form {
        background-color: white;
        padding: 20px;
      }
      
      .wrap form label {
        display: inline-block;
        width: 300px;
        max-width: 50%;
        margin-right: 20px;
      }
    </style>
    <div class="wrap">
      <h2>Mobile Smart Pro - Responsive Off Canvas Menu Options</h2>
      
      <h3 class="nav-tab-wrapper">
        <a href="<?php echo esc_url(add_query_arg('tab', self::TAB_GENERAL_SETTINGS)); ?>" class="nav-tab <?php display_active_tab(self::TAB_GENERAL_SETTINGS, $current_tab); ?>">General Settings</a>
      </h3>
      
      <form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
        
        <?php
          switch ($current_tab) {
            case self::TAB_GENERAL_SETTINGS: // fall through to default
            default: 
              $this->displayGeneralSettingsPage();
          }
        ?>

        <div class="submit">
          <input type="submit" name="save-settings" value="<?php _e('Update Settings', 'MobileSmart'); ?>" class="button button-primary"/>
        </div>
      </form>
      
    </div>
    <?php
  }
  
  
  /**
   * display the general settings.
   * 
   * @access public
   * @return void
   */
  public function displayGeneralSettingsPage() {
    
    $this->displayFieldThemeLocation();
    $this->displayFieldDropdown(MOBILE_SMART_OPTION_RESPONSIVE_MENU_SKIN,
                                __('Skin', MOBILESMART_DOMAIN),
                                array('dark' => 'Dark', 'light' => 'Light', 'custom' => 'Custom'));
    $this->displayTextField(MOBILE_SMART_OPTION_RESPONSIVE_MENU_HIDE_MENU_SELECTOR,
                            __('Desktop Menu CSS selector to hide when displaying the off-canvas menu', MOBILESMART_DOMAIN),
                            'e.g. #navbar or .nav-class');
    $this->displayTextField(MOBILE_SMART_OPTION_RESPONSIVE_MENU_CONTAINER_ID,
                            __('Site container div ID (note: not prefixed by #)', MOBILESMART_DOMAIN),
                            'e.g. wrapper or container');
    $this->displayFieldDropdown(MOBILE_SMART_OPTION_RESPONSIVE_MENU_TYPE,
                                __('Menu bar type', MOBILESMART_DOMAIN),
                                array(MOBILE_SMART_MENU_TYPE_BUTTON_ONLY => 'Menu button only',
                                      MOBILE_SMART_MENU_TYPE_BAR => 'Menu bar'));
  }
  
  
  /**
   * displayFieldThemeLocation function.
   * 
   * @access public
   * @return void
   */
  public function displayFieldThemeLocation() {
    $desktop_theme_locations = get_registered_nav_menus();
    ?>
    
    <p>
      <label for="responsive_menu_theme_location">Theme location of menu to replace</label> 
      
      <?php if (count($desktop_theme_locations)) : ?>
      <select name="responsive_menu_theme_location"><?php
        $responsive_menu_location = $this->getOption('responsive_menu_theme_location');
        foreach ($desktop_theme_locations as $desktop_theme_key => $desktop_theme_location) : 
            if (stripos($desktop_theme_key, 'mobile-') === false) : ?>
          <option value="<?php echo $desktop_theme_key; ?>" <?php echo ($responsive_menu_location === $desktop_theme_key ? 'selected' : ''); ?>><?php echo $desktop_theme_location; ?> ("<?php echo $desktop_theme_key; ?>")</option>
      <?php endif; ?>
      </select><?php
        endforeach; 
      else :  ?>
      Your current theme doesn't have any menu theme locations attached. You will need to ensure your theme has a wp_nav_menu() call set up with a theme location in order to use this functionality.
      <?php
      endif; ?>
  
    </p>
    
    <?php
  }
  
  /**
   * displayFieldDropdown function.
   * 
   * @access public
   * @param mixed $key
   * @param mixed $label
   * @param mixed $options
   * @return void
   */
  public function displayFieldDropdown($key, $label, $options) {
    
    $current_value = $this->getOption($key);
    ?>
    <p>
      <label for="<?php echo $key; ?>"><?php echo $label; ?></label>
      <?php if (count($options)) : ?>
      <select name="<?php echo $key; ?>">
      <?php   foreach ($options as $option_key => $option_value) : ?>
          <option value="<?php echo $option_key; ?>" <?php echo $current_value === $option_key ? 'selected="selected"' : ''; ?>><?php echo $option_value; ?></option>
      <?php   endforeach; ?>
      </select>
      <?php endif; ?>
    </p>
    <?php
  }
  
  
  /**
   * display a text field.
   * 
   * @access public
   * @param mixed $key
   * @param mixed $label
   * @return void
   */
  public function displayTextField($key, $label, $placeholder = '') {
    $current_value = $this->getOption($key);
    ?>
    <p>
      <label for="<?php echo $key; ?>"><?php echo $label; ?></label>
      <input type="text" value="<?php echo $current_value; ?>" name="<?php echo $key; ?>" <?php echo $placeholder ? 'placeholder="'.$placeholder.'"' : ''; ?>/>
    </p>
    <?php
  }
  
  
  /**
   * handle the POST request to save data.
   * 
   * @access public
   * @return void
   */
  public function handlePostGeneralSettingsPage() {
    $result = false;
    
    // get options
    $options = $this->getAdminOptions();
    
    // set values in options array
    $this->adminSetOptionFromDropdown($options, MOBILE_SMART_OPTION_RESPONSIVE_MENU_THEME_LOCATION);
    $this->adminSetOptionFromDropdown($options, MOBILE_SMART_OPTION_RESPONSIVE_MENU_SKIN);
    $this->adminSetOptionFromInput($options, MOBILE_SMART_OPTION_RESPONSIVE_MENU_HIDE_MENU_SELECTOR);
    $this->adminSetOptionFromInput($options, MOBILE_SMART_OPTION_RESPONSIVE_MENU_CONTAINER_ID);
    $this->adminSetOptionFromDropdown($options, MOBILE_SMART_OPTION_RESPONSIVE_MENU_TYPE);
    
    // update the options
    $this->updateOptions($options);
    
    return $result;
  }
}