<?php
  /**
 * Mobile Smart - Home Page class
 * - manages mobile home page overriding
 */
 
define('MOBILE_SMART_OPTION_HOME_PAGE', 'mobile_home_page');
define('MOBILE_SMART_OPTION_TABLET_HOME_PAGE', 'tablet_home_page');
 
class MobileSmartHomePage extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    // Mobile home
    add_filter('pre_option_page_on_front', array($this, 'filterOption'), 100);
    add_filter('pre_option_show_on_front', array($this, 'filter_show_on_front'), 100);
  }
  
  /**
   * filter get_option( 'page_on_front' )
   * 
   * @access public
   * @return void
   */
  public function filterOption($value) {             
    // only check if is mobile
    if ($this->isMobile()) {
      
      // if mobile home page is set, replace page_on_front with tablet home page
      if ($this->getOption(MOBILE_SMART_OPTION_HOME_PAGE)) {
        
        // if is tablet, override mobile home page with tablet home page if it exists
        if ($this->isTablet() && $this->getOption(MOBILE_SMART_OPTION_TABLET_HOME_PAGE)) {
          $value = $this->getOption(MOBILE_SMART_OPTION_TABLET_HOME_PAGE);
        }
        else {
          $value = $this->getOption(MOBILE_SMART_OPTION_HOME_PAGE);
        }
      }
    }
    
    return $value;
  }
  
  
  /**
   * mobileHomePage_show_on_front_filter function.
   * 
   * @access public
   * @param mixed $value
   * @return void
   */
  public function filter_show_on_front($value) {
    if ($this->isMobile()) {
      
      if ($this->getOption(MOBILE_SMART_OPTION_TABLET_HOME_PAGE)) {
        $value = 'page';
      }
    }   
    
    return $value;
  }
  
}