<?php
  /**
 * Mobile Smart - Menus class
 * - manages mobile menus
 */
 
define('MOBILE_SMART_OPTION_ENABLE_MENUS', 'enable_mobile_menus');
define('MOBILE_SMART_OPTION_MENU_MAPPING', 'menu_mapping');
 
class MobileSmartMenus extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    // Actions
    add_action('init', array($this, 'addMobileMenus'), 100);
    
    // Filters        
    add_filter('wp_nav_menu_args', array($this, 'wp_nav_menu_args'), 1, 1);
  }
  
  /**
    * Adds mobile menu locations (if enabled) 
    */
  public function addMobileMenus() {     
     
     if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_MENUS))
     {
        // get list of locations
        $locations = get_registered_nav_menus();
        $mobile_locations = array();
        
        $menu_mappings = $this->getOption(MOBILE_SMART_OPTION_MENU_MAPPING);
  
        // create mobile versions
        foreach ($locations as $location_name=>$location)
        {
          if (isset($menu_mappings[$location_name])) {
            $mapped_location_name = $menu_mappings[$location_name];
          }
          else {
            $mapped_location_name = $location_name;
          }
          $mobile_locations['mobile-'.$mapped_location_name] = 'Mobile version of '.$location;
        }
  
        // register mobile versions
        register_nav_menus($mobile_locations);
     }
   }
   
  /**
    * Filter nav menu to override menu
    * @param type $args
    * @return type 
    */
  public function wp_nav_menu_args($args) {
     
     if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_MENUS))
     {
       if ($this->isMobile())
       {
         $location = $args['theme_location'];
         
         $menu_mappings = $this->getOption(MOBILE_SMART_OPTION_MENU_MAPPING);
         
         $locations = get_registered_nav_menus();
         
         // if mobile location exists, and has a nav menu attached to that location
         if (array_key_exists('mobile-'.$location, $locations) && has_nav_menu('mobile-'.$location))
         {
           $args['theme_location'] = 'mobile-'.$location;
         }
       }
     }
     
     return $args;
   }
  
}