<?php
/**
 * Mobile Smart Plugin Base class - for all plugin classes to share basic functionality
 */
 
class MobileSmartPluginBase {
  
    var $admin_options;
    var $admin_optionsName = "MobileSmartOptions";
    var $is_mobile = false;
    var $is_tablet = false;
    var $device_tier = null;
    
    var $debugModeOn = false;
    
    
    /**
     * constructor.
     * 
     * @access public
     * @return void
     */
    public function __construct() {
      $this->initOptions();
      
      add_action('mobile_smart_is_mobile', array($this, 'setIsMobile'));
      add_action('mobile_smart_is_tablet', array($this, 'setIsTablet'));
      add_action('mobile_smart_update_device_tier', array($this, 'setCurrentDeviceTier'));
    }
    
    
    /**
     * set is mobile
     * 
     * @access public
     * @param mixed $is_mobile
     * @return void
     */
    public function setIsMobile($is_mobile) {      
      $this->is_mobile = $is_mobile;
    }    
    
    /**
     * returns mobile state
     * 
     * @access public
     * @return void
     */
    public function isMobile() {
      return $this->is_mobile;
    }
    
    /**
     * set if current device is tablet
     * 
     * @access public
     * @param mixed $is_mobile
     * @return void
     */
    public function setIsTablet($is_tablet) {
      $this->is_tablet = $is_tablet;
    }    
    
    /**
     * returns if is a tablet
     * 
     * @access public
     * @return void
     */
    public function isTablet() {
      return $this->is_tablet;
    }
    
    
    /**
     * is it a desktop.
     * 
     * @access public
     * @return void
     */
    public function isDesktop() {
	    return !$this->is_tablet && !$this->is_mobile;
    }
    
    
    /**
     * setCurrentDeviceTier function.
     * 
     * @access public
     * @return void
     */
    public function setCurrentDeviceTier($device_tier) {
      $this->device_tier = $device_tier;
    }
    
    
    /**
     * getCurrentDeviceTier function.
     * 
     * @access public
     * @return void
     */
    public function getCurrentDeviceTier() {
      return $this->device_tier;
    }
    
    
    /**
     * set the options
     * 
     * @access public
     * @param mixed $options
     * @return void
     */
    public function initOptions() {      
      // get the options from WP
      $wp_options = get_option($this->admin_optionsName);
    
      // set keys based on existing options - for backwards compatibility
      if (!empty($wp_options)) {
        // populate our adminOptions with wp options
        foreach($wp_options as $key=>$wp_option) {
          $this->admin_options[$key] = $wp_option;
        }
      }
    }
    
    /**
     * get all the admin options
     * 
     * @access public
     * @return void
     */
    public function getAdminOptions() {         
      return $this->admin_options;
    }
    
    
    /**
     * shorthand function to get option value by key
     * 
     * @access public
     * @param mixed $option_key
     * @return void
     */
    public function getOption($option_key) {
      $options = $this->getAdminOptions();
      
/*
      echo "<pre>";
      debug_print_backtrace();
      var_dump(isset($this->admin_options[$option_key]));
      echo "</pre>";
*/
      
      if ($this->admin_options && isset($this->admin_options[$option_key])) {
        return $this->admin_options[$option_key];
      }
      
      return false;
    }
    
    
    /**
     * updateOptions function.
     * 
     * @access public
     * @param mixed $options
     * @return void
     */
    public function updateOptions($options) {
      update_option($this->admin_optionsName, $options);
      wp_cache_delete( 'alloptions', 'options' );
      
      $this->admin_options = $options;
    }
    
    
    /**
     * setDebug function.
     * 
     * @access protected
     * @param bool $on (default: true)
     * @return void
     */
    protected function setDebug($on = true) {
      $this->debugModeOn = $on;
    }
    
    /**
     * logDebug function.
     * 
     * @access private
     * @param mixed $message
     * @param mixed $var (default: null)
     * @return void
     */
    protected function logDebug($message, $var = null) {
      if ($this->debugModeOn) {
        echo '<pre>Mobile Smart Pro debug: '.$message;
        if ($var !== null) {
          var_dump($var);
        }
        echo '</pre>';
      }
    }
}