<?php
  /**
 * Mobile Smart - SEO class
 * - manages mobile SEO
 */
 
define('MOBILE_SMART_OPTION_ADD_VARY_HEADER', 'add_vary_header');
define('MOBILE_SMART_OPTION_HIDE_MOBILE_FROM_SEARCH_ENGINES', 'hide_mobile_domain_from_search_engines');
 
class MobileSmartSEO extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    add_filter( 'robots_txt', array($this, 'modify_robotsTxt'));
    add_action( 'send_headers', array($this, 'addHeaderVary'));
  }
  
  /**
   * addHeaderVary - see https://developers.google.com/webmasters/mobile-sites/mobile-seo/configurations/dynamic-serving?hl=en
   * 
   * @access public
   * @return void
   */
  public function addHeaderVary() {
    if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_THEME_SWITCHING) == true && $this->getOption(MOBILE_SMART_OPTION_ADD_VARY_HEADER)) {
      header( 'Vary: User-Agent' );
    }
  }   
  
  
  /**
   * modify_robotsTxt filter
   * 
   * @access public
   * @param string $robots
   * @return string
   */
  function modify_robotsTxt($robots) {
    
    $public = get_option( 'blog_public' );
    
    // if we're public, and the admin has selected to hide the mobile domain from search engines, then modify the robots.txt
    if ($public && $this->getOption(MOBILE_SMART_OPTION_HIDE_MOBILE_FROM_SEARCH_ENGINES)) {
      // disallow
      $robots .= "User-agent: Googlebot-Mobile\n";
      $robots .= "Disallow: /\n";
    }
    return $robots;
  }
  
}