<?php
  /**
 * Mobile Smart - Transcoder class
 * - image transcoding
 */
 
class MobileSmartShortcodes extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    // Shortcodes
    add_shortcode( 'is_mobile', array($this, 'shortcode_isMobile') );
    add_shortcode( 'is_tablet', array($this, 'shortcode_isTablet') );
    add_shortcode( 'is_desktop', array($this, 'shortcode_isDesktop') );
  }
  
  
  /**
   * shortcode_isMobile function.
   * Usage: [is_mobile]some content[/is_mobile]
   * 
   * @access public
   * @param mixed $atts
   * @return void
   */
  public function shortcode_isMobile($atts, $content = '') {
    if ($this->isMobile()) {
      return do_shortcode($content);
    }
    else {
      return '';
    }
  }
  
  /**
   * shortcode_isTablet function.
   * Usage: [is_tablet]some content[/is_tablet]
   * 
   * @access public
   * @param mixed $atts
   * @return void
   */
  public function shortcode_isTablet($atts, $content = '') {
    if ($this->isTablet()) {
      return do_shortcode($content);
    }
    else {
      return '';
    }
  }
  
  /**
   * shortcode_isDesktop function.
   * Usage: [is_desktop]some content[/is_desktop]
   * 
   * @access public
   * @param mixed $atts
   * @return void
   */
  public function shortcode_isDesktop($atts, $content = '') {
    if (!$this->isMobile()) {
      return do_shortcode($content);
    }
    else {
      return '';
    }
  }
     
}