<?php
  /**
 * Mobile Smart - Switcher Link class
 * - manages the switcher link
 */
 
define('MOBILE_SMART_ENABLE_MANUAL_SWITCH', 'enable_manual_switch');
define('MOBILE_SMART_ENABLE_SWITCHER_LINK_IN_FOOTER', 'enable_manual_switch_in_footer');
define('MOBILE_SMART_ALLOW_DESKTOP_SWITCHER', 'allow_desktop_switcher');
 
class MobileSmartSwitcherLink extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();

    add_action('wp_footer', array($this, 'action_addSwitcherLinkInFooter'));
  } 
  
  /**
   * checks if the plugin option is enabled and if so adds the html switcher
   * 
   * @access public
   * @return void
   */
  function addSwitcherLink() {
  
    // if theme switching enabled
    if ($this->getOption(MOBILE_SMART_ENABLE_MANUAL_SWITCH) == true)
    {
      // if is a mobile device or cookie switcher allows it.
      if ($this->isMobile() || $this->getOption(MOBILE_SMART_ALLOW_DESKTOP_SWITCHER)) :
        ?>
  <!-- START MobileSmart - Switcher - http://www.dansmart.co.uk/ -->
  <div id="mobilesmart_switcher">
    <?php if ($this->isMobile()) : ?>
      <a href="<?php echo esc_url($this->get_switcherLink(MOBILESMART_SWITCHER_DESKTOP_STR)); ?>"><?php echo apply_filters('mobilesmart_switch_to_desktop_text', __('Switch to desktop version', MOBILESMART_DOMAIN)); ?></a>
    <?php else : ?>
      <a href="<?php echo esc_url($this->get_switcherLink(MOBILESMART_SWITCHER_MOBILE_STR)); ?>"><?php echo apply_filters('mobilesmart_switch_to_mobile_text', __('Switch to mobile version', MOBILESMART_DOMAIN)); ?></a>
    <?php endif; ?>
  </div>
  <!-- END MobileSmart - Switcher - http://www.dansmart.co.uk/ -->
        <?php
      endif;
    }
  }
  
  // ---------------------------------------------------------------------------
    // Function: get_switcherLink
    // Description: gets the link to display the switcher
    // Parameters: version - should be 'mobile' or 'desktop'
    // ---------------------------------------------------------------------------
    function get_switcherLink($version)
    {
      $switcher_str = add_query_arg (array (MOBILESMART_SWITCHER_GET_PARAM => $version));
  
      return $switcher_str;
    }
  
  /**
   * action call for too add link into wp_footer
   * 
   * @access public
   * @return void
   */
  function action_addSwitcherLinkInFooter()
  {
    // if theme switching enabled
    if ($this->getOption(MOBILE_SMART_ENABLE_MANUAL_SWITCH) == true && $this->getOption(MOBILE_SMART_ENABLE_SWITCHER_LINK_IN_FOOTER) == true)
    {
      // display the link
      $this->addSwitcherLink();
    }
  }
  
}