<?php
  /**
 * Mobile Smart - Test Mode class
 * - manages mobile Test mode - previewing pages
 */
 
class MobileSmartTestMode extends MobileSmartPluginBase {
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    //add_action('init', array($this, 'addRewriteTag'));
    
    add_filter('mobile_smart_switcher_is_mobile', array($this, 'switch_testMode'));
  }
  
  
  /**
   * addRewriteTag function.
   * 
   * @access public
   * @return void
   */
  public function addRewriteTag() {
    add_rewrite_tag('%testmobile%', '([^&]+)');
  }
  
  
  /**
   * is_login_page function.
   * 
   * @access public
   * @return void
   */
  public function is_login_page() {
	  $ABSPATH_MY = str_replace(array('\\','/'), DIRECTORY_SEPARATOR, ABSPATH);
    return ((in_array($ABSPATH_MY.'wp-login.php', get_included_files()) || in_array($ABSPATH_MY.'wp-register.php', get_included_files()) ) || $GLOBALS['pagenow'] === 'wp-login.php' || $_SERVER['PHP_SELF']== '/wp-login.php');
  }
  
  /**
    * switch_testMode function.
    * 
    * @access public
    * @param mixed $is_mobile
    * @return void
    */
   function switch_testMode($is_mobile) {	   
     if (isset($_GET['testmobile']) && $_GET['testmobile'] == 'true') {
       $is_mobile = true;
     } else if ( $this->getOption( 'switch_for_admin' ) && MobileSmartCurrentUserRole::currentUserHasRole( 'administrator' ) && !is_admin() && !$this->is_login_page() ) {
	     $is_mobile = true;
     }
     
     return $is_mobile;
   }
    
}