<?php
  /**
 * Mobile Smart - Theme Switching class
 * - theme switching
 */
 
define('MOBILE_SMART_OPTION_ENABLE_THEME_SWITCHING', 'enable_theme_switching');
define('MOBILE_SMART_OPTION_THEME_TEMPLATE', 'mobile_theme_template');
define('MOBILE_SMART_OPTION_THEME_STYLESHEET', 'mobile_theme_stylesheet');
 
class MobileSmartThemeSwitcher extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    add_filter('template', array(&$this, 'filter_switchTheme_template'));
    add_filter('stylesheet', array(&$this, 'filter_switchTheme_stylesheet'));
  }
  
  /**
   * filter_switchTheme_template
   * switches the theme template if it's a mobile device to the specified theme
   * - Filter: see add_filter('template'...)
   * 
   * @access public
   * @param mixed $theme
   * @return void
   */
  function filter_switchTheme_template($theme)
  {
    // if theme switching enabled
    if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_THEME_SWITCHING) == true && !is_admin())
    {
      // if is a mobile device or is mobile due to cookie switching
      $switch_theme = apply_filters('mobile_smart_switch_theme', $this->isMobile());
      
      if ($switch_theme)
      { 
        $theme = $this->getOption(MOBILE_SMART_OPTION_THEME_TEMPLATE);
        
        // if we've not got the theme here, we're out of sync between MSP versions, but we can recover
        if (!$theme) {
          $theme_template = wp_get_theme($this->getOption(MOBILE_SMART_OPTION_THEME_STYLESHEET));
          $theme = $theme_template['Template'];
        }
        
        $this->logDebug('filter_switchTheme: mobile_theme: ', $theme);          
      }
      else {
        $this->logDebug('filter_switchTheme: desktop_theme', $theme);
      }
    }

    return $theme;
  }
  
  /**
   * filter_switchTheme_stylesheet
   * switches the theme stylesheet if it's a mobile device to the specified theme
   * - Filter: see add_filter('template'...)
   * 
   * @access public
   * @param mixed $theme
   * @return void
   */
  function filter_switchTheme_stylesheet($theme)
  {
    // if theme switching enabled
    if ($this->getOption(MOBILE_SMART_OPTION_ENABLE_THEME_SWITCHING) == true && !is_admin())
    {
      // if is a mobile device or is mobile due to cookie switching
      $switch_theme = apply_filters('mobile_smart_switch_theme', $this->isMobile());
      if ($switch_theme)
      {
        $theme = $this->getOption(MOBILE_SMART_OPTION_THEME_STYLESHEET);
        $this->logDebug('filter_switchTheme: mobile_theme: ', $theme);          
      }
      else {
        $this->logDebug('filter_switchTheme: desktop_theme: ', $theme);
      }
    }

    return $theme;
  }
    
}