<?php
  /**
 * Mobile Smart - Transcoder class
 * - image transcoding
 */
 
define('MOBILE_SMART_OPTION_ENABLE_TRANSCODING', 'enable_image_transcoding');

// SOME DUMMY TIER SCREEN DIMENSIONS FOR TRANSCODING IMAGES
define ('MOBILE_DEVICE_TIER_TOUCH_MAX_WIDTH', 300);
define ('MOBILE_DEVICE_TIER_TOUCH_MAX_HEIGHT', 400);
define ('MOBILE_DEVICE_TIER_TABLET_MAX_WIDTH', 1024);
define ('MOBILE_DEVICE_TIER_TABLET_MAX_HEIGHT', 768);
define ('MOBILE_DEVICE_TIER_RICH_CSS_MAX_WIDTH', 300);
define ('MOBILE_DEVICE_TIER_RICH_CSS_MAX_HEIGHT', 400);
define ('MOBILE_DEVICE_TIER_SMARTPHONE_MAX_WIDTH', 200);
define ('MOBILE_DEVICE_TIER_SMARTPHONE_MAX_HEIGHT', 250);
define ('MOBILE_DEVICE_TIER_OTHER_MAX_WIDTH', 100);
define ('MOBILE_DEVICE_TIER_OTHER_MAX_HEIGHT', 150);

define('MOBILE_SMART_IMAGE_SIZE_TOUCH', 'mobile-smart-touch');
define('MOBILE_SMART_IMAGE_SIZE_TABLET', 'mobile-smart-tablet');
 
class MobileSmartTranscoder extends MobileSmartPluginBase {
  
  
  /**
   * constructor - sets up actions & filters
   * 
   * @access public
   * @return void
   */
  public function __construct() {
    parent::__construct();
    
    //$this->addImageSizes();
    
    add_filter('the_content', array(&$this, 'filter_processContent'));
    add_filter( 'image_size_names_choose', array(&$this, 'imageSizeNames') );
  }
  
  
  /**
   * addImageSizes function.
   * 
   * @access protected
   * @return void
   */
  protected function addImageSizes() {
    add_image_size(MOBILE_SMART_IMAGE_SIZE_TOUCH,
                   $this->get_option(MOBILE_SMART_OPTION_IMAGE_SIZE_TOUCH_WIDTH),
                   $this->get_option(MOBILE_SMART_OPTION_IMAGE_SIZE_TOUCH_HEIGHT),
                   false);
                   
    add_image_size(MOBILE_SMART_IMAGE_SIZE_TABLET,
                   $this->get_option(MOBILE_SMART_OPTION_IMAGE_SIZE_TABLET_WIDTH),
                   $this->get_option(MOBILE_SMART_OPTION_IMAGE_SIZE_TABLET_HEIGHT),
                   false);
  }

  
  /**
   * imageSizeNames function.
   * 
   * @access public
   * @param mixed $sizes
   * @return void
   */
  public function imageSizeNames( $sizes ) {
      return array_merge( $sizes, array(
          MOBILE_SMART_IMAGE_SIZE_TOUCH => __( 'Mobile Smart - Touch' ),
          MOBILE_SMART_IMAGE_SIZE_TABLET => __( 'Mobile Smart - Tablet' ),
      ) );
  }
  
   /**
    * filter_processContent
    * Description: processes the post's content and transcodes the post's images
    * Credits: idea and regexp taken from wpmp_transcoder.php, but brought into MobileSmart domain with improvements
    * 
    * @access public
    * @param mixed $the_content
    * @return void
    */
   public function filter_processContent($the_content) {
     
     // only process the content if we're in mobile mode
    if (!$this->isMobile() || !$this->getOption(MOBILE_SMART_OPTION_ENABLE_TRANSCODING))
      return $the_content;
   
     preg_match_all("/\<img.* src=((?:'[^']*')|(?:\"[^\"]*\")).*\>/Usi", $the_content, $images);

     foreach ($images[0] as $images_key=>$image)
     {
      $img_src = $images[1][$images_key];

      // remove the site url
      $site_url = str_replace('/', '\/', get_bloginfo('url'));
      $img_src = preg_replace("/[\"|']".$site_url."(.*)[\"|']/", '\1', $img_src);

      // get the width and height
      preg_match_all("/(width|height)[=:'\"\s]*(\d+)(?:px|[^\d])/Usi", $image, $img_dimensions);

      $width = 0; $height = 0;
      foreach ($img_dimensions[2] as $dim_index=>$dim_val)
      {
        if ($img_dimensions[1][$dim_index] == 'height')
          $height = $dim_val;
        else if ($img_dimensions[1][$dim_index] == 'width')
          $width = $dim_val;
      }

      // * * * * * * *
      // to do: get max dimensions of images for each device / tier from somewhere like WURFL
      switch ($this->getCurrentDeviceTier())
      {
        case MOBILE_DEVICE_TIER_TOUCH: $max_width = MOBILE_DEVICE_TIER_TOUCH_MAX_WIDTH; $max_height = MOBILE_DEVICE_TIER_TOUCH_MAX_HEIGHT; break;
        case MOBILE_DEVICE_TIER_TABLET: $max_width = MOBILE_DEVICE_TIER_TABLET_MAX_WIDTH; $max_height = MOBILE_DEVICE_TIER_TABLET_MAX_HEIGHT; break;
        case MOBILE_DEVICE_TIER_SMARTPHONE: $max_width = MOBILE_DEVICE_TIER_SMARTPHONE_MAX_WIDTH; $max_height = MOBILE_DEVICE_TIER_SMARTPHONE_MAX_HEIGHT; break;
        case MOBILE_DEVICE_TIER_RICH_CSS: $max_width = MOBILE_DEVICE_TIER_RICH_CSS_MAX_WIDTH; $max_height = MOBILE_DEVICE_TIER_RICH_CSS_MAX_HEIGHT; break;
        case MOBILE_DEVICE_TIER_OTHER: $max_width = MOBILE_DEVICE_TIER_OTHER_MAX_WIDTH; $max_height = MOBILE_DEVICE_TIER_OTHER_MAX_HEIGHT; break;
        default: $max_width = 100; $max_height = 100; break;
      }
      // * * * * * * *

      // rescale image
      if ($width > $max_width)
      {
        $height = floor($width / $max_width) * $height;
        $width = $max_width;
      }

      if ($height > $max_height)
      {
        $width = floor($height / $max_height) * $width;
        $height = $max_height;
      }

      // create new rescaled image
      $rescaled_image = '<img src="'.plugins_url('/includes/timthumb.php',dirname(__FILE__)).'/includes/timthumb.php?src='.$img_src.'&w='.$width.'&h='.$height.'&zc=0"'
                        .' width="'.$width.'"'.' height="'.$height.'"'.'/>';

      // replace the entire text of the old image with the text of the resized image
      $the_content = str_replace($image, $rescaled_image, $the_content);
     }

     return $the_content;
   }
     
}