<?php
/*
Plugin Name: Mobile Smart Pro
Plugin URI: http://www.mobile-smart.co.uk/
Version: 1.4
Author: <a href="http://www.dansmart.co.uk/">Dan Smart</a>
Description: Mobile Smart Pro is a toolkit for WordPress mobile devices +  switching mobile themes. <a href="/wp-admin/options-general.php?page=mobile-smart-pro.php">Settings</a>
 */

/*  Copyright 2017 Dan Smart  (email : dan@dansmart.co.uk)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Attributation:
 *  - Detection performed by MobileESP project code (www.mobileesp.com)
 *  - plugin disabling adapted from http://wordpress.org/extend/plugins/plugin-organizer/
 *  - menu icons by John Slater (https://www.iconfinder.com/slaterjohn) - CC license 2.5 (https://creativecommons.org/licenses/by/2.5/legalcode)
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


// -------------------------------------------------------------------------
// Defines
// -------------------------------------------------------------------------
if (defined('MOBILESMART_DOMAIN')) {
  exit('You must disable the free Mobile Smart plugin before activating Mobile Smart Pro');
}
else {
  define('MOBILESMART_DOMAIN', 'mobilesmart');
  define('MOBILESMART_PLUGIN_FOLDER', 'mobile-smart-pro');
  define('MOBILESMART_PLUGIN_PATH', WP_PLUGIN_DIR . '/'.MOBILESMART_PLUGIN_FOLDER);
  define('MOBILESMART_PLUGIN_PATH_REL', '/'.MOBILESMART_PLUGIN_FOLDER);
  define('MOBILESMART_PLUGIN_URL', WP_PLUGIN_URL .'/'.MOBILESMART_PLUGIN_FOLDER);
  define('MOBILESMART_BASENAME', basename(__FILE__));
  
  // MANUAL SWITCHING
  define ('MOBILESMART_SWITCHER_GET_PARAM', 'mobile_switch');
  define ('MOBILESMART_SWITCHER_MOBILE_STR', 'mobile');
  define ('MOBILESMART_SWITCHER_DESKTOP_STR', 'desktop');
  define ('MOBILESMART_SWITCHER_COOKIE', 'mobile-smart-switcher');
  define ('MOBILESMART_SWITCHER_COOKIE_EXPIRE', 3600); // 3600
  
  // NEW FEATURE TESTING
  define ('RESPONSIVE_MENUS_ENABLED', false);
  
  // -------------------------------------------------------------------------
  // Includes
  // -------------------------------------------------------------------------
  require_once('lib/mdetect.php');
  require_once('lib/wp-updates-plugin.php');
  
  require_once('classes/MobileSmartPluginBase.php');
  require_once('classes/MobileSmartDetect.php');
  require_once('classes/MobileSmartAdminBase.php');
  require_once('classes/MobileSmartAdmin.php');
  require_once('classes/MobileSmartCurrentUserRole.php');
  require_once('classes/MobileSmartThemeSwitcher.php');
  require_once('classes/MobileSmartDomainSwitcher.php');
  require_once('classes/MobileSmartPostSwitcher.php');
  require_once('classes/MobileSmartPages.php');
  require_once('classes/MobileSmartMenus.php');
  require_once('classes/MobileSmartDisplayMenu.php');
  require_once('classes/MobileSmartDisplayMenuAdmin.php');  
  require_once('classes/MobileSmartWidgetControl.php');
  require_once('classes/MobileSmartTranscoder.php');
  require_once('classes/MobileSmartShortcodes.php');
  require_once('classes/MobileSmartHomePage.php');
  require_once('classes/MobileSmartSwitcherLink.php');
  require_once('classes/MobileSmartSEO.php');
  require_once('classes/MobileSmartBodyClass.php');
  require_once('classes/MobileSmartTestMode.php');
  require_once('classes/MobileSmartSwitcherWidget.php');
}

use MobileSmart\MobileSmartDisplayMenu;

// -------------------------------------------------------------------------
// Plugin Class
// -------------------------------------------------------------------------
if (!class_exists("MobileSmart") && class_exists('uagent_info'))
{
  class MobileSmart extends MobileSmartDetect
  {
    // -------------------------------------------------------------------------
    // Attributes
    // -------------------------------------------------------------------------
    var $admin_options = array('mobile_theme'=>'default',
                               'mobile_theme_stylesheet' => '',
                               'switch_for_tablets'=>false,
                               'enable_theme_switching'=>true,
                               'enable_domain_switching'=>false,
                               'enable_domain_switching_only'=>false,
                               'add_vary_header'=>true,
                               'enable_mobile_menus'=>false,
                               'enable_mobile_pages'=>false,
                               'hide_mobile_domain_from_search_engines'=>false,
                              );
    
    var $features = array();

    // -------------------------------------------------------------------------
    // Methods
    // -------------------------------------------------------------------------

    
    /**
     * __construct function.
     * 
     * @access public
     * @return void
     */
    function __construct()
    {
      // translations
      load_plugin_textdomain(MOBILESMART_DOMAIN, false, MOBILESMART_PLUGIN_PATH_REL.'/language');
      
      parent::__construct();
      
      // add default features
      $this->features['currentUserRole'] = new MobileSmartCurrentUserRole();
      $this->features['themeSwitcher'] = new MobileSmartThemeSwitcher();
      $this->features['domainSwitcher'] = new MobileSmartDomainSwitcher();
      $this->features['postSwitcher'] = new MobileSmartPostSwitcher();
      $this->features['mobilePages'] = new MobileSmartPages();
      $this->features['mobileMenus'] = new MobileSmartMenus();
      $this->features['displayMenu'] = new MobileSmartDisplayMenu();
      $this->features['transcoder'] = new MobileSmartTranscoder();
      $this->features['shortcodes'] = new MobileSmartShortcodes();
      $this->features['homePage'] = new MobileSmartHomePage();
      $this->features['switcherLink'] = new MobileSmartSwitcherLink();
      $this->features['seo'] = new MobileSmartSEO();
      $this->features['bodyClass'] = new MobileSmartBodyClass();
      $this->features['testMode'] = new MobileSmartTestMode();
      $this->features['widgetControl'] = MobileSmartWidgetControl::Instance();
      
      // create admin
      $this->admin = new MobileSmartAdmin();
      
      // run detection
      $mobile = $this->switcher_isMobile();
    }

    
    /**
     * activation of plugin
     * 
     * @access public
     * @return void
     */
    public function activatePlugin()
    {
      // Check for required PHP version
      if (version_compare(PHP_VERSION, '5.0', '<'))
      {
          exit(sprintf('Mobile SMart Pro requires PHP 5.0 or higher. You’re still on %s.',PHP_VERSION));
      }
      
      // check Mobile Smart Pro folder name existence - we need that for MU compatibility  
      if (basename(dirname(__FILE__)) !== MOBILESMART_PLUGIN_FOLDER) {
        exit('The plugin must be installed to wp-content/plugins/mobile-smart-pro - to help this, please ensure that the zip file you are installing is called mobile-smart-pro.zip, or rename the folder via FTP');
      }
      
      // check if Mobile Smart plugin is currently activated
      if( is_plugin_active( 'mobile-smart/mobile-smart.php' ) ) {
        exit('You must disable the free Mobile Smart plugin before activating Mobile Smart Pro');
      }
      
      // initialise the admin options
      $this->addAdminOptions();

      // idea about moving MU plugins taken from http://wordpress.org/extend/plugins/plugin-organizer/
      if (!file_exists(ABSPATH . "wp-content/mu-plugins/")) {
  			mkdir(ABSPATH . "wp-content/mu-plugins/");
  		}

  		if (file_exists(ABSPATH . "wp-content/mu-plugins/mobile-smart-proMU.php")) {
  			unlink(ABSPATH . "wp-content/mu-plugins/mobile-smart-proMU.php");
  		}
  		
  		if (file_exists(WP_PLUGIN_DIR . "/" . plugin_basename(dirname(__FILE__)) . "/classes/mobile-smart-proMU.php")) {
  			copy(WP_PLUGIN_DIR . "/" . plugin_basename(dirname(__FILE__)) . "/classes/mobile-smart-proMU.php", ABSPATH . "wp-content/mu-plugins/mobile-smart-proMU.php");
  		}
    }
    
    /**
     * Plugin deactivation
     */
    public function deactivatePlugin() {
      if (file_exists(ABSPATH . "wp-content/mu-plugins/mobile-smart-proMU.php")) {
  			@unlink(ABSPATH . "wp-content/mu-plugins/mobile-smart-proMU.php");
  		}
    }

    
    /**
     * add the admin options.
     * 
     * @access protected
     * @return void
     */
    protected function addAdminOptions()
    {
      add_option($this->admin_optionsName, $this->admin_options);
    }
    
    
    /**
     * addSwitcherLink - passes through to the child function
     * 
     * @access public
     * @return void
     */
    public function addSwitcherLink() {
      $this->features['switcherLink']->addSwitcherLink();
    }
    
    
    /**
     * getPluginDirUrl function.
     * 
     * @access public
     * @static
     * @return void
     */
    public static function getPluginDirUrl() {
      return plugin_dir_url( __FILE__ );
    }
     
  } // MobileSmart
}

// -------------------------------------------------------------------------
// Instantiate class
// -------------------------------------------------------------------------
if (class_exists("MobileSmart"))
{
  $mobile_smart = new MobileSmart();
  
  // Activation
  register_activation_hook(__FILE__, array(&$mobile_smart, 'activatePlugin'));
  register_deactivation_hook(__FILE__, array(&$mobile_smart, 'deactivatePlugin'));
  
  // Set up auto upgrades
  new WPUpdatesPluginUpdater_919( 'http://wp-updates.com/api/2/plugin', plugin_basename(__FILE__) );
}
