<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Registers your tab in the addon  settings page
 *
 * @since 1.0.0
 * @return void
 */
function qsm_addon_advanced_timer_register_stats_tabs() {
	global $mlwQuizMasterNext;
	if ( ! is_null( $mlwQuizMasterNext ) && ! is_null( $mlwQuizMasterNext->pluginHelper ) && method_exists( $mlwQuizMasterNext->pluginHelper, 'register_quiz_settings_tabs' ) ) {
		$mlwQuizMasterNext->pluginHelper->register_addon_settings_tab( 'Advanced Timer', 'qsm_addon_advanced_timer_addon_settings_tabs_content' );
	}
	if ( version_compare( $mlwQuizMasterNext->version, '7.3.4', '>' ) ) {
		add_filter( 'qsm_text_variable_list_result', 'qsm_advanced_timer_show_variable', 10, 1 );
	} else {
		add_filter( 'qsm_text_variable_list', 'qsm_advanced_timer_show_variable', 10, 1 );
	}

	$field_array = array(
		'label'           => __( 'Per-page time in auto-paging', 'qsm-advanced-timer' ),
		'id'              => 'advance_per_page_timer',
		'type'            => 'multiple_fields',
		'fields'          => array(
			'advance_per_page_timer'         => array(
				'type'        => 'number',
				'suffix_text' => '<i class="qsm-font-light">' . __( 'Minutes and &nbsp;', 'qsm-advanced-timer' ) . '</i>',
				'default'     => 0,
			),
			'advance_per_page_timer_seconds' => array(
				'type'        => 'number',
				'suffix_text' => '<i class="qsm-font-light">' . __( 'Seconds', 'qsm-advanced-timer' ) . '</i>',
				'default'     => 0,
			),
		),
		'container_class' => 'qsm-advance-timer-input',
		'help'            => __( 'Set a timer for answering each page. If you don\'t wish to set a common time in each page, leave it blank or zero(0).', 'qsm-advanced-timer' ),
		'option_tab'      => 'display',
		'tooltip'         => __( 'When auto-paging, a timer displays on each page with the set number of questions (in question per page).', 'qsm-advanced-timer' ),
	);
	$settings_data   = get_option('qsm_addon_advanced_timer_settings', '');
	if ( ( isset($settings_data['last_validate']) && "invalid" == $settings_data['last_validate'] ) || empty($settings_data) ) { }
	else{
		$mlwQuizMasterNext->pluginHelper->register_quiz_setting( $field_array, 'quiz_options' );
	}
}

/**
 * Add TIME_PER_PAGE template variable in list.
 *
 * @since 1.0.6
 * @param array $variable_list variable list.
 * @return array
 */
function qsm_advanced_timer_show_variable( $variable_list ) {
	global $mlwQuizMasterNext;
	$template_array = array(
		'%TIME_PER_PAGE%'   => __( 'Display time taken by user per page.', 'qsm-advanced-timer' ),
		'%TIME_PER_PAGE_X%' => __( 'X: Page name, Display time taken by user.', 'qsm-advanced-timer' ),
	);
	if ( version_compare( $mlwQuizMasterNext->version, '7.3.4', '>' ) ) {
		$advanced_timer = array(
			'Advance Timer' => $template_array,
		);
	} else {
		$advanced_timer = $template_array;
	}
	$variable_list = array_merge( $variable_list, $advanced_timer );
	return $variable_list;
}

/**
 * Generates the content for your addon settings tab
 *
 * @since 1.0.0
 * @return void
 */
function qsm_addon_advanced_timer_addon_settings_tabs_content() {
	global $mlwQuizMasterNext;
	$settings    = get_option( 'qsm_addon_advanced_timer_settings', '' );
	$license     = isset( $settings['license_key'] ) ? trim( $settings['license_key'] ) : '';
	$default_notice = 1;
	wp_enqueue_script( 'qsm_advanced_timer_admin', plugins_url( '../js/admin.js' , __FILE__ ), array( 'jquery' ), QSM_ADVANCED_TIMER_VERSION );
	// If nonce is correct, update settings from passed input.
	if ( isset( $_POST['advanced_timer_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['advanced_timer_nonce'] ) ), 'advanced_timer' ) ) {
		// Load previous license key.
		$saved_license   = isset( $_POST['license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['license_key'] ) ) : '';
		if ( class_exists ( 'QSM_Check_License' ) ) {
			$activation = $mlwQuizMasterNext->check_license->activate( $saved_license, 'Advanced Timer' );
		}else {
			$activation = QSM_license::activate( $saved_license, 'Advanced Timer' );
		}
		$new_settings    = array( 'license_key' => $saved_license );
		if ( ! empty($activation) && ( ( __( 'Attempting to activate a bundle\'s parent license', 'qsm-advanced-timer' ) == $activation['message'] || __( 'License key revoked', 'qsm-advanced-timer' ) == $activation['message'] || __( 'No activations left', 'qsm-advanced-timer' ) == $activation['message'] || __( 'License has expired', 'qsm-advanced-timer' ) == $activation['message'] ) || 'success' == $activation['status'] ) ) {
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.QSM_ADVANCED_TIMER_ITEM;
			$new_settings['license_key'] = $saved_license;
			$new_settings['license_status'] = 'valid';
			$new_settings['last_validate'] = gmdate("d-m-Y", time());
			$new_settings['expiry_date'] = isset($activation['expiry_date']) ? $activation['expiry_date'] : "";
			if ( 'success' == $activation['status'] ) {
				$mlwQuizMasterNext->alertManager->newAlert( __( 'License validated Successfully', 'qsm-advanced-timer' ), 'success' );
			}elseif ( __( 'License has expired', 'qsm-advanced-timer' ) == $activation['message'] ) {
				$target_text = __('License Key Expired. ', 'qsm-advanced-timer');
				$target_link = sprintf( $target_text.'<a href="%s" target="_blank">%s</a>', esc_url( $item_url ), __( 'Click here to renew', 'qsm-advanced-timer' ) );
				$default_notice = 0;
				$mlwQuizMasterNext->alertManager->newAlert( $target_link, 'error' );
			}else {
				$mlwQuizMasterNext->alertManager->newAlert( $activation['message'], 'error' );
			}
			$mlwQuizMasterNext->alertManager->newAlert( __( 'Your settings has been saved successfully!', 'qsm-advanced-timer' ), 'success' );
		} else {
			$new_settings['license_key'] = '';
			$new_settings['license_status'] = '';
			$new_settings['last_validate'] = 'invalid';
			$new_settings['expiry_date'] = '';
			if ( "" == $saved_license ) {
				$default_notice = 0;
				$mlwQuizMasterNext->alertManager->newAlert( __('License Key Required ', 'qsm-advanced-timer'), 'error' );
			}else {
				$mlwQuizMasterNext->alertManager->newAlert( $activation['message'], 'error' );
			}
		}
		// If previous license key was entered.
		if ( $license != $saved_license ) {
			$deactivation = QSM_license::deactivate( $license, 'Advanced Timer' );
		}
		update_option( 'qsm_addon_advanced_timer_settings', $new_settings );
	}
	// Load settings.
	$settings_data = wp_parse_args( get_option( 'qsm_addon_advanced_timer_settings', array() ), array(
		'license_key' => '',
	)
	);
	// Show any alerts from saving.
	$date_now = gmdate("d-m-Y");
	$settings_data   = get_option('qsm_addon_advanced_timer_settings', '');
	$license         = isset( $settings_data['license_key'] ) ? trim( $settings_data['license_key'] ) : '';
	$license_status  = isset( $settings_data['license_status'] ) ? $settings_data['license_status'] : '';
	if ( '' != $license && 'valid' == $license_status ) {
		if ( version_compare( $mlwQuizMasterNext->version, '8.1.6', '>' ) && (isset($settings_data['expiry_date']) && "" != $settings_data['expiry_date']) && (isset($settings_data['last_validate']) && "" != $settings_data['last_validate']) && strtotime($date_now) > strtotime($settings_data['expiry_date']) && strtotime($date_now) >= strtotime($settings_data['last_validate']) ) { 
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.QSM_ADVANCED_TIMER_ITEM;
			$target_text = __('License Key Expired. ', 'qsm-advanced-timer');
			$target_link = sprintf( $target_text.'<a style="font-weight: 500;" href="%s" target="_blank">%s</a>', esc_url( $item_url ), __( 'Click here to renew', 'qsm-advanced-timer' ) );
			$mlwQuizMasterNext->alertManager->newAlert( $target_link, 'error' );
		}
		$mlwQuizMasterNext->alertManager->showAlerts();
	?>
	<form action="" method="post">
		<table class="form-table" style="width: 100%;">
			<tr valign="top">
				<th scope="row"><label for="license_key"><?php esc_html_e( 'Addon License Key', 'qsm-advanced-timer' ); ?></label></th>
				<td><input type="text" name="license_key" id="license_key" value="<?php echo esc_attr( $settings_data['license_key'] ); ?>"></td>
			</tr>
		</table>
		<?php wp_nonce_field( 'advanced_timer', 'advanced_timer_nonce' ); ?>
		<button class="button-primary"><?php esc_html_e( 'Save Changes', 'qsm-advanced-timer' ); ?></button>
	</form>
	<?php
	}else {
		$params      = array(
			'please_wait' => __('Please Wait...', 'qsm-advanced-timer'),
			'license_msg' => __('License Key Required.', 'qsm-advanced-timer'),
		);
		wp_localize_script( 'qsm_advanced_timer_admin', 'qsm_advanced_t_obj', $params );
		$mlwQuizMasterNext->alertManager->showAlerts();?>
		<div class="license_form_parent">
			<div id="license_message" style="display: none;" class="error below-h2"><p><strong class="qsm_advanced_t_validate_message"></strong></div>
			<h4><strong><?php esc_html_e( 'Please validate your licence key. ', 'qsm-advanced-timer' ); ?></strong></h4>
			<div class="qsm_advanced_t_validate_parent">
				<form class="rq_validata-license" method="POST">
					<input type="text" placeholder="<?php echo esc_html("Enter your license key"); ?>" class="qsm_advanced_t_validate_input" name="qsm_advanced_t_validate_input" />
					<input type="submit" name="qsm_advanced_t_validate_button" class="qsm_advanced_t_validate_button button button-primary" />
				</form>
			</div>
		</div>
		<?php
	}
}
