<?php
/**
 * @author WP Cloud Plugins
 * @copyright Copyright (c) 2023, WP Cloud Plugins
 *
 * @since       2.10
 * @see https://www.wpcloudplugins.com
 */

namespace TheLion\ShareoneDrive;

class Update
{
    public static function init()
    {
        add_action('in_plugin_update_message-'.SHAREONEDRIVE_SLUG, [__CLASS__, 'in_plugin_update_message'], 10, 2);
        

        License::is_valid();

        require_once SHAREONEDRIVE_ROOTDIR.'/vendors/plugin-update-checker/plugin-update-checker.php';
        \YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker('https://www.wpcloudplugins.com/updates_v2/?action=get_metadata&slug=share-one-drive&purchase_code='.License::get().'&plugin_id='.Core::$plugin_id.'&siteurl='.License::get_home_url(), plugin_dir_path(__DIR__).'/share-one-drive.php');
    }

    /**
     *  Add custom Update messages in plugin dashboard.
     *
     * @param mixed $data
     * @param mixed $response
     */
    public static function in_plugin_update_message($data, $response)
    {
        if (isset($data['upgrade_notice'])) {
            printf(
                '<br /><br /><span style="display:inline-block;background-color: #590e54; padding: 10px; color: white;"><span class="dashicons dashicons-warning"></span>&nbsp;<strong>UPGRADE NOTICE</strong> <br /><br />%s</span><br /><br />',
                $data['upgrade_notice']
            );
        }
    }

    /**
     * Enable automatic updates for this plugin.
     *
     * @param bool   $value current auto-update status
     * @param object $item  plugin update object
     *
     * @return bool updated auto-update status
     */
    public static function enable_plugin_auto_updates($value, $item)
    {
        if ('share-one-drive' === $item->slug) {
            return true; // Enable auto-updates for this plugin
        }

        return $value; // Preserve auto-update status for other plugins
    }

    /**
     * Update settings in database from earlier versions.
     *
     * @param array $settings
     */
    public static function update_database($settings)
    {
        $updated = false;
        // Set default values for new settings
        if (empty($settings['download_template_subject'])) {
            $settings['download_template_subject'] = '%site_name% | %user_name% downloaded %file_name%';
            $updated = true;
        }

        if (empty($settings['download_template_subject_zip'])) {
            $settings['download_template_subject_zip'] = '%site_name% | %user_name% downloaded %number_of_files% file(s) from %folder_name%';
            $updated = true;
        }

        if (empty($settings['download_template'])) {
            $settings['download_template'] = '<h2>Hi %recipient_name%!</h2>

<p>%user_name% has downloaded the following files via %site_name%:</p>

<table cellpadding="0" cellspacing="0" width="100%" border="0" style="cellspacing:0;color:#000000;font-family:"Helvetica Neue", Helvetica, Arial, sans-serif;font-size:14px;line-height:22px;table-layout:auto;width:100%;">

%filelist%

</table>';
            $updated = true;
        }

        if (empty($settings['upload_template_subject'])) {
            $settings['upload_template_subject'] = '%site_name% | %user_name% uploaded (%number_of_files%) file(s) to %folder_name%';
            $updated = true;
        }

        if (empty($settings['upload_template'])) {
            $settings['upload_template'] = '<h2>Hi %recipient_name%!</h2>

<p>%user_name% has uploaded the following file(s) via %site_name%:</p>

<table cellpadding="0" cellspacing="0" width="100%" border="0" style="cellspacing:0;color:#000000;font-family:"Helvetica Neue", Helvetica, Arial, sans-serif;font-size:14px;line-height:22px;table-layout:auto;width:100%;">

%filelist%

</table>';
            $updated = true;
        }

        if (empty($settings['delete_template_subject'])) {
            $settings['delete_template_subject'] = '%site_name% | %user_name% deleted (%number_of_files%) file(s) from %folder_name%';
            $updated = true;
        }

        if (empty($settings['delete_template'])) {
            $settings['delete_template'] = '<h2>Hi %recipient_name%!</h2>

<p>%user_name% has deleted the following file(s) via %site_name%:</p>

<table cellpadding="0" cellspacing="0" width="100%" border="0" style="cellspacing:0;color:#000000;font-family:"Helvetica Neue", Helvetica, Arial, sans-serif;font-size:14px;line-height:22px;table-layout:auto;width:100%;">

%filelist%

</table>';
            $updated = true;
        }

        if (empty($settings['move_template_subject'])) {
            $settings['move_template_subject'] = '%site_name% | %user_name% moved (%number_of_files%) file(s) from %folder_name%';
            $updated = true;
        }

        if (empty($settings['move_template'])) {
            $settings['move_template'] = '<h2>Hi %recipient_name%!</h2>

<p>%user_name% has moved the following file(s) via %site_name%:</p>

<table cellpadding="0" cellspacing="0" width="100%" border="0" style="cellspacing:0;color:#000000;font-family:"Helvetica Neue", Helvetica, Arial, sans-serif;font-size:14px;line-height:22px;table-layout:auto;width:100%;">

%filelist%

</table>';
            $updated = true;
        }

        if (empty($settings['copy_template_subject'])) {
            $settings['copy_template_subject'] = '%site_name% | %user_name% copied (%number_of_files%) file(s) from %folder_name%';
            $updated = true;
        }

        if (empty($settings['copy_template'])) {
            $settings['copy_template'] = '<h2>Hi %recipient_name%!</h2>

<p>%user_name% has copied the following file(s) via %site_name%:</p>

<table cellpadding="0" cellspacing="0" width="100%" border="0" style="cellspacing:0;color:#000000;font-family:"Helvetica Neue", Helvetica, Arial, sans-serif;font-size:14px;line-height:22px;table-layout:auto;width:100%;">

%filelist%

</table>';
            $updated = true;
        }

        if (empty($settings['filelist_template'])) {
            $settings['filelist_template'] = '<tr style="height: 50px;">
  <td style="width:20px;padding-right:10px;padding-top: 5px;padding-left: 5px;">
    <img alt="" height="16" src="%file_icon%" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;" width="16">
  </td>
  <td style="line-height:25px;padding-left:5px;">
    <a href="%file_cloud_preview_url%" target="_blank">%file_name%</a>
    <br/>
    <div style="font-size:12px;line-height:18px;color:#a6a6a6;outline:none;text-decoration:none;">%folder_absolute_path%</div>
  </td>
  <td style="font-weight: bold;">%file_size%</td>
</tr>';
            $updated = true;
        }

        if (empty($settings['mediaplayer_skin'])) {
            $settings['mediaplayer_skin'] = 'Default_Skin';
            $updated = true;
        }

        if (empty($settings['lostauthorization_notification'])) {
            $settings['lostauthorization_notification'] = get_site_option('admin_email');
            $updated = true;
        }

        if (empty($settings['gzipcompression'])) {
            $settings['gzipcompression'] = 'No';
            $updated = true;
        }

        if (empty($settings['permissions_edit_settings'])) {
            $settings['permissions_edit_settings'] = ['administrator'];
            $updated = true;
        }
        if (empty($settings['permissions_link_users'])) {
            $settings['permissions_link_users'] = ['administrator', 'editor'];
            $updated = true;
        }
        if (empty($settings['permissions_see_filebrowser'])) {
            $settings['permissions_see_filebrowser'] = ['administrator'];
            $updated = true;
        }
        if (empty($settings['permissions_add_shortcodes'])) {
            $settings['permissions_add_shortcodes'] = ['administrator', 'editor', 'author', 'contributor'];
            $updated = true;
        }
        if (empty($settings['permissions_add_links'])) {
            $settings['permissions_add_links'] = ['administrator', 'editor', 'author', 'contributor'];
            $updated = true;
        }
        if (empty($settings['permissions_add_embedded'])) {
            $settings['permissions_add_embedded'] = ['administrator', 'editor', 'author', 'contributor'];
            $updated = true;
        }

        if (empty($settings['link_scope'])) {
            $settings['link_scope'] = 'anonymous';
            $updated = true;
        }

        if (empty($settings['userfolder_backend'])) {
            $settings['userfolder_backend'] = 'No';
            $updated = true;
        }

        if (!is_array($settings['userfolder_backend_auto_root'])) {
            $settings['userfolder_backend_auto_root'] = [];
            $updated = true;
        }

        if (empty($settings['colors'])) {
            $settings['colors'] = [
                'style' => 'light',
                'background' => '#f9f9f9',
                'background-dark' => '#333333',
                'accent' => '#590e54',
                'black' => '#222',
                'dark1' => '#666',
                'dark2' => '#999',
                'white' => '#fff',
                'light1' => '#fcfcfc',
                'light2' => '#e8e8e8',
            ];
            $updated = true;
        }
        if (in_array($settings['colors']['background'], ['rgb(242,242,242)', '#f2f2f2'])) {
            $settings['colors']['background'] = '#f9f9f9';
            $updated = true;
        }

        if (!isset($settings['layout_border_radius']) || '' == $settings['layout_border_radius']) {
            $settings['layout_border_radius'] = '10';
            $updated = true;
        }
        if (!isset($settings['layout_gap']) || '' == $settings['layout_gap']) {
            $settings['layout_gap'] = '10';
            $updated = true;
        }

        if (empty($settings['loaders'])) {
            $settings['loaders'] = [
                'style' => 'spinner',
                'loading' => SHAREONEDRIVE_ROOTPATH.'/css/images/wpcp-loader.svg',
                'no_results' => SHAREONEDRIVE_ROOTPATH.'/css/images/loader_no_results.svg',
                'protected' => SHAREONEDRIVE_ROOTPATH.'/css/images/loader_protected.svg',
            ];
            $updated = true;
        }

        if ($settings['loaders']['loading'] === SHAREONEDRIVE_ROOTPATH.'/css/images/loader_loading.gif') {
            $settings['loaders']['loading'] = SHAREONEDRIVE_ROOTPATH.'/css/images/wpcp-loader.svg';
            $updated = true;
        }

        if ($settings['loaders']['no_results'] === SHAREONEDRIVE_ROOTPATH.'/css/images/loader_no_results.png') {
            $settings['loaders']['no_results'] = SHAREONEDRIVE_ROOTPATH.'/css/images/loader_no_results.svg';
            $updated = true;
        }

        if ($settings['loaders']['protected'] === SHAREONEDRIVE_ROOTPATH.'/css/images/loader_protected.png') {
            $settings['loaders']['protected'] = SHAREONEDRIVE_ROOTPATH.'/css/images/loader_protected.svg';
            $updated = true;
        }

        if (empty($settings['loaders']['iframe'])) {
            $settings['loaders']['iframe'] = SHAREONEDRIVE_ROOTPATH.'/css/images/wpcp-loader.svg';
            $updated = true;
        }

        if (empty($settings['colors']['background-dark'])) {
            $settings['colors']['background-dark'] = '#333333';
            $updated = true;
        }

        if (empty($settings['lightbox_rightclick'])) {
            $settings['lightbox_rightclick'] = 'No';
            $updated = true;
        }

        if (empty($settings['lightbox_thumbnails'])) {
            $settings['lightbox_thumbnails'] = 'Yes';
            $updated = true;
        }

        if (empty($settings['lightbox_showcaption'])) {
            $settings['lightbox_showcaption'] = 'always';
            $updated = true;
        }

        if (empty($settings['lightbox_showheader'])) {
            $settings['lightbox_showheader'] = 'always';
            $updated = true;
        }

        if (empty($settings['always_load_scripts'])) {
            $settings['always_load_scripts'] = 'No';
            $updated = true;
        }

        if (empty($settings['nonce_validation'])) {
            $settings['nonce_validation'] = 'Yes';
            $updated = true;
        }

        if (empty($settings['ajax_domain_verification'])) {
            $settings['ajax_domain_verification'] = 'Yes';
            $updated = true;
        }

        if (empty($settings['shortlinks'])) {
            $settings['shortlinks'] = 'None';
            $settings['bitly_login'] = '';
            $settings['bitly_apikey'] = '';
            $settings['shortest_apikey'] = '';
            $settings['rebrandly_apikey'] = '';
            $settings['rebrandly_domain'] = '';
            $settings['rebrandly_workspace'] = '';
            $updated = true;
        }

        if (!isset($settings['rebrandly_workspace'])) {
            $settings['rebrandly_workspace'] = '';
            $updated = true;
        }

        if (empty($settings['permissions_see_dashboard'])) {
            $settings['permissions_see_dashboard'] = ['administrator', 'editor'];
            $updated = true;
        }

        if (empty($settings['log_events'])) {
            $settings['log_events'] = 'Yes';
            $updated = true;
        }

        if (empty($settings['icon_set']) || '/' === $settings['icon_set']) {
            $settings['icon_set'] = SHAREONEDRIVE_ROOTPATH.'/css/icons/';
            $updated = true;
        }

        if (!isset($settings['recaptcha_sitekey'])) {
            $settings['recaptcha_sitekey'] = '';
            $settings['recaptcha_secret'] = '';
            $updated = true;
        }

        if ('default' === $settings['mediaplayer_skin']) {
            $settings['mediaplayer_skin'] = 'Default_Skin';
            $updated = true;
        }

        if (empty($settings['mediaplayer_load_native_mediaelement'])) {
            $settings['mediaplayer_load_native_mediaelement'] = 'No';
            $updated = true;
        }

        if (!isset($settings['mediaplayer_ads_tagurl'])) {
            $settings['mediaplayer_ads_tagurl'] = '';
            $settings['mediaplayer_ads_skipable'] = 'Yes';
            $settings['mediaplayer_ads_skipable_after'] = '5';
            $updated = true;
        }

        if (!isset($settings['event_summary'])) {
            $settings['event_summary'] = 'No';
            $settings['event_summary_period'] = 'daily';
            $settings['event_summary_recipients'] = get_site_option('admin_email');
            $updated = true;
        }

        if (!isset($settings['webhook_endpoint_url'])) {
            $settings['webhook_endpoint_url'] = '';
            $updated = true;
        }

        if (!isset($settings['webhook_endpoint_secret'])) {
            require_once ABSPATH.'wp-includes/pluggable.php';
            $settings['webhook_endpoint_secret'] = wp_generate_password(16);
            $updated = true;
        }

        if (empty($settings['userfolder_noaccess'])) {
            $settings['userfolder_noaccess'] = "<h2>No Access</h2>

<p>Your account isn't (yet) configured to access this content. Please contact the administrator of the site if you would like to have access. The administrator can link your account to the right content.</p>";
            $updated = true;
        }

        if (!isset($settings['uninstall_reset'])) {
            $settings['uninstall_reset'] = 'Yes';
            $updated = true;
        }

        if (!isset($settings['api_log'])) {
            $settings['api_log'] = 'No';
            $updated = true;
        }

        if (isset($settings['auth_key']) && false === get_site_option('wpcp-shareonedrive-auth_key')) {
            add_site_option('wpcp-shareonedrive-auth_key', $settings['auth_key']);
            unset($settings['auth_key']);
            $updated = true;
        }

        if (empty($settings['share_buttons'])) {
            $settings['share_buttons'] = [
                'clipboard' => 'enabled',
                'email' => 'enabled',
                'facebook' => 'enabled',
                'linkedin' => 'enabled',
                'mastodon' => 'disabled',
                'messenger' => 'enabled',
                'odnoklassniki' => 'disabled',
                'pinterest' => 'enabled',
                'pocket' => 'disabled',
                'reddit' => 'disabled',
                'telegram' => 'enabled',
                'twitter' => 'enabled',
                'viber' => 'disabled',
                'vkontakte' => 'disabled',
                'whatsapp' => 'enabled',
            ];
            $updated = true;
        }

        if (!isset($settings['notification_from_name'])) {
            $settings['notification_from_name'] = '';
            $settings['notification_from_email'] = '';
            $updated = true;
        }

        if (empty($settings['use_sharepoint'])) {
            $settings['use_sharepoint'] = 'Yes';
            $updated = true;
        }

        if (empty($settings['thumbnail_location'])) {
            $settings['thumbnail_location'] = 'onedrive';
            $updated = true;
        }

        if (!isset($settings['userfolder_name_guest_prefix'])) {
            $settings['userfolder_name_guest_prefix'] = esc_html__('Guests', 'wpcloudplugins').' - ';
            $updated = true;
        }

        if (!isset($settings['remember_last_location'])) {
            $settings['remember_last_location'] = 'Yes';
            $updated = true;
        }

        if (!isset($settings['onedrive_app_client_id'])) {
            $settings['onedrive_app_client_id'] = '';
            $settings['onedrive_app_client_secret'] = '';
            $updated = true;
        }

        if (!defined('SHAREONEDRIVE_AUTH_KEY')) {
            $auth_key = get_site_option('wpcp-shareonedrive-auth_key');
            if (false === $auth_key) {
                require_once ABSPATH.'wp-includes/pluggable.php';
                $auth_key = wp_generate_password(32);
                add_site_option('wpcp-shareonedrive-auth_key', $auth_key);
            }
            define('SHAREONEDRIVE_AUTH_KEY', $auth_key);
        }

        if ($updated) {
            update_option('share_one_drive_settings', $settings);
        }

        $version = get_option('share_one_drive_version');

        if (version_compare($version, '1.14') < 0) {
            // Install Event Database
            Events::install_database();
        }

        if (version_compare($version, '2.10.2') < 0) {
            Events::update_2_10_2();
        }

        if (false !== $version) {
            if (version_compare($version, '1.5.2') < 0) {
                copy(SHAREONEDRIVE_ROOTDIR.'/cache/.htaccess', SHAREONEDRIVE_CACHEDIR.'/.htaccess');
            }

            if (version_compare($version, '1.8.9') < 0) {
                // Remove old DB lists
                delete_option('share_one_drive_lists');
            }

            if (version_compare($version, '1.9') < 0) {
                // Remove old skin
                $settings['mediaplayer_skin'] = 'Default_Skin';
                update_option('share_one_drive_settings', $settings);
            }

            if (version_compare($version, '1.11') < 0) {
                // Multi account support requires changes in account and access_token storage
                if (!isset($settings['accounts'])) {
                    $settings['accounts'] = [];
                }
                update_option('share_one_drive_settings', $settings);
                Accounts::upgrade_from_single();
                $settings = get_option(Settings::$db_key);
            }
        }

        // Update Version number
        if (SHAREONEDRIVE_VERSION !== $version) {
            // Update License information
            add_action('wp_loaded', [__NAMESPACE__.'\\License', 'reset']);

            // Clear Cache
            Processor::reset_complete_cache();

            // Clear WordPress Cache
            add_action('wp_loaded', [__NAMESPACE__.'\\Helpers', 'purge_cache_others']);

            update_option('share_one_drive_version', SHAREONEDRIVE_VERSION);
        }

        return $settings;
    }
}
