<?php
/*
Plugin Name: Simple Text Rotator
Plugin URI: http://demo.curlythemes.com/
Description: Super elegant text rotation shortcode.
Version: 1.2
Author: Curly Themes
Author URI: http://www.curlythemes.com
*/

function curly_str_options_header() {
	
	if ( ! is_admin() ) {
		
		wp_enqueue_style( 'text-rotator-css', plugins_url( '/css/str.css' , __FILE__ ), true );
		
		wp_register_script( 'content-rotator-js', plugins_url( '/js/morphist.min.js' , __FILE__ ), array( 'jquery' ), null, true );
		wp_register_script( 'text-rotator-js', plugins_url( '/js/morphext.min.js' , __FILE__ ), array( 'jquery' ), null, true );
		wp_register_script( 'str-main', plugins_url( '/js/min/main-min.js' , __FILE__ ), array( 'jquery' ), null, true );
	} 
	
}
add_action('wp_enqueue_scripts', 'curly_str_options_header');


function curly_simple_text_rotator( $atts , $content = null ) {
	
	if( ! wp_script_is( 'text-rotator-js' ) )	
		wp_enqueue_script( 'text-rotator-js' );
	
	if( ! wp_script_is( 'str-main' ) )	
		wp_enqueue_script( 'str-main' );	
	
	extract( shortcode_atts( array(
		'animation' => 'bounceIn',
		'separator' => '|',
		'speed' => 2000,
		'color' => null
	), $atts ) );
	
	$text_rotator_id = uniqid('str_');
	
	$html  = '';
	
	if( ! is_null( $color ) ){
		
		$html .= "<style type='text/css' scoped> #$text_rotator_id {color: $color !important;}</style>";
		
	}
	
	$html .= "<span class='str-rotate' id='$text_rotator_id' data-str-animation='$animation' data-str-separator='$separator' data-str-speed='$speed'>";
	$html .= $content;
	$html .= '</span>';
	
	return $html;
	
}
function curly_simple_content_rotator( $atts , $content = null ) {
	
	if( ! wp_script_is( 'content-rotator-js' ) )	
		wp_enqueue_script( 'content-rotator-js' );
	
	if( ! wp_script_is( 'str-main' ) )	
		wp_enqueue_script( 'str-main' );
	
	extract( shortcode_atts( array(
		'animation' => 'bounceIn',
		'animation_out' => 'bounceOut',
		'speed' => 2000,
		'display' => null
	), $atts ) );
	
	$rotator_id = uniqid('scr_');
	
	$html  = '';
	
	if( ! is_null( $display ) ){
		
		$html .= "<style type='text/css' scoped> #$rotator_id .animated{display: $display !important}</style>";
		
	}
	
	$html .= "<div class='scr-rotate' id='$rotator_id' data-scr-animation='$animation'  data-scr-animation-out='$animation_out' data-scr-speed='$speed'>";
	$html .= do_shortcode( $content );
	$html .= '</div>';
	
	return $html;
	
}
add_shortcode( 'simple-text-rotator', 'curly_simple_text_rotator');
add_shortcode( 'simple-content-rotator', 'curly_simple_content_rotator');

?>