<?php
/**
 * @author WP Cloud Plugins
 * @copyright Copyright (c) 2023, WP Cloud Plugins
 *
 * @since       2.11
 * @see https://www.wpcloudplugins.com
 */

namespace TheLion\UseyourDrive;

defined('ABSPATH') || exit;

class Integrations
{
    public static function init()
    {
        // Add Global Form Helpers
        require_once 'integrations/FormHelpers.php';

        // Load integrations
        self::load_tinymce();
        self::load_automator();
        self::load_contactform7();
        self::load_elementor();
        self::load_divipagebuilder();
        self::load_gravityforms();
        self::load_formidableforms();
        self::load_fluentforms();
        self::load_gravitypdf();
        self::load_gutenberg();
        self::load_woocommcerce();
        self::load_wpforms();
        self::load_advancedcustomfields();
        self::load_beaverbuilder();
        self::load_ultimatemember();
    }

    public static function load_tinymce()
    {
        require_once 'integrations/tinymce/init.php';
    }

    public static function load_automator()
    {
        if (!defined('AUTOMATOR_PLUGIN_VERSION')) {
            return false;
        }

        require_once 'integrations/automator/init.php';
    }

    public static function load_contactform7()
    {
        if (!defined('WPCF7_PLUGIN')) {
            return false;
        }

        require_once 'integrations/contactform7/init.php';
    }

    public static function load_elementor()
    {
        if (!did_action('elementor/loaded')) {
            return false;
        }

        require_once 'integrations/elementor/init.php';
    }

    public static function load_divipagebuilder()
    {
        require_once 'integrations/divipagebuilder/init.php';
    }

    public static function load_gravityforms()
    {
        if (!class_exists('GFForms')) {
            return false;
        }

        if (class_exists('GFCommon')) {
            if (version_compare(\GFCommon::$version, '2', '<')) {
                return false;
            }

            if (version_compare(\GFCommon::$version, '2.5', '<')) {
                require_once 'integrations/gravityformslegacy/init.php';
            } else {
                require_once 'integrations/gravityforms/init.php';
            }
        }
    }

    public static function load_formidableforms()
    {
        if (!class_exists('FrmHooksController')) {
            return false;
        }

        require_once 'integrations/formidableforms/init.php';
    }

    public static function load_fluentforms()
    {
        if (!defined('FLUENTFORM')) {
            return false;
        }

        require_once 'integrations/fluentforms/init.php';
    }

    public static function load_gravitypdf()
    {
        if (!class_exists('GFForms')) {
            return false;
        }

        require_once 'integrations/gravitypdf/init.php';
    }

    public static function load_gutenberg()
    {
        require_once 'integrations/gutenberg/init.php';
    }

    public static function load_woocommcerce()
    {
        if (!class_exists('woocommerce')) {
            return false;
        }

        require_once 'integrations/woocommerce/init.php';
    }

    public static function load_wpforms()
    {
        if (!defined('WPFORMS_VERSION')) {
            return false;
        }

        if (version_compare(\WPFORMS_VERSION, '1.6.7.1', '<')) {
            return false;
        }

        require_once 'integrations/wpforms/init.php';
    }

    public static function load_advancedcustomfields()
    {
        if (!class_exists('ACF')) {
            return false;
        }

        require_once 'integrations/advancedcustomfields/init.php';
    }

    public static function load_beaverbuilder()
    {
        if (!class_exists('FLBuilder')) {
            return;
        }

        require_once 'integrations/beaverbuilder/init.php';
    }

    public static function load_ultimatemember()
    {
        if (!defined('UM_VERSION')) {
            return false;
        }

        require_once 'integrations/ultimatemember/init.php';
    }
}
