<?php

namespace TheLion\UseyourDrive\Integrations\Elementor;

defined('ABSPATH') || exit;

class Widget extends \Elementor\Widget_Base
{
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        wp_register_script('UseyourDrive.Elementor.Widget', plugins_url('widget.js', __FILE__), ['jquery'], USEYOURDRIVE_VERSION);
    }

    public function is_editor()
    {
        return is_admin() && (isset($_GET['action']) && 'elementor' === $_GET['action']) || (isset($_REQUEST['elementor-preview']));
    }

    public function get_script_depends()
    {
        if (false === $this->is_editor()) {
            return [];
        }

        $mediaplayer = \TheLion\UseyourDrive\Processor::instance()->load_mediaplayer(\TheLion\UseyourDrive\Settings::get('mediaplayer_skin'));

        if (!empty($mediaplayer)) {
            $mediaplayer->load_scripts();
            $mediaplayer->load_styles();
        }

        return ['UseyourDrive.Carousel', 'UseyourDrive.UploadBox', 'UseyourDrive', 'UseyourDrive.Elementor.Widget'];
    }

    public function get_style_depends()
    {
        if (false === $this->is_editor()) {
            return [];
        }

        return ['Eva-Icons', 'UseyourDrive', 'UseyourDrive'];
    }

    public function is_reload_preview_required()
    {
        return true;
    }

    public function get_name()
    {
        return 'wpcp-useyourdrive';
    }

    public function get_title()
    {
        return 'Google Drive';
    }

    public function get_icon()
    {
        return 'eicon-cloud-check';
    }

    public function get_categories()
    {
        return ['wpcloudplugins'];
    }

    public function get_keywords()
    {
        return ['cloud', 'google', 'drive', 'documents', 'files', 'upload', 'video', 'audio', 'media', 'embed'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Shortcode', 'wpcloudplugins'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode',
            [
                'label' => esc_html__('Raw shortcode', 'wpcloudplugins'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Edit this shortcode via the Shortcode Builder or manually via the raw code', 'wpcloudplugins'),
                'default' => '[useyourdrive mode="files"]',
                'dynamic' => [
                    'active' => true,
                ],
                'rows' => 7,
            ]
        );

        $this->add_control(
            'edit_shortcode',
            [
                'type' => \Elementor\Controls_Manager::BUTTON,
                'show_label' => false,
                'text' => esc_html__('Edit via Shortcode Builder', 'wpcloudplugins'),
                'event' => 'wpcp:editor:edit_useyourdrive_shortcode',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $html = $this->get_render_html($settings['shortcode']);

        echo ($html) ? $html : $settings['shortcode'];
    }

    protected function get_render_html($shortcode)
    {
        if (empty($shortcode)) {
            return esc_html__('Please configure the module first', 'wpcloudplugins');
        }

        \ob_start();

        echo do_shortcode($shortcode);

        $output = \ob_get_clean();

        if ($this->is_editor()) {
            // Do not enqueue script in the 'Editor' part of Elementor Builder
            wp_dequeue_script(['UseyourDrive.UploadBox', 'UseyourDrive.Carousel', 'UseyourDrive.Default_Skin.Player', 'UseyourDrive.Basic_Playlist.Player', 'UseyourDrive.Legacy_jPlayer.Player', 'WPCloudplugin.Libraries', 'UseyourDrive']);
        }

        if (empty($output)) {
            return '';
        }

        return $output;
    }
}
