<?php

namespace TheLion\UseyourDrive\Integrations;

defined('ABSPATH') || exit;

class UltimateMember
{
    private static $_instance;

    public function __construct()
    {
        // Ultimate Members is first registering users before adding the custom metadata like roles, or first/last name.
        // That means that the plugin is creating the Private Folders when the custom metadata isn't yet available.
        add_filter('um_add_user_frontend_submitted', [$this, 'disable_private_folder_on_um_user_registration'], 10, 1);
        add_action('um_after_save_registration_details', [$this, 'create_private_folder_after_um_user_registration'], 10, 2);
    }

    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function disable_private_folder_on_um_user_registration($args)
    {
        remove_action('user_register', ['TheLion\UseyourDrive\UserFolders', 'user_register']);

        return $args;
    }

    public function create_private_folder_after_um_user_registration($user_id, $data)
    {
        \TheLion\UseyourDrive\UserFolders::user_register($user_id);
    }
}

UltimateMember::instance();
