<?php

namespace TheLion\UseyourDrive\MediaPlayers;

use TheLion\UseyourDrive\Processor;

class Basic_Playlist_2020 extends \TheLion\UseyourDrive\MediaplayerSkin
{
    public $url;
    public $template_path = __DIR__.'/Template.php';

    public function __construct()
    {
        $this->url = plugins_url('', __FILE__);
    }

    public function load_scripts()
    {
        if (defined('USEYOURDRIVE_SCRIPTS'.get_class().'_LOADED')) {
            return;
        }

        $dependence = false;
        if ('Yes' === Processor::instance()->get_setting('mediaplayer_load_native_mediaelement')) {
            $dependence = ['wp-mediaelement'];
        }

        wp_register_script('Basic_Playlist.Polyfill', 'https://cdn.polyfill.io/v3/polyfill.min.js?features=es6,html5-elements,NodeList.prototype.forEach,Element.prototype.classList,CustomEvent,Object.entries,Object.assign,document.querySelector&flags=gated');
        wp_register_script('Basic_Playlist.Library', $this->get_url().'/js/mediaelement-and-player.min.js', $dependence, USEYOURDRIVE_VERSION);
        wp_register_script('UseyourDrive.Basic_Playlist.Player', $this->get_url().'/js/Player.js', ['Basic_Playlist.Polyfill', 'Basic_Playlist.Library', 'WPCloudplugin.Libraries'], USEYOURDRIVE_VERSION, true);

        wp_enqueue_script('UseyourDrive.Basic_Playlist.Player');

        $localize_library = [
            'language' => strtolower(strtok(determine_locale(), '_-')),
            'strings' => [
                'mejs.plural-form' => 2,
                'mejs.install-flash' => esc_html__('You are using a browser that does not have Flash player enabled or installed. Please turn on your Flash player plugin or download the latest version from https://get.adobe.com/flashplayer/'),
                'mejs.fullscreen-off' => esc_html__('Turn off Fullscreen'),
                'mejs.fullscreen-on' => esc_html__('Go Fullscreen'),
                'mejs.download-video' => esc_html__('Download Video'),
                'mejs.download-file' => esc_html__('Download', 'wpcloudplugins'),
                'mejs.share' => esc_html__('Share', 'wpcloudplugins'),
                'mejs.deeplink' => esc_html__('Direct link', 'wpcloudplugins'),
                'mejs.purchase' => esc_html__('Purchase', 'wpcloudplugins'),
                'mejs.search' => esc_html__('Search', 'wpcloudplugins').'...',
                'mejs.fullscreen' => esc_html__('Fullscreen'),
                'mejs.time-jump-forward' => [esc_html__('Jump forward 30 second'), esc_html__('Jump forward %1 seconds')],
                'mejs.loop' => esc_html__('Toggle Loop'),
                'mejs.play' => esc_html__('Play'),
                'mejs.pause' => esc_html__('Pause'),
                'mejs.close' => esc_html__('Close'),
                'mejs.playlist' => esc_html__('Close'),
                'mejs.playlist-prev' => esc_html__('Previous'),
                'mejs.playlist-next' => esc_html__('Next'),
                'mejs.playlist-loop' => esc_html__('Loop'),
                'mejs.playlist-shuffle' => esc_html__('Shuffle'),
                'mejs.time-slider' => esc_html__('Time Slider'),
                'mejs.time-help-text' => esc_html__('Use Left/Right Arrow keys to advance one second, Up/Down arrows to advance ten seconds.'),
                'mejs.time-skip-back' => [esc_html__('Skip back 10 second'), esc_html__('Skip back %1 seconds')],
                'mejs.captions-subtitles' => esc_html__('Captions/Subtitles'),
                'mejs.captions-chapters' => esc_html__('Chapters'),
                'mejs.none' => esc_html__('None'),
                'mejs.mute-toggle' => esc_html__('Mute Toggle'),
                'mejs.volume-help-text' => esc_html__('Use Up/Down Arrow keys to increase or decrease volume.'),
                'mejs.unmute' => esc_html__('Unmute'),
                'mejs.mute' => esc_html__('Mute'),
                'mejs.volume-slider' => esc_html__('Volume Slider'),
                'mejs.video-player' => esc_html__('Video Player'),
                'mejs.audio-player' => esc_html__('Audio Player'),
                'mejs.ad-skip' => esc_html__('Skip ad'),
                'mejs.ad-skip-info' => [esc_html__('Skip in 1 second'), esc_html__('Skip in %1 seconds')],
                'mejs.source-chooser' => esc_html__('Source Chooser'),
                'mejs.stop' => esc_html__('Stop'),
                'mejs.speed-rate' => esc_html__('Speed Rate'),
                'mejs.live-broadcast' => esc_html__('Live Broadcast'),
                'mejs.afrikaans' => esc_html__('Afrikaans'),
                'mejs.albanian' => esc_html__('Albanian'),
                'mejs.arabic' => esc_html__('Arabic'),
                'mejs.belarusian' => esc_html__('Belarusian'),
                'mejs.bulgarian' => esc_html__('Bulgarian'),
                'mejs.catalan' => esc_html__('Catalan'),
                'mejs.chinese' => esc_html__('Chinese'),
                'mejs.chinese-simplified' => esc_html__('Chinese (Simplified)'),
                'mejs.chinese-traditional' => esc_html__('Chinese (Traditional)'),
                'mejs.croatian' => esc_html__('Croatian'),
                'mejs.czech' => esc_html__('Czech'),
                'mejs.danish' => esc_html__('Danish'),
                'mejs.dutch' => esc_html__('Dutch'),
                'mejs.english' => esc_html__('English'),
                'mejs.estonian' => esc_html__('Estonian'),
                'mejs.filipino' => esc_html__('Filipino'),
                'mejs.finnish' => esc_html__('Finnish'),
                'mejs.french' => esc_html__('French'),
                'mejs.galician' => esc_html__('Galician'),
                'mejs.german' => esc_html__('German'),
                'mejs.greek' => esc_html__('Greek'),
                'mejs.haitian-creole' => esc_html__('Haitian Creole'),
                'mejs.hebrew' => esc_html__('Hebrew'),
                'mejs.hindi' => esc_html__('Hindi'),
                'mejs.hungarian' => esc_html__('Hungarian'),
                'mejs.icelandic' => esc_html__('Icelandic'),
                'mejs.indonesian' => esc_html__('Indonesian'),
                'mejs.irish' => esc_html__('Irish'),
                'mejs.italian' => esc_html__('Italian'),
                'mejs.japanese' => esc_html__('Japanese'),
                'mejs.korean' => esc_html__('Korean'),
                'mejs.latvian' => esc_html__('Latvian'),
                'mejs.lithuanian' => esc_html__('Lithuanian'),
                'mejs.macedonian' => esc_html__('Macedonian'),
                'mejs.malay' => esc_html__('Malay'),
                'mejs.maltese' => esc_html__('Maltese'),
                'mejs.norwegian' => esc_html__('Norwegian'),
                'mejs.persian' => esc_html__('Persian'),
                'mejs.polish' => esc_html__('Polish'),
                'mejs.portuguese' => esc_html__('Portuguese'),
                'mejs.romanian' => esc_html__('Romanian'),
                'mejs.russian' => esc_html__('Russian'),
                'mejs.serbian' => esc_html__('Serbian'),
                'mejs.slovak' => esc_html__('Slovak'),
                'mejs.slovenian' => esc_html__('Slovenian'),
                'mejs.spanish' => esc_html__('Spanish'),
                'mejs.swahili' => esc_html__('Swahili'),
                'mejs.swedish' => esc_html__('Swedish'),
                'mejs.tagalog' => esc_html__('Tagalog'),
                'mejs.thai' => esc_html__('Thai'),
                'mejs.turkish' => esc_html__('Turkish'),
                'mejs.ukrainian' => esc_html__('Ukrainian'),
                'mejs.vietnamese' => esc_html__('Vietnamese'),
                'mejs.welsh' => esc_html__('Welsh'),
                'mejs.yiddish' => esc_html__('Yiddish'),
            ],
        ];

        $localize_mediaplayer = [
            'player_url' => $this->get_url(),
        ];

        wp_localize_script('Basic_Playlist.Library', 'mejsL10n', $localize_library);
        wp_localize_script('UseyourDrive.Basic_Playlist.Player', 'Default_Skin_vars', $localize_mediaplayer);

        define('USEYOURDRIVE_SCRIPTS'.get_class().'_LOADED', true);
    }

    public function load_styles()
    {
        $is_rtl_css = (is_rtl() ? '.rtl' : '');

        wp_register_style('UseyourDrive.Basic_Playlist.Player.CSS', $this->get_url().'/css/style'.$is_rtl_css.'.css', false, USEYOURDRIVE_VERSION);
        wp_enqueue_style('UseyourDrive.Basic_Playlist.Player.CSS');
    }
}
