<?php
$show_sidebar = wcap_show_side_bar("credit_card");
$client = whcom_get_current_client();
$cctype = $client['cctype'];
$cclastfour = $client["cclastfour"];
$client_id = whcom_get_current_client_id();
?>
<div class="wcap_billings wcap_view_container">
    <div class="whcom_row">
        <?php if ($show_sidebar) { ?>

            <div class="whcom_col_sm_3">
                <?php
                wcap_render_profile_panel();
                ?>
            </div>

        <?php } ?>
        <div class="<?php echo ($show_sidebar) ? "whcom_col_sm_9" : "whcom_col_sm_12" ?>">
            <div class="whcom_page_heading">
                <?php esc_html_e("Payment Methods", "whcom") ?>
            </div>

            <div class="wcap_view_response">

            </div>

            <div class="wcap_view_content">

                <h5><?php esc_html_e("Add New Payment Method", "whcom"); ?></h5>
                <!-- Card Type -->

                <?php
                $whcom_whmcs_settings = whcom_get_whmcs_setting();
                $cc_types = (!empty($whcom_whmcs_settings) && !empty($whcom_whmcs_settings['AcceptedCardTypes'])) ? $whcom_whmcs_settings['AcceptedCardTypes'] : '';
                $cc_types = explode(',', $cc_types);
                if (!empty($cc_types)) { ?>
                <!--Payment Options-->
                <form id="update_credit_card_form">
                    <input type="hidden" name="action" value="wcap_requests">
                    <input type="hidden" name="what" value="update_credit_card">
                    <input type="hidden" name="clientid" value="<?php echo $client_id ?>">
                    <div class="whcom_sp_cc_fields">
                        <div class="whcom_row">
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Type -->
                                <div class="whcom_form_field">
                                    <label for="type"
                                           class="main_label"><?php esc_html_e('Type', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Type -->
                                <div class="whcom_form_field">

                                    <div class="whcom_radio_container">
                                        <label class="whcom_radio whcom_checked">
                                            <input name="type" type="radio" value="CreditCard" checked="checked"> Credit Card
                                        </label>
                                    </div>

                                    <!--<select name="type" id="type">
                                        <?php /*foreach ($cc_types as $cc_type) { */?>
                                            <option value="<?php /*echo $cc_type */?>"><?php /*echo $cc_type */?></option>
                                        <?php /*} */?>
                                    </select>-->
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Description -->
                                <div class="whcom_form_field">
                                    <label for="description"
                                           class="main_label"><?php esc_html_e('Description', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Description -->
                                <div class="whcom_form_field">
                                    <input type="text" name="description" id="description" value="">
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Number -->
                                <div class="whcom_form_field">
                                    <label for="card_number"
                                           class="main_label"><?php esc_html_e('Card Number', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Number -->
                                <div class="whcom_form_field">
                                    <input type="number" name="card_number" id="card_number" value="">
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <label class="" for="exp_month"><?php esc_html_e('Expiry Date', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <div class="whcom_checkbox_container">
                                        <div class="whcom_row">
                                            <div class="whcom_col_xs_6">
                                                <select name="exp_month" id="exp_month" title="Expiry Month">
                                                    <option value="01"><?php esc_html_e('Jan', 'whcom') ?></option>
                                                    <option value="02"><?php esc_html_e('Feb', 'whcom') ?></option>
                                                    <option value="03"><?php esc_html_e('Mar', 'whcom') ?></option>
                                                    <option value="04"><?php esc_html_e('Apr', 'whcom') ?></option>
                                                    <option value="05"><?php esc_html_e('May', 'whcom') ?></option>
                                                    <option value="06"><?php esc_html_e('Jun', 'whcom') ?></option>
                                                    <option value="07"><?php esc_html_e('Jul', 'whcom') ?></option>
                                                    <option value="08"><?php esc_html_e('Aug', 'whcom') ?></option>
                                                    <option value="09"><?php esc_html_e('Sep', 'whcom') ?></option>
                                                    <option value="10"><?php esc_html_e('Oct', 'whcom') ?></option>
                                                    <option value="11"><?php esc_html_e('Nov', 'whcom') ?></option>
                                                    <option value="12"><?php esc_html_e('Dec', 'whcom') ?></option>
                                                </select>
                                            </div>
                                            <div class="whcom_col_xs_6">
                                                <select name="exp_year" title="Expiry Year">
                                                    <option value="22"><?php esc_html_e('2022', 'whcom') ?></option>
                                                    <option value="23"><?php esc_html_e('2023', 'whcom') ?></option>
                                                    <option value="24"><?php esc_html_e('2024', 'whcom') ?></option>
                                                    <option value="25"><?php esc_html_e('2025', 'whcom') ?></option>
                                                    <option value="26"><?php esc_html_e('2026', 'whcom') ?></option>
                                                    <option value="27"><?php esc_html_e('2027', 'whcom') ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="whcom_row">
                                <div class="whcom_col_sm_4 whcom_text_right">
                                    <!-- Card CVV -->
                                    <div class="whcom_form_field">
                                        <label for="cvv"
                                               class="main_label"><?php esc_html_e('CVV/CVC2 Number', 'whcom') ?></label>
                                    </div>
                                </div>
                                <div class="whcom_col_sm_4">
                                    <!-- Card CVV -->
                                    <div class="whcom_form_field">
                                        <input type="password" name="cvv" id="cvv" value="">
                                    </div>
                                </div>
                                <div class="whcom_col_sm_4 whcom_text_left">
                                    <div class="whcom_form_field show_cvv whcom_text_primary" style="cursor: pointer;">
                                        <?php esc_html_e('Where do i find this?', 'whcom') ?>
                                    </div>
                                </div>
                            </div>
                            <div class="whcom_row card_demo" style="display: none">
                                <div class="whcom_col_sm_4"></div>
                                <div class="whcom_col_sm_8">
                                    <img src="<?php echo WCAP_URL .'/assets/images/ccv.gif' ?>">
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <label class=""
                                           for="billingaddress"><?php esc_html_e('Billing Address', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <div class="whcom_row">
                                        <div class="whcom_radio_container">
                                            <label class="whcom_radio whcom_checked">
                                                <input type="radio">
                                                <?php echo '<b>' . $client['fullname'] . '</b>' . ' ' . $client['address1'] . ', ' . $client['address2'] . ', ' . $client['city'] . ', ' . $client['fullstate'] . ', ' . $client['postcode'] . ', ' . $client['countrycode']; ?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="whcom_text_center">
                        <div class="whcom_form_field whcom_form_field_horizontal">
                            <button type="submit"><?php esc_html_e("Save Changes", "whcom") ?></button>
                            <button class="whcom_button_secondary"><?php esc_html_e("Cancel", "whcom") ?></button>
                        </div>
                    </div>

                    <?php } ?>


                </form>


            </div>

        </div>


    </div>
</div>


