<?php
$show_sidebar = wcap_show_side_bar("credit_card");
$client = whcom_get_current_client();
$cctype = $client['cctype'];
$cclastfour = $client["cclastfour"];
$client_id = whcom_get_current_client_id();

$paymethods = whcom_get_all_paymethods($client_id);
?>
<div class="wcap_billings wcap_view_container">
    <div class="whcom_row">
        <?php if ($show_sidebar) { ?>

            <div class="whcom_col_sm_3">
                <?php
                wcap_render_profile_panel();
                ?>
            </div>

        <?php } ?>
        <div class="<?php echo ($show_sidebar) ? "whcom_col_sm_9" : "whcom_col_sm_12" ?>">
            <div class="whcom_page_heading">
                <?php esc_html_e("Payment Methods", "whcom") ?>
            </div>

            <div class="wcap_view_response">

            </div>

            <div class="wcap_view_content">
                <?php esc_html_e('An overview of your payment methods and settings.', 'whcom') ?>
                <div class="whcom_form_field whcom_form_field_horizontal">
                    <a href="" type="button" class="whcom_button wcap_load_page"
                       data-page="add_paymentmethods"><?php esc_html_e('Add New Credit Card', 'whcom') ?></a>
                </div>
                <table class="" id="wcap_payMethodList">
                    <tbody>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th colspan="2">Actions</th>
                    </tr>

                    <?php if (empty($paymethods)) { ?>
                        <tr>
                            <td colspan="6" align="center">
                                No payment methods have been created yet
                            </td>
                        </tr>
                    <?php } else {
                        foreach ($paymethods['paymethods'] as $pm) { ?>
                            <tr>
                                <td><?php echo $pm['card_type'] . '-' . $pm['card_last_four'] ?></td>
                                <td><?php echo $pm['description'] ?></td>
                                <td><?php echo "Active-Default" ?></td>
                                <td>
                                    <button type="button" class="whcom_button"
                                            value="<?php echo $pm['id'] ?>">
                                        <?php esc_html_e("Set as default","whcom") ?>
                                    </button>
                                    <button type="button" class="whcom_button wcap_load_single_paymethod whcom_icon whcom_icon_pencil-1"
                                            data-id="<?php echo $pm['id'] ?>" data-page="edit_paymethod"
                                            value="<?php echo $pm['id'] ?>">
                                        <?php esc_html_e("Edit","whcom") ?>
                                    </button>
                                    <button type="button" class="del_paymethod whcom_icon whcom_icon_trash-1" value="<?php echo $pm['id'] ?>">
                                        <?php esc_html_e("Delete","whcom") ?>
                                    </button>
                                </td>
                            </tr>
                        <?php }
                    } ?>


                    </tbody>
                </table>
            </div>

        </div>


    </div>
</div>

<div id="success_message" class="whcom_alert whcom_alert_success" style="display: none;"></div>
<div id="error_message" class="whcom_alert whcom_alert_warning" style="display: none;"></div>


