<?php
$show_sidebar = wcap_show_side_bar("credit_card");
$client = whcom_get_current_client();
$client_id = whcom_get_current_client_id();

$paymethod = whcom_get_all_paymethods($client_id,$_POST['id']);
$paymethod = $paymethod['paymethods'][0];

$exp_date = $paymethod['expiry_date'];
$exp_date = explode('/',$exp_date);
$exp_month = $exp_date[0];
$exp_yr = $exp_date[1];
?>
<div class="wcap_billings wcap_view_container">
    <div class="whcom_row">
        <?php if ($show_sidebar) { ?>

            <div class="whcom_col_sm_3">
                <?php
                wcap_render_profile_panel();
                ?>
            </div>

        <?php } ?>
        <div class="<?php echo ($show_sidebar) ? "whcom_col_sm_9" : "whcom_col_sm_12" ?>">
            <div class="whcom_page_heading">
                <?php esc_html_e("Payment Methods", "whcom") ?>
            </div>

            <div class="wcap_view_response">

            </div>

            <div class="wcap_view_content">

                <h5><?php esc_html_e("Edit Payment Method", "whcom"); ?></h5>

                <!--Payment Options-->
                <form id="update_pay_method_form">
                    <input type="hidden" name="action" value="wcap_requests">
                    <input type="hidden" name="what" value="update_pay_method">
                    <input type="hidden" name="clientid" value="<?php echo $client_id ?>">
                    <input type="hidden" name="paymethodid" value="<?php echo $_POST['id'] ?>">
                    <div class="whcom_sp_cc_fields">
                        <div class="whcom_row">
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Type -->
                                <div class="whcom_form_field">
                                    <label for="type"
                                           class="main_label"><?php esc_html_e('Type', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Type -->
                                <div class="whcom_form_field">

                                    <div class="whcom_radio_container">
                                        <label class="whcom_radio whcom_checked">
                                            <input name="type" type="radio" value="CreditCard" checked="checked" disabled="disabled"> Credit Card
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Description -->
                                <div class="whcom_form_field">
                                    <label for="description"
                                           class="main_label"><?php esc_html_e('Description', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Description -->
                                <div class="whcom_form_field">
                                    <input type="text" name="description" id="description" value="<?php echo $paymethod['description']  ?>">
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Card Number -->
                                <div class="whcom_form_field">
                                    <label for="card_number"
                                           class="main_label"><?php esc_html_e('Card Number', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Card Number -->
                                <div class="whcom_form_field">
                                    <input type="text" disabled="disabled" name="card_number" id="card_number" value="<?php echo '************'.$paymethod['card_last_four'] ?>">
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <label class="" for="exp_month"><?php esc_html_e('Expiry Date', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <div class="whcom_checkbox_container">
                                        <div class="whcom_row">
                                            <div class="whcom_col_xs_6">
                                                <select name="exp_month" id="exp_month" title="Expiry Month">
                                                    <option value="01" <?php echo "01" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Jan', 'whcom') ?></option>
                                                    <option value="02" <?php echo "02" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Feb', 'whcom') ?></option>
                                                    <option value="03" <?php echo "03" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Mar', 'whcom') ?></option>
                                                    <option value="04" <?php echo "04" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Apr', 'whcom') ?></option>
                                                    <option value="05" <?php echo "05" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('May', 'whcom') ?></option>
                                                    <option value="06" <?php echo "06" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Jun', 'whcom') ?></option>
                                                    <option value="07" <?php echo "07" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Jul', 'whcom') ?></option>
                                                    <option value="08" <?php echo "08" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Aug', 'whcom') ?></option>
                                                    <option value="09" <?php echo "09" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Sep', 'whcom') ?></option>
                                                    <option value="10" <?php echo "10" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Oct', 'whcom') ?></option>
                                                    <option value="11" <?php echo "11" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Nov', 'whcom') ?></option>
                                                    <option value="12" <?php echo "12" == $exp_month ? "selected=selected":'' ?> ><?php esc_html_e('Dec', 'whcom') ?></option>
                                                </select>
                                            </div>
                                            <div class="whcom_col_xs_6">
                                                <select name="exp_year" title="Expiry Year">
                                                    <option value="22" <?php echo "22" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2022', 'whcom') ?></option>
                                                    <option value="23" <?php echo "23" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2023', 'whcom') ?></option>
                                                    <option value="24" <?php echo "24" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2024', 'whcom') ?></option>
                                                    <option value="25" <?php echo "25" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2025', 'whcom') ?></option>
                                                    <option value="26" <?php echo "26" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2026', 'whcom') ?></option>
                                                    <option value="27" <?php echo "27" == $exp_yr ? "selected=selected":'' ?> ><?php esc_html_e('2027', 'whcom') ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="whcom_col_sm_4 whcom_text_right">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <label class=""
                                           for="billingaddress"><?php esc_html_e('Billing Address', 'whcom') ?></label>
                                </div>
                            </div>
                            <div class="whcom_col_sm_8">
                                <!-- Expiry Date -->
                                <div class="whcom_form_field">
                                    <div class="whcom_row">
                                        <div class="whcom_radio_container">
                                            <label class="whcom_radio whcom_checked">
                                                <input type="radio">
                                                <?php echo '<b>' . $client['fullname'] . '</b>' . ' ' . $client['address1'] . ', ' . $client['address2'] . ', ' . $client['city'] . ', ' . $client['fullstate'] . ', ' . $client['postcode'] . ', ' . $client['countrycode']; ?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="whcom_text_center">
                        <div class="whcom_form_field whcom_form_field_horizontal">
                            <button type="submit"><?php esc_html_e("Save Changes", "whcom") ?></button>
                            <button class="whcom_button_secondary"><?php esc_html_e("Cancel", "whcom") ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>