<?php

//~~ Checking which templates are available for the specific user.
$all_shortcodes = [
    'whmpress_pricing_table' => array('advance', 'alt', 'dark', 'horizontal', 'misc', 'pic', 'retro', 'simple', 'whmpress', 'whmpress-basic'),
    'whmpress_price_matrix' => array('description', 'simple'),
    'whmpress_bundle_pricing_table' => array('whmpress'),
    'whmpress_currency_combo' => array('sleek'),
    'whmpress_order_combo' => array('advance'),
    'whmpress_price_domain_list' => array('advance','carousel','simple'),
    'whmpress_price_matrix_extended' => array('dedicated','server'),
];

//~~ initialze the array that will hold info about templates exist or not
$received_temp = array();
foreach ($all_shortcodes as $shortcode => $temp) {
    foreach ($temp as $index => $tmp_folder) {
        if (file_exists(WHMP_PLUGIN_PATH . '/templates/' . $shortcode . '/' . $tmp_folder)) {
            $received_temp[$shortcode . '_' . $tmp_folder] = 1;
        } else {
            $received_temp[$shortcode . '_' . $tmp_folder] = 0;
        }
    }
}
?>

<link href="//cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
      integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
        integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p"
        crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
        integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF"
        crossorigin="anonymous"></script>

<style>
    .whmp_widget_image_box {
        cursor: pointer;
        margin: 0 4% 10% 0;
        position: relative;
        border: 1px solid #888888;
        box-shadow: 0 1px 1px -1px rgb(0 0 0 / 10%);
        box-sizing: border-box;
        transition: 1s all;
    }
    .whmp_widget_image_box:hover {
        box-shadow: 0px 0px 5px 3px #91b5ea;
        transition: 1s all;
    }
    .whmp_widget_image_box .whmp_widget_img {
        position: relative;
        overflow: hidden;
        padding-top: 66%;
    }

    .whmp_widget_image_box .whmp_widget_img img {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        transition: opacity 0.2s ease-in-out;
    }

    .whmp_widget_box_flex {
        display: flex;
        align-items: center;
        margin: 0;
        font-size: 15px;
        font-weight: 600;
        padding: 15px;
        box-shadow: inset 0 1px 0 rgb(0 0 0 / 67%);
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        background: #fff;
        background: rgba(255, 255, 255, 0.65);
    }

    .whmp_widget_box_flex li.whmp_widget_text {
        width: 87%;
        margin-bottom: 0;
    }

    .whmp_widget_box_flex li.whmp_widget_button .button {
        width: 100%;
        text-align: center;
    }

    .whmp_widget_box_flex li.whmp_widget_button .button.whmp_green_button {
        background: #1a7e41;
        border-color: #1a7e41;
        color: #fff;
        pointer-events: none;
        cursor: not-allowed;
    }
    .accordion-flush .accordion-item .accordion-button:focus {
        border: none;
        box-shadow: none;
    }
    .accordion-flush .accordion-item .accordion-button {
        border-radius: 4px;
        background: #e0e0e0;
        margin-bottom: 11px;
    }
    .accordion-flush .accordion-item .accordion-button:hover {
        0px 1px 6px 2px #898787
    }
    .whmp_widget_cong_text {
        position: absolute;
        font-size: 14px;
        left: -1px;
        color: green;
        border: 1px dashed;
        border-top: none;
        right: -1px;
        padding: 6px 12px;
        font-weight: 500;
    }
</style>


<form method="post" action="#">
    <input type="hidden" class="whmpress_purchase_code" value="<?php echo get_option('whmp_purchase_code') ?>">
    <div class="wrap whmp_wrap">
        <h2 class=""> Widget Templates </h2>
        <div class="accordion accordion-flush" id="accordionFlushExample">
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-headingOne">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                        Pricing Table
                    </button>
                </h2>
                <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne"
                     data-bs-parent="#whmpress_pricing_table_accordion">
                    <div class="row">
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/advace-whmpress.png" alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Advance
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_advance'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_advance'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="advance"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/alt-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Alt
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_alt'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_alt'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="alt"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box mr-0">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/darak-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Dark
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_dark'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_dark'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="dark"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/horizantal-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Horizontal
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_horizontal'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_horizontal'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="horizontal"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/misc-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Misc
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_misc'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_misc'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="misc"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/pic-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Pic
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_pic'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_pic'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="pic"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/retro-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Retro
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_retro'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_retro'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="retro"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/simple-whnpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Simple
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_simple'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_simple'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="simple"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/whmpress-whmmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Whmpress
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_whmpress'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_whmpress'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="whmpress"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-4 col-lg-4 col-sm-6">
                            <div class="whmp_widget_image_box">
                                <div class="whmp_widget_img">
                                    <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/whmpress-basic-whmpress.png"
                                         alt="" style="width: 100%">
                                </div>
                                <ul class="whmp_widget_box_flex">
                                    <li class="whmp_widget_text">
                                        Whmpress Basic
                                    </li>
                                    <?php
                                    $received_class = $received_temp['whmpress_pricing_table_whmpress-basic'] == 1 ? 'whmp_green_button' : '';
                                    $btn_text = $received_temp['whmpress_pricing_table_whmpress-basic'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                    ?>
                                    <li class="whmp_widget_button" id="whmpress_pricing_table">
                                        <a href="#" id="whmpress-basic"
                                           class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                    </li>
                                </ul>
                                <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can use
                                    it now.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-headingTwo">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                        Price Matrix
                    </button>
                </h2>
                <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo"
                     data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/domain-matrix-discription-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Description
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_matrix_description'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_matrix_description'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_matrix">
                                            <a href="#" id="description"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use
                                        it now.
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/simple-matrix-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Simple
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_matrix_simple'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_matrix_simple'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_matrix">
                                            <a href="#" id="simple"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use
                                        it now.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-headingThree">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThree" aria-expanded="false"
                            aria-controls="flush-collapseThree">
                        Bundle Pricing Table
                    </button>
                </h2>
                <div id="flush-collapseThree" class="accordion-collapse collapse" aria-labelledby="flush-headingThree"
                     data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/bundale-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Whmpress
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_bundle_pricing_table_whmpress'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_bundle_pricing_table_whmpress'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_bundle_pricing_table">
                                            <a href="#" id="whmpress"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use
                                        it now.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--            <div class="accordion-item">-->
            <!--                <h2 class="accordion-header" id="flush-headingFour">-->
            <!--                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"-->
            <!--                            data-bs-target="#flush-collapseFour" aria-expanded="false"-->
            <!--                            aria-controls="flush-collapseFour">-->
            <!--                        Currency Combo-->
            <!--                    </button>-->
            <!--                </h2>-->
            <!--                <div id="flush-collapseFour" class="accordion-collapse collapse" aria-labelledby="flush-headingFour"-->
            <!--                     data-bs-parent="#accordionFlushExample">-->
            <!--                    <div class="accordion-body">-->
            <!--                        <div class="row">-->
            <!--                            <div class="col-xl-4 col-lg-4 col-sm-6">-->
            <!--                                <div class="whmp_widget_image_box">-->
            <!--                                    <div class="whmp_widget_img">-->
            <!--                                        <img src=""-->
            <!--                                             alt="" style="width: 100%">-->
            <!--                                    </div>-->
            <!--                                    <ul class="whmp_widget_box_flex">-->
            <!--                                        <li class="whmp_widget_text">-->
            <!--                                            Sleek-->
            <!--                                        </li>-->
            <!--                                        --><?php
            //                                        $received_class = $received_temp['whmpress_currency_combo_sleek'] == 1 ? 'whmp_green_button' : '';
            //                                        $btn_text = $received_temp['whmpress_currency_combo_sleek'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
            //                                        ?>
            <!--                                        <li class="whmp_widget_button" id="whmpress_currency_combo">-->
            <!--                                            <a href="#" id="sleek"-->
            <!--                                               class="button whmpress_get_template --><?php //echo $received_class ?><!--"> --><?php //echo $btn_text ?><!-- </a>-->
            <!--                                        </li>-->
            <!--                                    </ul>-->
            <!--                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can-->
            <!--                                        use-->
            <!--                                        it now.-->
            <!--                                    </div>-->
            <!--                                </div>-->
            <!--                            </div>-->
            <!--                        </div>-->
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--            <div class="accordion-item">-->
            <!--                <h2 class="accordion-header" id="flush-headingFive">-->
            <!--                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"-->
            <!--                            data-bs-target="#flush-collapseFive" aria-expanded="false"-->
            <!--                            aria-controls="flush-collapseFive">-->
            <!--                        Order Combo-->
            <!--                    </button>-->
            <!--                </h2>-->
            <!--                <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive"-->
            <!--                     data-bs-parent="#accordionFlushExample">-->
            <!--                    <div class="accordion-body">-->
            <!--                        <div class="row">-->
            <!--                            <div class="col-xl-4 col-lg-4 col-sm-6">-->
            <!--                                <div class="whmp_widget_image_box">-->
            <!--                                    <div class="whmp_widget_img">-->
            <!--                                        <img src=""-->
            <!--                                             alt="" style="width: 100%">-->
            <!--                                    </div>-->
            <!--                                    <ul class="whmp_widget_box_flex">-->
            <!--                                        <li class="whmp_widget_text">-->
            <!--                                            Advance-->
            <!--                                        </li>-->
            <!--                                        --><?php
            //                                        $received_class = $received_temp['whmpress_order_combo_advance'] == 1 ? 'whmp_green_button' : '';
            //                                        $btn_text = $received_temp['whmpress_order_combo_advance'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
            //                                        ?>
            <!--                                        <li class="whmp_widget_button" id="whmpress_currency_combo">-->
            <!--                                            <a href="#" id="advance"-->
            <!--                                               class="button whmpress_get_template --><?php //echo $received_class ?><!--"> --><?php //echo $btn_text ?><!-- </a>-->
            <!--                                        </li>-->
            <!--                                    </ul>-->
            <!--                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can-->
            <!--                                        use it now.-->
            <!--                                    </div>-->
            <!--                                </div>-->
            <!--                            </div>-->
            <!--                        </div>-->
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-headingSix">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSix" aria-expanded="false"
                            aria-controls="flush-collapseSix">
                        Price Domain List
                    </button>
                </h2>
                <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix"
                     data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/advance-domain-list-whmpresss.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Advance
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_domain_list_advance'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_domain_list_advance'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_domain_list">
                                            <a href="#" id="advance"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use it now.
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/carousal-domain-list-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            carousel
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_domain_list_carousel'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_domain_list_carousel'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_domain_list">
                                            <a href="#" id="carousel"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use it now.
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/simple-domain-list-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Simple
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_domain_list_simple'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_domain_list_simple'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_domain_list">
                                            <a href="#" id="simple"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use it now.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-headingSeven">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSeven" aria-expanded="false"
                            aria-controls="flush-collapseSeven">
                        Price Matrix Extended
                    </button>
                </h2>
                <div id="flush-collapseSeven" class="accordion-collapse collapse" aria-labelledby="flush-headingSeven"
                     data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/price-matrix-extaed-whmpress.png" alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Dedicated
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_matrix_extended_dedicated'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_matrix_extended_dedicated'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_matrix_extended">
                                            <a href="#" id="dedicated"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use it now.
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-sm-6">
                                <div class="whmp_widget_image_box">
                                    <div class="whmp_widget_img">
                                        <img src="<?php echo WHMP_PLUGIN_URL ?>/admin/images/sever-whmpress.png"
                                             alt="" style="width: 100%">
                                    </div>
                                    <ul class="whmp_widget_box_flex">
                                        <li class="whmp_widget_text">
                                            Server
                                        </li>
                                        <?php
                                        $received_class = $received_temp['whmpress_price_matrix_extended_server'] == 1 ? 'whmp_green_button' : '';
                                        $btn_text = $received_temp['whmpress_price_matrix_extended_server'] == 1 ? esc_html__('Received', 'admin', 'ptsc') : esc_html__('Get it!', 'admin', 'ptsc');
                                        ?>
                                        <li class="whmp_widget_button" id="whmpress_price_matrix_extended">
                                            <a href="#" id="server"
                                               class="button whmpress_get_template <?php echo $received_class ?>"> <?php echo $btn_text ?> </a>
                                        </li>
                                    </ul>
                                    <div class="whmp_widget_cong_text" style="display: none;">Congratulations!! You can
                                        use it now.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
    jQuery('.whmpress_get_template').on('click', function (e) {
        e.preventDefault();
        let data = [];
        var $this = jQuery(this);
        var $purchase_code = jQuery(document).find('.whmpress_purchase_code').val();
        data = 'action=whmp_get_requested_template&whmp_temp_name=' + jQuery(this).attr('id');
        data += '&whmp_sc_name=' + jQuery(this).parent().attr('id') + '&whmp_purchase_code=' + $purchase_code;
        console.log(data);
        jQuery(this).text("Setting Up...");
        jQuery(this).addClass("whmp_temp_requested");
        setTimeout(function () {
            jQuery.post(ajaxurl, data, function (response) {
                if (response === 'OK') {
                    jQuery('.whmp_temp_requested').text("Received");
                    jQuery('.whmp_temp_requested').addClass("whmp_green_button");
                    $this.parent().parent().next(".whmp_widget_cong_text").slideToggle();
                } else {
                    alert(response);
                }
                //jQuery( ".full_page_loader" ).hide();
            });
        }, 3000);


        setTimeout(function () {
            jQuery(".whmp_widget_cong_text").hide();
        }, 6000);
    });
</script>

