<?php
/**
 * Copyright (c) 2014-2021 by creativeON.
 */

if ( ! function_exists( 'add_action' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

/**
 * WHMPress uses session variables when currency is selected
 * These hooks control session early.
 *
 * Thanks to peter at http://silvermapleweb.com/using-the-php-session-in-wordpress/
 */
add_action( 'init', 'whmpress_session_start', 1 );
add_action( 'wp_logout', 'whmpress_session_end' );
add_action( 'wp_login', 'whmpress_session_end' );
function whmpress_session_end() {
	if ( session_id() ) {
		@session_destroy();
	}
}

function whmpress_session_start() {
	if ( ! session_id() ) {
        $cacheValue = get_option('whmpress_session_cache_limiter_value');
        session_cache_limiter($cacheValue);
//		@session_start();
	}
}

$whmp_submenu_pages = [];

# Getting data version from plugin file
if ( ! function_exists( 'get_plugins' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}
$plugin_data = get_plugin_data( dirname( __FILE__ ) . "/whmpress.php" );

defined( 'WHMP_VERSION' )
|| define( 'WHMP_VERSION', plugin_get_version() );

defined( 'WHMP_PLUGIN_NAME' )
|| define( 'WHMP_PLUGIN_NAME', basename( dirname( __FILE__ ) ) );

define( 'WHMP_PLUGIN_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ) )
|| defined( 'WHMP_PLUGIN_DIR' );

defined( 'WHMP_PLUGIN_URL' )
|| define( 'WHMP_PLUGIN_URL', untrailingslashit( plugins_url( WHMP_PLUGIN_NAME ) ) );

defined( 'WHMP_ADMIN_DIR' )
|| define( 'WHMP_ADMIN_DIR', WHMP_PLUGIN_DIR . '/admin' );

defined( 'WHMP_ADMIN_URL' )
|| define( 'WHMP_ADMIN_URL', WHMP_PLUGIN_URL . '/admin' );


/* Setting WHMpress tables */
global $wpdb;
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
$charset_collate = $wpdb->get_charset_collate();

if (!function_exists("whmp_read_local_file")) {
    function whmp_read_local_file($filepath)
    {
        if (!is_file($filepath)) {
            return false;
        }
        global $wp_filesystem;
        if (empty($wp_filesystem)) {
            require_once(ABSPATH . '/wp-admin/includes/file.php');
            WP_Filesystem();
        }

        $content = $wp_filesystem->get_contents($filepath);
        if (empty($content)) {
            $content = file_get_contents($filepath);
        }

        return $content;
    }
}

if (get_option('whmp_tlds_insert') != 1) {
//== Initializing Tlds Tables
    function whmpress_include_tlds()
    {
        register_setting('whmp_tlds_data', 'whmp_tlds_insert');
        include_once(WHMP_PLUGIN_DIR . "/includes/tlds.php");
    }

    add_action('init', 'whmpress_include_tlds');
}
