# WP Online Contract Plugin

WordPress Online Contract is the original plugin that allows you to create, manage, and save contracts online through WordPress. You can customize contracts using flat text files and short codes and view revisions of your existing contracts. Give your clients a way to view and sign your contracts online in one place.

Completely responsive for any device. Send your clients your contract online and give them the opportunity to view, sign, save, and print from any location and any device. Get started faster and more efficiently with WordPress Online Contract.

This one-of-a-kind plugin was created with your client in mind. Use our system to maintain and manage your contracts and give your clients ease of mind in a professional way. We have used a flat file type system for years and integrated our system into a fully loaded plugin that is completely manageable from WordPress at the click of a button.

## NEW FEATURES

- **ADDED REQUIRED FIELDS TO CONTRACTS** Add a set of required fields to a contract that the user must complete before signing. You can set any shortcode field to be required on a contract before signing.
- **ADDED PRINT NAME** You can specify if you want a user to print their name on a contract before they can sign.
- **BETTER UPDATE AND AUTHENITICATION** Directly integrated with APIs to better authenticate and store purchase codes. More streamlined update functionality.
- **PHP7 INTEGRATION** Updated core code to work with newer servers and WordPress installations.
- **MODIFY CONTRACT PERMALINK** Setup your contract to work on the links you want. You are no longer limited to the /contract/ permalink.
- **AUDIT LOG** Every time a contract is signed, reopened, or changed a audit log is created.
- **VIEW OPTIONS** Once a contract is signed, you can still see the values but cannot edit until the contract is reopened.
- **GUTENBERG READY** Added functionality to use Gutenberg editor with contract display shortcodes.
- **ADD NOINDEX / NOFOLLOW** Added noindex / nofollow to contract to prevent search engine indexing.
- **THEME COMPATIBLE** Contract can either be displayed in your theme or without header and footer to display only a white page.
- **BETTER JS HANDLING** Integrated directly into WordPress's core functionality for processing JS requests.

## PLUGIN FEATURES

- **CREATE YOUR OWN TEMPLATES** Use WordPress’s built in editor create your own contract template.
- **AUTOMATIC EMAIL NOTIFICATIONS** Send email notifications to your clients automatically with the check of a box.
- **CREATE REUSABLE CONTRACTS** Have users sign a contract without creating the contract multiple times. Example: Terms of Service Aggreement
- **SIGNED / UNSIGNED STATUSES** get visible indication of your contract's status from the dashboard, contract list, and individual contract edit screens.
- **CUSTOM SHORTCODES** Add your own shortcodes.
- **REORDER SHORTCODES** Reorder new or previously created shortcodes
- **DEFAULT SHORTCODES** Quickly load and use the default shortcodes as seen in our demo
- **PRINT CONTRACTS ONLINE** Once signed, your client and print their contract and even pay the initial balance.
- **PASSWORD PROTECTED** Contracts can be password protected easily using WordPress’s built-in feature
- **SIGNATURE AUTHENTICATION** IP address and client timestamp are saved and displayed when a client signs online so you can track where and where it was signed
- **FULLY RESPONSIVE** Allows for any device to be used in creating, editing, or signing a contract online.
- **UNLIMITED POTENTIAL** Create unlimited templates, unlimited contracts, unlimited custom shortcodes.
- **REOPEN CONTRACTS** Remove a signature to reopen a contract for changes.
- **CLIENT INITIATED CONTRACTS** Add a simple shortcode to any page on your site to add a form and get a notification when a client creates their own contract
- **GET PAID QUICKLY** Have multiple payment methods including Stripe, Authorize.net, Dwolla, and Skrill as an addon. PayPal comes free with our plugin!
- **REDIRECT AFTER SIGNING** Create redirects to send the client to a new page when they sign their contract
- **SEND LINK TO PDF AFTER SIGNING** Once a contract is signed by your client, they will receive a email with a direct link to the printable PDF
- **JUST WANT A PRINTABLE CONTRACT?** Remove signature window to give your clients a downloadable offline version
- **CONTRACT CATEGORIES** Organize your contracts into categories just like WordPress posts
- **CONTRACT EMBED** Embed functional contracts on any page you want using a shortcode

### Version History

**Version 5.1.4**

- Fixed issue with selecting a new template after creating contract

**Version 5.1.3**

- fixed installs on a subfolder
- fixed archive overwrite
- fixed issue with multisite not redirecting properly
- fixed issue with frontend error message if purchase invalidated
- added shortcode for post ID [postid]
- added shortcode for current date [currentdate]
- added template select for shortcodes for frontend, and backend
- added template attribute to frontend shortcode [clientadd]
- added ability to create multiple [clientadd] pages

**Version 5.1.2**

- fixed admin.php absolute path

**Version 5.1.1**

- fixed calendar popover and custom date format
- added jquery UI icons

**Version 5.1.0**

- removed debugging to resolve immediate issues
- fixed issue with autoupdate

**Version 5.0.10**

- added new class for multisite installation

**Version 5.0.9**

- fixed admin email glitch

**Version 5.0.8**

- added new languages
- updated stripe integration
- updated JS and CSS calls to be local
- included more translate-able text
- updated included libraries
- updated PHP code

**Version 5.0.7**

- fixed outstanding issues

**Version 5.0.6**

- updated multisite verbiage
- fixed zipping issue

**Version 5.0.5**

- Added UTF-8 encoding to emails that are being sent
- Fixed IP address lookup for specific URL if adblocker is on
- Added multisite addon integration

**Version 5.0.4**

- Fixed issue of ip being blocked when signed (adblocker)
- Fixed datapicker warnings
- Added contract type filter to [emaillist] shortcode to view only certain types of contracts
- Added sort for contract type column
- Added Google Recaptcha for more spam free submissions
- Added email send to administrator when a contract is created or updated

**Version 5.0.3**

- Enabled PDF print addon if needed
- Added checks for multisite
- Added list of other addons for this plugin
- Added blank target for redirects

**Version 5.0.2**

- Fixed currency settings in Stripe
- Fixed checkbox labels
- Created blank archive to remove visibility of contracts
- Added update / new contract email template
- Fixed check all for multiselect in admin dashboard
- Fixed client add to work better with WP insert
- Removed archive page and made it display a 404
- Added contract sort to Contracts dashboard
- Added shortcode ability for email subject
- Added update notification email template
- Added ability to redirect users once they sign a user-initiated contract
- Fixed permissions issue preventing users from creating new contracts on some servers

**Version 5.0.1**

- Fixed 404 on activate, now plugin should auto refresh permalinks
- Gave users the ability to choose required and non-required fields when creating a shortcode (visible on front and admin)
- Disabled rss feed within plugin so no contract links are shared via rss

**Version 5.0.0**

- Rewrote entire plugin
- Integrated with PHP7+
- Fixed compatibility issues with other plugins
- Added FontAwesome icons
- Integrated into Gutenberg
- Removed PDF print because it was causing issues and most modern browsers can print PDFs using browser functions
- Added force use to print name
- Added prepared fields for contract that are required to be filled out before signing
- Added ability to modify permalinks
- Removed [showcontract] shortcode because now it works in the theme
- Gave instructions to prevent header and footer from being displayed on the contract
- Added audit log
- Added view options for signed contract
- Added noindex nofollow to contract single pages

**Version 4.xx**

- Fixed bug with PDF generation for contracts with a offline signature
- Added business name for all FROM emails for notifications
- Fixed custom date format on PDF signatures
- Fixed integration with Nextgen Gallery
- Fixed blank print issue using browser print instead
- Added the ability to setup local date and have it recursively change through the entire plugin
- Added the ability to change the default text displayed above the signature window on the contracts, can be found in Settings
- Fixed the bug that showed an error through frontend.php if no shortcodes were added
- Ordered [getusersemail] by First Name instead of email
- Auto email PDF link to client when they sign a contract
- Order shortcodes, (no more having to delete or recreate shortcodes to put them in order)
- Create default set of shortcodes to get you started
- Contracts can now be categorized
- Embed single contracts on front facing pages of your website as you see fit with a shortcode
- Create reusable contracts; have unlimited users sign it and automatically create a new contract with their signature; no longer just one-to-one, now one-to-many

**Version 3.xx**

- Removed ability to have users publish contract from front end, this was causing issues with non logged in users not being able to publish. It is now set back to pending.
- Fixed bug preventing settings from loading or giving a 500 error
- Fixed issue where some instances of signature window does not appear due to outside of plugin interference
- Added ability to remove PayPal if not wanted
- Removed restriction and now when a client initiates a contract, it will no longer need approval/li>
- If contract is signed, all options are disabled until contract is reopened
- Fixed bug that was causing the PDF to not load correctly
- Fixed bug that was causing slashes to be added to the PDF
- Fixed bug that was preventing users from clearing signatures
- Add function that auto scrolls to payment and print options when a contract is signed
- Added Spanish (Spain) language
- Fixed major issue with multisite
- Added French translation
- Fixed default date issue when adding a new date box
- Fixed issue that was preventing [clientlist] for appearing
- Fixed automatic email notification issues
- Fixed SSL and non SSL conflicts
- Multilingual
- Redesigned documentation
- Complete redevelopment of source code to better line with WP standards
- Custom shortcode integration
- Ability to add new CSS to contract and print
- Page redirect upon signature
- Ability to remove signature box
- Custom shortcode functions by user
- Better interface for user initiated contracts and list of contracts per user
- Updated dashboard and added contract list ability internally for users other than admin

**Version 2.xx**

- Show rep that signed on the main contract page
- Added functionality to add custom text to payment buttons
- List all contracts based on user’s email address
- Added ability to style password form as well as the contract
- Added ability to add a email template subject
- Fixed content link to signature file
- Fixed issue with PDF saving and Adobe popup error notifiing user an invalid font is being used
- Added ability to create or modify stylesheet to creator preferences
- Fixed issue with encoding ampersands when modifying or creating a new contract template
- Added textbox when creating a password protected contract to send password via email when client is notified
- Added client mailing address shortcode
- Added addon integration for Authorize.net payment
- Fixed naming scheme to prevent conflict with other plugins
- Fixed issues with payment rounding
- Added ability to add fee to Paypal
- Fixed style issue with save and cancel buttons not having a bottom margin
- Added addon integration for Skrill (formerly known as MoneyBookers) payment
- Modified dashboard and list “Sign / Unsigned” to make them stand out more
- Added shortcode for client email, now client email address can be added to the contract templates
- Created a new setting to allow user to create an email template for client notifications
- Resolved an issue with some sites not saving signature due to being set up as a multi site
- Fixed a potential issue with other plugins overwriting the contract permalink
- Fixed another PDF display issue
- Fixed error causing PDF to not display
- Made WP Editor handle single and double quotes better
- Forced WP Editor to not rewrite inline CSS
- Added Stripe Payment Module capability using addon plugin

**Version 1.xx**

- Fixed error that was causing sign module to disappear
- Add ability to add payment plugin modules
- Error was causing the PDF to not display. This has been fixed.
- Allow WordPress to auto update plugin
- Made display and sign more responsive
- Added ability to automatically send to client’s email when contract is published
- Added client initiated contact form shortcode to allow clients to create their own contract, agency must approve
- Implemented a “Make Sure” catch to make sure that you do not delete or edit items that you do not want to
- WordPress Editor integration
- Fixed PDF issue
- IP Address is now recorded when a client signs the contract
- Dashboard widget integration
- Signature icon with a pen
- Payment outlet using Paypal
- Made contract buttons more eye friendly
- Sort by status (signed or unsigned)
- Fixed navigation link that could cause the plugin to not show up in admin menu
- Receive notifications when a contract is viewed, notifications stop after they sign the contract
- Fixed a bug with the visual editor preventing the short code from being added
- Added ability to make contracts password protected
- Added the ability to print or create a PDF to a signed contract.
- Updated to reflect a bug in the view source button. It now responds to main and sub domain usage.
- Added required field valiation to prevent contracts from not displaying data as intended. All fields are now required.
- WordPress Online Contract is offical. Enjoy
