<?php
if (is_plugin_active('wp-online-contract-multisite/online-contract-multisite.php')) {
	require_once WP_PLUGIN_DIR . '/wp-online-contract-multisite/online-contract-multisite.php';
	$multi_setup = ((new WPOC_Multi_Admin())->setup());
}
?>
<?php
echo '<div id="showhelpalt">';
echo '<h3>' . __('Need Help?', 'onlinecontract') . '</h3>';
echo '<p>' . __('View Documentation', 'onlinecontract') . ': <a href="https://futuredesigngroup.gitbook.io/wp-online-contract/" target="_blank">' . __('Documentation', 'onlinecontract') . '</a>
<br>
' . __('View Video Tutorial', 'onlinecontract') . ': <a href="https://www.youtube.com/watch?v=36sU2q7FzF4" target="_blank">' . __('View On', 'onlinecontract') . ' YouTube</a></p>';
echo '<p>' . __('If you still need help, you can create a message on Envato. We do not always monitor the message so please be patient.', 'onlinecontract') . '</p>';
if (is_multisite()) {
	if (isset($multi_setup)) {
		echo '<p><strong>' . __('Multisite Enabled', 'onlinecontract') . ':</strong> ' . __('Yes', 'onlinecontract') . '</p>';
	} else {
		echo '<p><strong>' . __('Multisite Enabled', 'onlinecontract') . ':</strong> ' . __('Yes', 'onlinecontract') . ' - <span style="color:red;">You are using multisite, but have not installed our multisite addon.</span></p>';
	}
} else {
	echo '<p><strong>' . __('Multisite Enabled', 'onlinecontract') . ':</strong> ' . __('No', 'onlinecontract') . '</p>';
}
echo '<p><strong>' . __('Version', 'onlinecontract') . ':</strong> ' . ONLINE_CONTRACT_VERSION_NUMBER . '</p>';
echo '<p><strong>' . __('Product Name', 'onlinecontract') . ':</strong> WordPress Online Contract</p>';
echo '<p><strong>' . __('Purchase Code', 'onlinecontract') . ':</strong> ' . tr_options_field('fdg_plugin_options_purchase.purchase_code') . ' <em>(DO NOT SHARE)</em></p>';
echo '<p><strong>' . __('Website URL', 'onlinecontract') . ':</strong> ' . get_site_url() . '</p>';
echo '<p><strong>PHP ' . __('Version', 'onlinecontract') . ':</strong> ' . phpversion() . '</p>';
echo '</div>';
echo '<h2>' . __('Addons for this Plugin', 'onlinecontract') . '</h2>';
echo '<a href="https://codecanyon.net/item/wp-online-contract-stripe-payments/8001391" target="_blank"><img src="https://s3.envato.com/files/288289421/icon.jpg"></a> ';
echo '<a href="https://codecanyon.net/item/wp-online-contract-pdf-print-integration/26583670" target="_blank"><img src="https://s3.envato.com/files/288287713/icon.jpg"></a> ';
echo '<a href="https://codecanyon.net/item/wp-online-contract-multisite-integration/32657927" target="_blank"><img src="https://s3.envato.com/files/344181323/icon.jpg"></a>';
