<?php
/*
Plugin Name: WP Online Contract
Plugin URI: https://www.futuredesigngroup.com/wp-online-contract
Description: WP Online Contract allows you to create, manage, and save contracts online through Wordpress.  You can customize contracts via WP Editor and shortcodes and view revisions of your existing contracts.  Give your clients a way to view and sign your contracts online in one place.
Version: 5.1.4
Author: Future Design Group
Author URI: http://futuredesigngroup.com
Text Domain: onlinecontract
Domain Path: /languages/
License: GPL2
Copyright 2014-2018  Future Design Group  (email : olivere@futuredesigngroup.com)
Subgroup: WP Online Contract

LICENSE
Copyright 2014-2018 Future Design Group <olivere@futuredesigngroup.com>
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.	 See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA 
*/

DEFINE('ONLINE_CONTRACT_VERSION_NUMBER', '5.1.4');
DEFINE('ONLINE_CONTRACT_FILE_LOCATION', __FILE__);
DEFINE('ONLINE_CONTRACT_FILE', 'onlinecontract/');
DEFINE('ONLINE_CONTRACT_DIR', plugin_dir_path(__DIR__) . 'onlinecontract/');
DEFINE('ONLINE_CONTRACT_URL', plugin_dir_url(__DIR__) . 'onlinecontract/');
DEFINE('ONLINE_CONTRACT_PREFIX', 'OC_');

use FDG\OnlineContract\Loader;

require __DIR__ . '/autoload.php';
require_once('typerocket/init.php');

/**
 * Pretty print returned arrays
 *
 * @param array $arr
 * @return void
 */
function formatcode($arr)
{
  echo '<pre>';
  print_r($arr);
  echo '</pre>';
}

(function () {
  $loader = new Loader();
  $loader->init();
})();
