<?php

namespace FDG\OnlineContract;

use FDG\OnlineContract\Setup\Setup;
use FDG\OnlineContract\Admin\Admin;
use FDG\OnlineContract\Admin\Contract;
use FDG\OnlineContract\Frontend\Frontend;
use FDG\OnlineContract\Setup\Init;
use FDG\OnlineContract\Setup\Messages;
use FDG\OnlineContract\Setup\Parser;
use FDG\OnlineContract\Setup\Sendmail;

class Loader
{

    public $settings = null;

    /**
     * Setup initialization of plugin files
     */
    public function __construct()
    {
        $this->settings = Init::getSettings();
        $this->Parser = new Parser();
        add_action('typerocket_loaded', function () {
            load_plugin_textdomain('onlinecontract', false, ONLINE_CONTRACT_DIR . 'languages');
        });
    }

    /**
     * Add JS and CSS to plugin
     *
     * @return void
     */
    public function enqueueInit()
    {
    }

    /**
     * Initialize plugin controllers
     *
     * @return void
     */
    public function init()
    {
        $this->registerPlugin();
        $this->registerAdmin();
        $this->registerFrontend();
    }

    /**
     * Register the hooks
     *
     * @return void
     */
    public function registerPlugin()
    {
        (new Setup($this->settings))->registerHooks();
        (new Sendmail())->registerHooks();
    }

    /**
     * Register admin hooks and functions
     *
     * @return void
     */
    public function registerAdmin()
    {
        (new Admin())->registerHooks();
        (new Contract())->registerHooks();
    }

    /**
     * Register frontend hooks and functions
     *
     * @return void
     */
    public function registerFrontend()
    {
        (new Frontend())->registerHooks();
    }
}
