<?php

namespace FDG\OnlineContract\Payments;

use FDG\OnlineContract\Setup\Setup;
use FDG\OnlineContract\Setup\Init;
use FDG\OnlineContract\Frontend\Frontend;
use FDG\OnlineContract\Setup\Parser;

class Paypal
{

    public function __construct()
    {
        $this->settings = Init::getSettings();
        $this->setup = (new Setup(Init::getSettings()));
    }

    /**
     * Admin setup for PayPal button
     *
     * @param object $form
     * @return string
     */
    public static function getPaypalForm($form)
    {
        $paypal = function () use ($form) {
            echo '<p>' . __('If you are wanting to use PayPal as a integrated method of Payment after a contract is signed, use the following section to provide a bit of information for our plugin to use, otherwise leave this section blank.', 'onlinecontract') . '</p>';
            echo $form->text(__('PayPal Email Address', 'onlinecontract'));
            echo $form->text(__('PayPal Fee', 'onlinecontract'));
            echo $form->text(__('PayPal Button Label', 'onlinecontract'));
            echo $form->checkbox(__('Turn Off PayPal?', 'onlinecontract'));
            echo '<br>';
            echo '
            <h3>' . __('PayPal Payment Integration', 'onlinecontract') . '</h3>
            <p>' . __('Add a payment option to your contracts using PayPal.  Setup your PayPal button using the options to the left. Once you configure the options, a PayPal button will be added to your contract automatically.', 'onlinecontract') . '</p>          
            <h3>' . __('Need to Create a Account?', 'onlinecontract') . '</h3>
            <p>' . __('If you would like to use the payment option but do not have a PayPal account, you can join on their website.  It is free and easy to get started.  Visit <a href="http://paypal.com" target="_blank">www.paypal.com</a> to see the benefits of signing up and to create an account.', 'onlinecontract') . '</p>
            <h3>' . __('Need More Payment Methods?', 'onlinecontract') . '</h3>
            <p>' . __('Please see our portfolio for more payment processing plugins built by Future Design Group for our WP Online Contract plugin.', 'onlinecontract') . ' <a href="http://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" target="_blank">' . __('View Portfolio', 'onlinecontract') . '</a></br></p>
            <p style="text-align:right">Version: ' . ONLINE_CONTRACT_VERSION_NUMBER . '</p>
            ';
        };
        return $paypal;
    }

    /**
     * Add PayPal button to front end after signing
     *
     * @param string $amount
     * @param string $itemname
     * @return string
     */
    public static function getPaypalButton($amount, $itemname)
    {
        $settings = Init::getSettings();
        $fontawesome = '';
        $amount = Frontend::formatTemplate('[' . $amount . ']');
        $paypalfee = tr_options_field('fdg_payment_options.paypal_fee');
        if (strpos($paypalfee, '%') !== false) {
            $paypalfee = str_replace('%', '', $paypalfee);
            $paypaltotal = round((new Parser())->Execute($amount * ($paypalfee / 100)), $settings['decimalRound']);
            $paypaltotal =  round((new Parser())->Execute($amount + $paypaltotal), $settings['decimalRound']);
        } else {
            $paypaltotal =  round((new Parser())->Execute($amount + $paypalfee), $settings['decimalRound']);
        }
        $itemname = Frontend::formatTemplate('[' . $itemname . ']');
        if ($settings['fontAwesome'] == 1) {
            $fontawesome = '<em class="fab fa-paypal" aria-hidden="true"></em> ';
        }
        $paypalbutton = '
            <div style="float:right;margin-left:10px;">	
                <button type="button" class="btn button paypal" onclick="window.open(\'https://www.paypal.com/cgi-bin/webscr?business=' . tr_options_field('fdg_payment_options.paypal_email_address') . '&amp;cmd=_xclick&amp;currency_code=' . $settings['currencyType'] . '&amp;amount=' . $paypaltotal . '&amp;item_name=' . $itemname . '\',\'_blank\')">' . $fontawesome . tr_options_field('fdg_payment_options.paypal_button_label') . '</button>
            </div>';

        return $paypalbutton;
    }
}
