<?php

namespace FDG\OnlineContract\Setup;

class Init
{
    /**
     * Create accessible options to be used throughout the plugin
     *
     * @return void
     */
    public static function getSettings()
    {
        $settings = [
            //'debug' => (tr_options_field('fdg_plugin_options.debug_plugin') != NULL ? 1 : 0),
            'debug' => 0,
            'slug' => (tr_options_field('fdg_plugin_options.contract_permalink') != NULL ? tr_options_field('fdg_plugin_options.contract_permalink') : 'contract'),
            'purchaseCode' => tr_options_field('fdg_plugin_options_purchase.purchase_code'),
            'adminEmail' => (tr_options_field('fdg_plugin_options.administration_email') != NULL ? tr_options_field('fdg_plugin_options.administration_email') : get_bloginfo('admin_email')),
            'fontAwesome' => (tr_options_field('fdg_plugin_options.use_fontawesome_icons?') ? 1 : 0),
            'clientEmailShortcode' => (tr_options_field('fdg_plugin_options.client_email_shortcode') ? tr_options_field('fdg_plugin_options.client_email_shortcode') : ''),
            'decimalRound' => (tr_options_field('fdg_plugin_options.decimal_round') ? tr_options_field('fdg_plugin_options.decimal_round') : '0'),
            'currencyType' => (tr_options_field('fdg_plugin_options.currency_type') ? tr_options_field('fdg_plugin_options.currency_type') : 'USD'),
            'currencySymbol' => (tr_options_field('fdg_plugin_options.currency_symbol') ? tr_options_field('fdg_plugin_options.currency_symbol') : '$'),
            'companyName' => (tr_options_field('fdg_plugin_options.your_company_name') ? tr_options_field('fdg_plugin_options.your_company_name') : ''),
            'dateFormat' => (tr_options_field('fdg_plugin_options.date_format') ? tr_options_field('fdg_plugin_options.date_format') : 'd/m/Y'),
            'datePickerFormat' => (tr_options_field('fdg_plugin_options.datepicker_format') ? tr_options_field('fdg_plugin_options.datepicker_format') : 'd/m/yy'),
            'emailSubject' => (tr_options_field('fdg_template_options.updated_email_subject') ? tr_options_field('fdg_template_options.updated_email_subject') : 'A Contract Has Been Created For You'),
            'emailContent' => (tr_options_field('fdg_template_options.updated_email_content') ? tr_options_field('fdg_template_options.updated_email_content') : '<p>A new contract has been created for you. You can view it here:<br>[contract-link]
            </p>'),
            'enableRecaptcha' => (tr_options_field('fdg_plugin_options.enable_recaptcha') ? tr_options_field('fdg_plugin_options.enable_recaptcha') : ''),
            'recaptchaSiteKey' => (tr_options_field('fdg_plugin_options.recaptcha_site_key') ? tr_options_field('fdg_plugin_options.recaptcha_site_key') : '')
        ];
        //formatcode($settings);
        return $settings;
    }
}
