<?php

namespace FDG\OnlineContract\Setup;

class Messages
{

    /**
     * Initialize the messages class
     *
     * @param string $message
     * @param string $class
     */
    function __construct($message, $class)
    {
        $this->message = $message;
        $this->class = $class; //notice-error, notice-success
        add_action('admin_notices', [$this, 'render']);
    }

    /**
     * Render the message
     *
     * @return void
     */
    function render()
    {
        $class = 'notice ' . $this->class . ' is-dismissible';
        printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($this->message));
    }
}
