<?php

namespace FDG\OnlineContract\Setup;

use FDG\OnlineContract\Setup\Setup;
use FDG\OnlineContract\Setup\Init;
use FDG\OnlineContract\Frontend\Frontend;

class Sendmail
{

    /**
     * Initialize the Sendmail class
     */
    function __construct()
    {
        $this->settings = Init::getSettings();
        $this->setup = (new Setup(Init::getSettings()));
    }

    /**
     * Register hooks
     *
     * @return void
     */
    public function registerHooks()
    {
        add_action('transition_post_status', [$this, 'intercept_all_status_changes'], 10, 3);
    }

    /**
     * Every change made to a contract, intercept and validate
     *
     * @param string $new_status
     * @param string $old_status
     * @param object $post
     * @return void
     */
    public function intercept_all_status_changes($new_status, $old_status, $post)
    {
        $this->send_mails_on_publish($post->ID);
    }

    /**
     * Send an email if the criteria is met
     *
     * @param integer $id
     * @return void
     */
    public function send_mails_on_publish($id)
    {
        $current_user = wp_get_current_user();
        $dateformat =  $this->settings['dateFormat'];
        $time = current_time($dateformat . ' G:i:s', $gmt = 0);
        global $wpdb;
        if (is_admin() && function_exists('get_current_screen')) {
            $post = get_current_screen();
            if ($post->id == 'contract') {
                $str = tr_posts_field('audit_log');
                $contractstatus = get_post($id);
                if ($contractstatus->post_modified_gmt == $contractstatus->post_date_gmt) {
                    $emailtemplate = 'insert';
                    $str .= '<em>' . $time . '</em>, ' . __('Contract created by', 'onlinecontract') . ' <strong>' . $current_user->user_login . '</strong>';
                } else {
                    $emailtemplate = 'update';
                    $str .= '<br><em>' . $time . '</em>, ' . __('Contract updated by', 'onlinecontract') . ' <strong>' . $current_user->user_login . '</strong>';
                }
                $midname = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'audit_log'));
                $auditlog = [
                    'post_id' => $id,
                    'meta_key' => 'audit_log',
                    'meta_value' => $str
                ];

                if (!empty($midname)) {
                    $meta_idname = $midname[0]->meta_id;

                    if ($meta_idname != NULL) {
                        tr_query()->table('wp_postmeta')
                            ->setIdColumn('meta_id')
                            ->findById($meta_idname)
                            ->update($auditlog);
                    } else {
                        tr_query()->table('wp_postmeta')
                            ->setIdColumn('meta_id')
                            ->create($auditlog);
                    }
                } else {
                    tr_query()->table('wp_postmeta')
                        ->setIdColumn('meta_id')
                        ->create($auditlog);
                }
                if (tr_posts_field('send_email_to_client_on_update?') == 1) {
                    if ($emailtemplate != 'update' || $this->settings['emailSubject'] == NULL) {
                        $subject = Frontend::formatTemplate($this->settings['emailSubject']);
                        $convertedbody = Frontend::formatTemplate($this->settings['emailContent']);
                        $convertedbody = str_replace('[contract-link]', get_the_permalink(), $convertedbody);
                        $body = $convertedbody;
                    } else {
                        $subject = Frontend::formatTemplate($this->settings['emailSubject']);
                        $convertedbody = Frontend::formatTemplate($this->settings['emailContent']);
                        $convertedbody = str_replace('[contract-link]', get_the_permalink(), $convertedbody);
                        $body = $convertedbody;
                    }
                    $emailshortcode = get_post_meta($id, 'client_email_shortcode', true);
                    if ($emailshortcode != '') {
                        $clientemail = get_post_meta($id, $emailshortcode, true);
                        $this->sendmail($clientemail, $subject, $body);
                    }
                }
            }
        }
    }

    /**
     * Used to send mail after if it processes throughout the plugin
     *
     * @param string $email
     * @param string $subject
     * @param string $body
     * @return void
     */
    public function sendmail($email, $subject, $body)
    {
        $headers = '';
        $headers .= 'From: ' . $this->settings['companyName'] . ' <' . strip_tags($this->settings['adminEmail']) . '>' . "\r\n";
        $headers .= 'Reply-To: ' . strip_tags($this->settings['adminEmail']) . "\r\n";
        $headers .= 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-Type: text/html; charset=UTF-8' . "\r\n";
        wp_mail($email, $subject, $body, $headers);
        wp_mail($this->settings['adminEmail'], $subject, $body, $headers);
    }
}
