<?php

use FDG\OnlineContract\Payments\Paypal;
use FDG\OnlineContract\Setup\Init;
use FDG\OnlineContract\Frontend\Frontend;
use FDG\OnlineContract\Setup\Parser;

$fontAwesome = Init::getSettings()['fontAwesome'];
$paymentShortcode = tr_posts_field('payment_option_shortcode');
$paymentNameShortcode = tr_posts_field('payment_item_name_shortcode');
$paypalOn = tr_options_field('fdg_payment_options.turn_off_paypal?');
?>
<?php include_once(ABSPATH . 'wp-admin/includes/plugin.php');
?>
<div>
	<?php
	if (is_plugin_active('wp-online-contract-pdf/online-contract-pdf.php')) {
		require_once WP_PLUGIN_DIR . '/wp-online-contract-pdf/online-contract-pdf.php';
		echo (new OC_PDF_Frontend())->getPDFButton(get_the_ID());
	}
	?>
	<button type="button" class="btn button printbtn">
		<?php echo ($fontAwesome == 1 ? '<em class="fa fa-print" aria-hidden="true"></em> ' : '');
		echo __('Print Contract', 'onlinecontract'); ?></button>
</div>
<?php if ($paymentShortcode != 'no' && $paymentShortcode != '') { ?>
	<div>
		<?php
		if ($paypalOn != 1 || $paypalOn == NULL) {
			echo Paypal::getPaypalButton($paymentShortcode, $paymentNameShortcode);
		}
		?>
		<?php
		if (is_plugin_active('wp-online-contract-stripe-payments/online-contract-stripe-payments.php')) {
			$stripeOn = tr_options_field('fdg_payment_options.turn_off_stripe?');
			if ($stripeOn != 1 || $stripeOn == NULL) {
				require_once WP_PLUGIN_DIR . '/wp-online-contract-stripe-payments/online-contract-stripe-payments.php';
				$frontend = new Frontend();
				$parser = new Parser();
				$settings = (new Init)->getSettings();
				echo (new OC_Stripe_Frontend())->getStripeButton($settings, $frontend, $parser, $paymentShortcode, $paymentNameShortcode);
			}
		}
		?>
	</div>
<?php } ?>