<?php

use FDG\OnlineContract\Frontend\Frontend;

$contracttemplate = tr_posts_field('contract_template');
$contracttemplates = tr_options_field('fdg_template_options.contract_templates');
if (isset($contracttemplates)) {
	foreach ($contracttemplates as $template) {
		if ($template['contract_content'] != '') {
			if ($template['contract_name'] == $contracttemplate) {
				$formattedtemplate = do_shortcode(Frontend::formatTemplate($template['contract_content']));
			}
		} else {
			echo '<h3 style="text-align:center;">' . __('You did not add any content to your contract template. Add your content and shortcodes in order to see your contract here.', 'onlinecontract') . '</h3>';
		}
	}
} else {
	echo '<h3 style="text-align:center;">' . __('You have not created any contract templates. In order to see your contract, you must create and assign a contract template to this contract.', 'onlinecontract') . '</h3>';
}
