<?php

use FDG\OnlineContract\Admin\Admin;
use FDG\OnlineContract\Setup\Init;

$printName = tr_posts_field('force_use_to_print_name?');
$fontAwesome = Init::getSettings()['fontAwesome'];
$preparedFields = tr_posts_field('force_use_to_use_prepared_fields?');
?>
<?php if ($preparedFields == 1 && $preparedFields != NULL) { ?>
  <?php
  echo '<div class="typerocket-container">';
  $form = tr_form();
  echo $form->open(array('id' => 'printfields'), false);
  foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
    if (!isset($shortcode['function_only']) && isset($shortcode['prepared_field'])) {
      echo Admin::convertShortcodeAdmin($form, $shortcode);
      echo '<br>';
    }
  }
  echo '</div>';
  ?>
<?php } ?>
<?php if ($printName == 1 && $printName != NULL) { ?>
  <p class="printname">
    <input type="text" id="printname" name="printname" class="printnamebox">
    <br>
    <small><?php echo __('Print Name', 'onlinecontract'); ?></small>
  </p>
<?php } ?>
<div id="signature-pad" class="signature-pad">
  <div class="signature-pad--body">
    <canvas></canvas>
  </div>
  <div class="signature-pad--footer">
    <div class="signature-pad--actions">
      <div>
        <button type="button" class="btn button clear" data-action="clear">
          <?php echo ($fontAwesome == 1 ? '<em class="fa fa-times" aria-hidden="true"></em> ' : '');
          echo __('Clear', 'onlinecontract'); ?></button>
      </div>
      <div>
        <span class="spinner_fdg"></span><button type="button" class="btn button save" data-action="save-svg">
          <?php echo ($fontAwesome == 1 ? '<em class="fa fa-check" aria-hidden="true"></em> ' : '');
          echo __('Save Signature', 'onlinecontract'); ?></button>
      </div>
    </div>
  </div>
</div>
<div id="signature"></div>