<?php

namespace App\Controllers;

use TypeRocket\Controllers\Controller;
use Spipu\Html2Pdf\Html2Pdf;
use WP_Query;
use FDG\OnlineContract\Frontend\Frontend;
use FDG\OnlineContract\Setup\Setup;
use FDG\OnlineContract\Setup\Init;
use FDG\OnlineContract\Setup\Sendmail;

require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';

use WP_Filesystem_Base;

class ContractController extends Controller
{
	public function __construct()
	{
		$this->settings = Init::getSettings();
		$this->setup = (new Setup(Init::getSettings()));
	}

	public function removesignature($id)
	{
		global $wpdb;
		$prefix = $wpdb->prefix;
		$meta_id = $this->get_mid_by_key($id, 'signature');
		$data = [
			'post_id' => $id,
			'meta_key' => 'signature',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_id)
			->update($data);

		$meta_idprinted_name = $this->get_mid_by_key($id, 'printed_name');
		$dataprinted_name = [
			'post_id' => $id,
			'meta_key' => 'printed_name',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idprinted_name)
			->update($dataprinted_name);

		$meta_idip_address = $this->get_mid_by_key($id, 'ip_address');
		$dataip_address = [
			'post_id' => $id,
			'meta_key' => 'ip_address',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idip_address)
			->update($dataip_address);

		$meta_idgenerated_sign_date = $this->get_mid_by_key($id, 'generated_sign_date');
		$datagenerated_sign_date = [
			'post_id' => $id,
			'meta_key' => 'generated_sign_date',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idgenerated_sign_date)
			->update($datagenerated_sign_date);

		$current_user = wp_get_current_user();
		$dateformat = tr_options_field('fdg_plugin_options.date_format');
		$time = current_time($dateformat . ' G:i:s', $gmt = 0);
		$str = get_post_meta($id, 'audit_log', true);
		$str .= '<br><em>' . $time . '</em>, ' . __('Signature removed by', 'onlinecontract') . ' <strong>' . $current_user->user_login . '</strong>';
		$meta_idname = $this->get_mid_by_key($id, 'audit_log');
		$auditlog = [
			'post_id' => $id,
			'meta_key' => 'audit_log',
			'meta_value' => $str
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idname)
			->update($auditlog);
		$subject = __('A Signed Contract Has Had The Signature Removed', 'onlinecontract');
		$body = __('An administrator has reopened a contract by removing a signature. You can view this contract here', 'onlinecontract') . ':<br><a href="' . get_the_permalink($id) . '">' . get_the_permalink($id) . '</a>';
		if (tr_options_field('fdg_plugin_options.administration_email') != NULL) {
			$adminemail = tr_options_field('fdg_plugin_options.administration_email');
		} else {
			$adminemail = bloginfo('admin_email');
		}
		$emailshortcode = get_post_meta($id, 'client_email_shortcode', true);
		if ($emailshortcode != '') {
			$clientemail = get_post_meta($id, $emailshortcode, true);
			(new Sendmail())->sendmail($clientemail, $subject, $body);
		}
		(new Sendmail())->sendmail($adminemail, $subject, $body);
		header('Location: ' . get_admin_url() . 'post.php?post=' . $id . '&action=edit');
		exit;
	}

	public function emaillist($email)
	{
		get_header();
		if (!isset($email)) {
			$current_user = wp_get_current_user();
			$email = $current_user->user_email;
		}

		$emailshortcode = tr_options_field('fdg_plugin_options.client_email_shortcode');

		$emailshortcode = Frontend::convertSingleShortcode('[' . $emailshortcode . ']');

		$args = array(
			'post_type' => 'contract',
			'meta_query' => array(
				array(
					'key' => $emailshortcode,
					'value' => $email,
					'compare' => '=',
				)
			)
		);
		$query = new WP_Query($args);
		echo '<div style="width:100%;">';
		echo '<h2>Client Contracts</h2>';
		if ($query->have_posts()) :
			echo '<ul class="contractlistitem">';
			while ($query->have_posts()) : $query->the_post();
				echo '<li>' . get_the_title() . '
					<ul class="contractlistiteminner">';
				if (tr_posts_field('remove_signature_box?') != 1) {
					if (tr_posts_field('signature') == '-') {
						echo '<li>Status: Unsigned</li>';
					} else {
						echo '<li>Status: Signed</li>';
					}
				} else {
					echo '<li>Status: Cannot Sign Online</li>';
				}
				if (tr_posts_field('signature') == '-') {
					echo '<li><a href="' . get_the_permalink() . '" target="_blank">' . __('View Contract') . '</a></li>';
				} else {
					echo '<li><a href="' . get_the_permalink() . '#signed" target="_blank">' . __('Print Contract') . '</a></li>';
				}
				echo '</ul>
				</li>';
			endwhile;
			echo '</ul>';
			wp_reset_postdata();
		else :
			echo '<p>' . __('The email address you are using does not have any contracts associated with it.') . '</p>';
		endif;
		echo '</div>';
		get_footer();
		exit;
	}

	public function create()
	{
		if (tr_options_field('fdg_plugin_options.enable_recaptcha') == 1) {
			if (isset($_POST['g-recaptcha-response'])) {
				$captcha = $_POST['g-recaptcha-response'];
			}
			if (!$captcha) {
				echo '<p style="text-align:center;">Please check the the captcha form. Your input was incorrect.</p>';
				exit;
			}
			$secretKey = tr_options_field('fdg_plugin_options.recaptcha_secret_key');
			$ip = $_SERVER['REMOTE_ADDR'];
			$url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secretKey) .  '&response=' . urlencode($captcha);
			$response = file_get_contents($url);
			$responseKeys = json_decode($response, true);
			if ($responseKeys["success"]) {
				$this->createcontent();
			}
		} else {
			$this->createcontent();
		}
		$this->createcontent();
	}

	public function createcontent()
	{
		global $wpdb;
		$prefix = $wpdb->prefix;
		$randnumber = rand(10000, 20000) . date('ymdGHis');
		$post    = array(
			'post_title' => __('Client Initiated') . ' ' . $randnumber,
			'post_name' => $randnumber,
			'post_status' => 'publish',
			'post_type' => 'contract',
			'post_author' => 1
		);
		$id = wp_insert_post($post);

		$midname = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'printed_name'));
		$meta_idname = $midname[0]->meta_id;

		$dataname = [
			'post_id' => $id,
			'meta_key' => 'printed_name',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idname)
			->update($dataname);

		$mid = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'signature'));
		$meta_id = $mid[0]->meta_id;

		$data = [
			'post_id' => $id,
			'meta_key' => 'signature',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_id)
			->update($data);

		$midipaddress = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'ip_address'));
		$meta_idipaddress = $midipaddress[0]->meta_id;
		$dataipaddress = [
			'post_id' => $id,
			'meta_key' => 'ip_address',
			'meta_value' => '-'
		];

		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idipaddress)
			->update($dataipaddress);

		$midtimestamp = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'generated_sign_date'));
		$meta_idtimestamp = $midtimestamp[0]->meta_id;
		$datatimestamp = [
			'post_id' => $id,
			'meta_key' => 'generated_sign_date',
			'meta_value' => '-'
		];


		tr_query()->table($prefix . 'postmeta')
			->setIdColumn('meta_id')
			->findById($meta_idtimestamp)
			->update($datatimestamp);

		$redirect = tr_options_field('fdg_plugin_options.auto_redirect_initiated_contracts');
		if ($_POST['tr']['contract_template'] != '-') {
			$redirectcontracttemplate = $_POST['tr']['contract_template'];
		} else {
			$redirectcontracttemplate = tr_options_field('fdg_plugin_options.default_contract_template');
		}
		if ($redirect == 1 && tr_options_field('fdg_plugin_options.auto_redirect_initiated_contracts') != NULL) {
			$midcontracttemplate = $wpdb->get_results($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'contract_template'));
			$meta_idcontracttemplate = $midcontracttemplate[0]->meta_id;
			$datacontracttemplate = [
				'post_id' => $id,
				'meta_key' => 'contract_template',
				'meta_value' => $redirectcontracttemplate
			];

			tr_query()->table($prefix . 'postmeta')
				->setIdColumn('meta_id')
				->findById($meta_idcontracttemplate)
				->update($datacontracttemplate);
			$subject = __('A New Contract Has Been Created By A User', 'onlinecontract');
			$body = __('A user has created a new contract. They have not signed it yet, but you will receive a notification when they do. You can view it here', 'onlinecontract') . ':<br><a href="' . get_the_permalink($id) . '">' . get_the_permalink($id) . '</a>';
			if (tr_options_field('fdg_plugin_options.administration_email') != NULL) {
				$adminemail = tr_options_field('fdg_plugin_options.administration_email');
			} else {
				$adminemail = bloginfo('admin_email');
			}
			if (tr_options_field('fdg_plugin_options.administration_email') != NULL) {
				$adminemail = tr_options_field('fdg_plugin_options.administration_email');
			} else {
				$adminemail = bloginfo('admin_email');
			}
			(new Sendmail())->sendmail($adminemail, $subject, $body);
			if (tr_options_field('fdg_plugin_options.autosigningredirect') != NULL) {
				setcookie("autosigningredirect", tr_options_field('fdg_plugin_options.autosigningredirect'), time() + 3600, '/');
			}
			header('Location: ' . get_the_permalink($id));
		} else {
			$subject = __('A New Contract Has Been Created By A User', 'onlinecontract');
			$body = __('A user has created a new contract. It is pending review, so you will need to publish it before they can sign. You can view it here', 'onlinecontract') . ':<br><a href="' . get_the_permalink($id) . '">' . get_the_permalink($id) . '</a>';
			if (tr_options_field('fdg_plugin_options.administration_email') != NULL) {
				$adminemail = tr_options_field('fdg_plugin_options.administration_email');
			} else {
				$adminemail = bloginfo('admin_email');
			}
			(new Sendmail())->sendmail($adminemail, $subject, $body);
			get_header('contract');
			echo '<div style="text-align:center; width:100%;">';
			echo '<h1>Thanks!</h1>';
			echo '<p>' . tr_options_field('fdg_plugin_options.response_if_not_auto_redirect?') . '</p>';
			echo '<p><a href="' . site_url() . '" class="btn button">' . __('Back to Website') . '</a></p>';
			echo '</div>';
			get_footer('contract');
		}
		exit;
	}

	public function validatekey()
	{
		$purchasecode = $_POST['tr']['fdg_plugin_options_purchase']['purchase_code'];
		update_option('fdg_plugin_options_purchase', serialize(array('purchase_code' => $purchasecode)));
		$this->setup->envatoApiResultsNew();
		$this->setup->envatoApiResults();
		header('Location: ' . get_admin_url() . 'edit.php?post_type=contract&page=purchase');
		exit();
	}

	public function get_mid_by_key($post_id, $meta_key)
	{
		global $wpdb;
		$mid = $wpdb->get_var($wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $post_id, $meta_key));
		if ($mid != '') {
			return (int)$mid;
		}
		return false;
	}
}
