<?php

use FDG\OnlineContract\Setup\Init;

$this->settings = (new Init())->getSettings();

if (!function_exists('add_action')) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

// Setup Form
$form = tr_form()->useJson()->setGroup('fdg_plugin_options');
?>
<h1><?php _e('Settings', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php

    echo $form->open();
    $setup = function () use ($form) {
        $phpversion = phpversion();
        if (version_compare(phpversion(), '7.2', '<')) {
            echo '<div style="background-color:red; color:#fff; padding:15px;"><span class="dashicons dashicons-warning"></span><strong>' . __('Your Version of PHP Is Not Compatible', 'onlinecontract') . '</strong><br>' . __('You are currently not using a secure version of PHP and our plugin will not work properly without updating to at least PHP 7.2. Please update your server to properly use this plugin.', 'onlinecontract') . '</div>';
        }
        /*
        echo $form->checkbox('Debug Plugin')->setLabel(__('Debug Plugin', 'onlinecontract'));
        echo '<small>' . __('Turn on debugging to troubleshooting that may help you resolve your issue.', 'onlinecontract') . '</small><br><br>';
        */
        echo $form->text('Contract Permalink')->setDefault('contract')->setLabel(__('Contract Permalink', 'onlinecontract'));
        echo '<small>' . __('You can modify your contract permalink here. Once this is changed, you may have to resave your permalinks', 'onlinecontract') . ': <a href="options-permalink.php" target="_blank">' . __('Save Permalinks', 'onlinecontract') . '</a></small><br><br>';
        echo $form->text('Your Company Name')->setLabel(__('Your Company Name', 'onlinecontract'));
        echo '<small>' . __('Enter the name of your company that will display on the contract.', 'onlinecontract') . '</small><br><br>';
        echo $form->text('Administration Email')->setLabel(__('Administration Email', 'onlinecontract'));
        echo '<small>' . __('Enter the email address you want status emails to be directed to.', 'onlinecontract') . '</small><br><br>';
        echo $form->text('Decimal Round')->setDefault('2')->setLabel(__('Decimal Round', 'onlinecontract'));
        echo '<small>' . __('Enter the number of places to round all decimals', 'onlinecontract') . '</small><br><br>';
        echo $form->text('Currency Symbol')->setDefault('$')->setLabel(__('Currency Symbol', 'onlinecontract'));
        echo '<small>' . __('Enter your currency symbol', 'onlinecontract') . ' (ex: $ or €, etc)</small><br><br>';
        echo $form->text('Currency Type')->setDefault('USD')->setLabel(__('Currency Type', 'onlinecontract'));
        echo '<small>' . __('Enter your currency type. A complete list can be found at the following link', 'onlinecontract') . ':<br><a href="https://developer.paypal.com/docs/api/reference/currency-codes/" target="_blank">https://developer.paypal.com/docs/api/reference/currency-codes/</a></small><br><br>';
        echo $form->text('Date Format')->setDefault('d/m/Y')->setLabel(__('Date Format', 'onlinecontract'));
        echo '<small>' . __('Enter the format in which you want to see dates. You can find more information about date formats using the following URL', 'onlinecontract') . ':<br><a href="http://php.net/manual/en/function.date.php" target="_blank">http://php.net/manual/en/function.date.php</a></small><br><br>';
        echo $form->text('Datepicker Format')->setDefault('d/m/yy')->setLabel(__('Datepicker Format', 'onlinecontract'));
        echo '<small>' . __('Enter the format in which you want to enter a date. You can find more information about date formats using the following URL', 'onlinecontract') . ':<br><a href="https://api.jqueryui.com/datepicker/#utility-formatDate" target="_blank">https://api.jqueryui.com/datepicker/#utility-formatDate</a>. <span style="color:red;">' . __('This is different than the Date Format.', 'onlinecontract') . '</span></small><br><br>';
        if (tr_options_field('fdg_shortcodes.contract_shortcodes') != NULL) {
            foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {

                $shortcodes[$shortcode['label']] = str_replace(array('[', ']'), '', $shortcode['shortcode']);
            }
            echo $form->select('Client Email Shortcode')->setOptions($shortcodes)->setLabel(__('Client Email Shortcode', 'onlinecontract'));
            echo '<small>' . __('This will be used to display their contract when you use the front end to show all clients contract based on their email.', 'onlincontract') . '</small><br><br>';
            echo '<br>';
        }
        echo '<div style="background-color:#f8f8f8; padding:10px; border:1px solid #c0c0c0; margin-bottom:20px;">';
        echo $form->checkbox('Auto Redirect Initiated Contracts')->setLabel(__('Auto Redirect Initiated Contracts', 'onlinecontract'));
        echo '<small>' . __('If you allow clients to create their own contracts, do you want to redirect them to their contract? Keep in mind that if you have values that the client cannot fill out, they will be able to sign the contract without those values which could result in the contract being incorrect. If you do not use this, you will have to manually approve all client initiated contracts.', 'onlinecontract') . ' <span style="color:red;">' . __('Use at your own discretion.', 'onlinecontract') . '</span></small><br><br>';
        $options[''] = '';
        if (tr_options_field('fdg_template_options.contract_templates') != NULL) {
            foreach (tr_options_field('fdg_template_options.contract_templates') as $template) {
                $options[$template['contract_name']] = $template['contract_name'];
            }
            echo $form->select('Default Contract Template')->setOptions($options)->setLabel(__('Default Contract Template', 'onlinecontract'));
            echo '<small>' . __('If you auto redirect initiated contracts, you must select a default template to use. If one is not selected, then they will not see any contracts, just a blank page. This template <strong>MUST NOT</strong> use functional shortcodes as the information will not be populated by the client and will result in an error. This section is more for TOS agreements, not contracts. All shortcodes they complete should be present on the contract or it will show a blank screen. If you are not allowing auto redirect then skip this step. <span style="color:red;">Use at your own discretion.', 'onlinecontract') . '</span></small><br><br>';
        }
        echo $form->textarea('Response if not auto redirect?')->setDefault('Your contract has been submitted. Once approved, you will receive a notification to sign.')->setLabel(__('Response if not auto redirect?', 'onlinecontract'));
        echo '<small>' . __('If you do not auto redirect the contract, you can display a message to the user saying their contract was received.', 'onlinecontract') . '</small><br><br>';
        echo $form->text('autosigningredirect')->setLabel(__('Upon signing, redirect these users to this URL', 'onlinecontract'));
        echo '</div>';
        echo $form->checkbox('Use FontAwesome Icons?')->setLabel(__('Use FontAwesome Icons?', 'onlinecontract'));
        echo '<small>' . __('Spruce up the buttons by adding FontAwesome icons where they are needed.', 'onlinecontract') . '</small><br><br>';
        echo $form->editor('Signature Message')->setDefault('Please sign using a stylus, your mouse, or your finger below to authorize this contract. By electronically signing this document, you agree to the terms established above.<br>After the document is signed, you can proceed to print it or save it as a PDF.')->setLabel(__('Signature Message', 'onlinecontract'));
        echo '<small>' . __('Enter the bold message to display above where the client will sign the contract.', 'onlinecontract') . '</small>';
        include(ONLINE_CONTRACT_DIR . 'gethelp.php');
        echo '<br>';
        echo '<p style="text-align:right">' . __('Version', 'onlinecontract') . ' ' . ONLINE_CONTRACT_VERSION_NUMBER . '</p>';
    };

    $recaptcha = function () use ($form) {
        echo '<p>' . __('Sign up for a Google Recaptcha V2 account for FREE.', 'onlinecontract') . ':<br><a href="https://www.google.com/recaptcha/admin/create" target="_blank">https://www.google.com/recaptcha/admin/create</a></p>';
        echo '<p>' . __('Our plugin uses version 2 of the Google Recaptcha plugin. In order to use this section on your client facing form, you will need to sign up for an account and generate the keys for the domain you wish to use the Recaptcha on.', 'onlinecontract') . '</p>';
        echo $form->text('Recaptcha Site Key')->setLabel(__('Recaptcha Site Key', 'onlinecontract'));
        echo $form->text('Recaptcha Secret Key')->setLabel(__('Recaptcha Secret Key', 'onlinecontract'));
        echo $form->checkbox('Enable Recaptcha')->setLabel(__('Enable Recaptcha', 'onlinecontract'));
    };


    $advanced = function () use ($form) {
        $advancedfdg = '
        <p>' . __('Want to spice up our plugin with user client initiation or user accounts? Use the following shortcodes to add items to your website with ease. You can customize these shortcodes more on your shortcodes page if required.', 'onlinecontract') . '</p>
        <hr>
        <h2>' . __('Break Pages When Printed', 'onlinecontract') . '</h2>
        <p>' . __('If you require a page break in your contract template, you can use the following shortcode where that break is needed. This will create a page break in the PDF view of the contract', 'onlinecontract') . ':</p> <strong><span style="color: white; background-color: green; border-radius: 3px; padding: 2px 5px; font-size:14px;">[onlinecontractpagebreak]</span></strong>
        <p></p>
        <hr>
        <h2>' . __('Allow Clients to Initiate A Contract', 'onlinecontract') . '</h2>
        <p>' . __('If you would like to give your clients the opportunity to initiate a contract, you can easily add the following shortcode to any page or theme file', 'onlinecontract') . ':
            <br> <strong><span style="color: white; background-color: green; border-radius: 3px; padding: 2px 5px; font-size:14px;">[clientadd]</span></strong></p>
        <p>' . __('This will add a short form that can be styled by you that will allow a client to create a pending contract and send your administrative contact an email notification.', 'onlinecontract') . '</p>
        <p>' . __('You can also add the template variable to only show form fields listed for a specific template by adding', 'onlinecontract') . ' <strong>template="Template Title"</strong> (ex: [clientadd template="Website Design"])' . '</p>
        <hr>
        <h2>' . __('Show All Contracts Based on Email', 'onlinecontract') . '</h2>
            <em>' . site_url() . '/' . $this->settings['slug'] . '/contractlist/test@example.com</em>
            <p>' . __('Just replace the email with their email address. If they have an account with your website, do not include the email in the url. Our plugin will use the email associated with their account.', 'onlinecontract') . '</p>
            <p><strong>' . __('Alternative Method for User Accounts', 'onlinecontract') . '</strong></p>
            <p>' . __('If you allow your clients to have accounts within your WordPress website, you can add the following shortcode to a front-facing page to a front-facing page to display a list of contracts that are assigned to their email address. In order for this to work properly, you must select the shortcode used for client emails by going to Plugin Setup > Client Email Shortcode:', 'onlinecontract') . '<br> <strong><span style="color: white; background-color: green; border-radius: 3px; padding: 2px 5px; font-size:14px;">[emaillist]</span></strong></p>
            <p>' . __('You can also customize what types of contract are displayed by adding', 'onlinecontract') . ' <strong>type="your-category-slug"</strong> (ex: [emaillist type="test-type"])</strong>.</p>
        <p>' . __('You can style this list using the following class.', 'onlinecontract') . ':
            <br><em>.contractlistitem</em>
            <br><em>.contractlistiteminner</em></p>
        <p style="text-align:right">' . __('Version', 'onlinecontract') . ' ' . ONLINE_CONTRACT_VERSION_NUMBER . '</p>
        ';
        echo wp_kses($advancedfdg, 'post');
    };

    $removeheader = function () use ($form) {
        $removeheaderfdg = '
        <p>' . __('If you do not want to use your theme header and footer with the contracts, we have it setup to display a white page with nothing but the contract. We cannot do this from the plugin, but have created a way to use your theme for this.', 'onlinecontract') . '</p>
        <p>' . __('If you wish to remove the header and footer create the following files in either your primary or child theme', 'onlinecontract') . ':</p>
        <hr>
        <p><strong>header-contract.php</strong></p>
        <p>' . __('Add the following code to this file', 'onlinecontract') . ':<br>
<pre>
&lt;!DOCTYPE html&gt;
&lt;html class="no-js no-svg"&gt;
&lt;head&gt;
&lt;meta charset="&lt;?php bloginfo( \'charset\' ); ?&gt;"&gt;
&lt;meta name="viewport" content="width=device-width, initial-scale=1"&gt;
&lt;link rel="profile" href="http://gmpg.org/xfn/11"&gt;
&lt;?php wp_head(); ?&gt;
&lt;/head&gt;
&lt;body&gt;
</pre>
        </p>
        <hr>
        <p><strong>footer-contract.php</strong></p>
        <p>' . __('Add the following code to this file.', 'onlinecontract') . ':<br>
<pre>
&lt;?php wp_footer(); ?&gt;
&lt;/body&gt;
&lt;/html&gt;
</pre>
        </p>
        ';
        echo wp_kses($removeheaderfdg, 'post');
    };

    $about = function () use ($form) {
        include(ONLINE_CONTRACT_DIR . 'about.php');
    };

    $save = $form->submit(__('Save', 'onlinecontract'));

    // Layout
    tr_tabs()->setSidebar($save)
        ->addTab(__('Plugin Setup', 'onlinecontract'), $setup)
        ->addTab(__('Google Recaptcha', 'onlinecontract'), $recaptcha)
        ->addTab(__('Remove Theme Files', 'onlinecontract'), $removeheader)
        ->addTab(__('Advanced Shortcodes', 'onlinecontract'), $advanced)
        ->addTab(__('About', 'onlinecontract'), $about)
        ->render('box');
    echo $form->close();
    ?>
</div>