<?php

namespace FDG\OnlineContract\TypeRocket\Init;

use FDG\OnlineContract\Setup\Setup;
use FDG\OnlineContract\Setup\Init;

require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';

use WP_Filesystem_Base;

class ThemeOptionsPluginOC
{

    private $name = 'fdg_plugin_options';

    public function __construct()
    {
        $this->settings = Init::getSettings();
        $this->setup = (new Setup(Init::getSettings()));
        if (!function_exists('add_action')) {
            echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
            exit;
        }
    }

    public function getName()
    {
        return $this->name;
    }

    public function setup()
    {
        $this->name = apply_filters('tr_theme_options_name', $this->name);
        add_action('admin_menu', [$this, 'menu']);
        add_action('wp_before_admin_bar_render', [$this, 'admin_bar_menu'], 100);
        add_filter('tr_model', [$this, 'fillable'], 9999999999);

        // process import and export
        if (
            empty($_POST) &&
            !empty($_GET['theme-options']) &&
            !empty($_GET) &&
            $_GET['theme-options'] == 'export'
        ) {
            $this->json_export();
        } elseif (!empty($_POST['tr_theme_options_import'])) {
            $files = $_FILES;
            $this->json_import($files);
        }
    }

    public function fillable($model)
    {

        if ($model instanceof \TypeRocket\Models\WPOption) {
            $fillable = $model->getFillableFields();

            if (!empty($fillable)) {
                $model->appendFillableField($this->name);
            }
        }
    }

    public function menu()
    {
        if ($this->setup->validatePurchaseCode() == 1) {
            add_submenu_page('edit.php?post_type=contract', __('Settings', 'onlinecontract'), __('Settings', 'onlinecontract'), 'manage_options', 'contract-settings', [$this, 'page']);
            add_submenu_page('edit.php?post_type=contract', __('Shortcodes', 'onlinecontract'), __('Shortcodes', 'onlinecontract'), 'manage_options', 'contract-shortcodes', [$this, 'shortcodes']);
            add_submenu_page('edit.php?post_type=contract', __('Templates', 'onlinecontract'), __('Templates', 'onlinecontract'), 'manage_options', 'contract-templates', [$this, 'templates']);
            add_submenu_page('edit.php?post_type=contract', __('Payment Options', 'onlinecontract'), __('Payment Options', 'onlinecontract'), 'manage_options', 'payment-options', [$this, 'paymentoptions']);
        }
        add_submenu_page('edit.php?post_type=contract', __('Purchase Code', 'onlinecontract'), __('Purchase Code', 'onlinecontract'), 'manage_options', 'purchase', [$this, 'purchase']);
    }

    public function page()
    {
        do_action('tr_theme_options_page', $this);
        echo '<div class="wrap">';
        $file = apply_filters('tr_theme_options_page', __DIR__ . '/admin.php');
        if (file_exists($file)) {
            /** @noinspection PhpIncludeInspection */
            include($file);
        }
        echo '</div>';
    }

    public function shortcodes()
    {
        do_action('tr_theme_options_page', $this);
        echo '<div class="wrap">';
        $file = apply_filters('tr_theme_options_page', __DIR__ . '/shortcodes.php');
        if (file_exists($file)) {
            /** @noinspection PhpIncludeInspection */
            include($file);
        }
        echo '</div>';
    }

    public function templates()
    {
        do_action('tr_theme_options_page', $this);
        echo '<div class="wrap">';
        $file = apply_filters('tr_theme_options_page', __DIR__ . '/templates.php');
        if (file_exists($file)) {
            /** @noinspection PhpIncludeInspection */
            include($file);
        }
        echo '</div>';
    }

    public function paymentoptions()
    {
        do_action('tr_theme_options_page', $this);
        echo '<div class="wrap">';
        $file = apply_filters('tr_theme_options_page', __DIR__ . '/payment-options.php');
        if (file_exists($file)) {
            /** @noinspection PhpIncludeInspection */
            include($file);
        }
        echo '</div>';
    }

    public function purchase()
    {
        do_action('tr_theme_options_page', $this);
        echo '<div class="wrap">';
        $file = apply_filters('tr_theme_options_page', __DIR__ . '/purchase.php');
        if (file_exists($file)) {
            /** @noinspection PhpIncludeInspection */
            include($file);
        }
        echo '</div>';
    }

    public function add_sub_menu($name, $link, $root_menu, $id, $meta = false)
    {
        /** @var \WP_Admin_Bar $wp_admin_bar */
        global $wp_admin_bar;
        if (!current_user_can('manage_options') || !is_admin_bar_showing()) {
            return;
        }

        $wp_admin_bar->add_menu([
            'parent' => $root_menu,
            'id'     => $id,
            'title'  => $name,
            'href'   => $link,
            'meta'   => $meta
        ]);
    }

    public function admin_bar_menu()
    {
        $this->add_sub_menu(
            "Theme Options",
            admin_url() . 'themes.php?page=theme_options',
            "site-name",
            "tr-theme-options"
        );
    }

    public function json_export()
    {
        /** @var \wpdb $wpdb */
        global $wpdb;
        $name = esc_sql($this->name);

        $sql     = "SELECT * FROM {$wpdb->options} WHERE option_name = '{$name}';";
        $arr     = [];
        $options = $wpdb->get_results($sql);
        if (!$options) {
            $arr = ['error' => 'no results. check filters. AND?'];
        }
        foreach ($options as $option) {
            $arr[$option->option_name] = unserialize($option->option_value);
        }

        $json = json_encode($arr);

        $uploads = wp_upload_dir();

        $fp = fopen($uploads['basedir'] . '/typerocket-export-theme-options.json', 'w');
        fwrite($fp, $json);
        fclose($fp);

        wp_redirect($uploads['baseurl'] . '/typerocket-export-theme-options.json');
    }

    public function json_import($files)
    {

        if (!empty($files['fileToUpload']) && $files['fileToUpload']['type'] == 'application/json') {
            $data = json_decode(file_get_contents($files['fileToUpload']['tmp_name']), true);

            if (is_array($data)) {
                $theme_options = $data[$this->name];
                update_option($this->name, serialize($theme_options));
            }
        }
    }
}

add_action('typerocket_loaded', [new ThemeOptionsPluginOC(), 'setup']);
