<?php
if (!function_exists('add_action')) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

$form = tr_form()->useUrl('post', '/validatecontractkey')->setGroup('fdg_plugin_options_purchase');
//$form = tr_form()->useJson()->setGroup( 'fdg_plugin_options_purchase' );

?>

<h1><?php _e('Purchase Code', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php
    echo $form->open();
    $auth = function () use ($form) {
        $confirm = '';
        if (is_plugin_active('wp-online-contract-multisite/online-contract-multisite.php')) {
            require_once WP_PLUGIN_DIR . '/wp-online-contract-multisite/online-contract-multisite.php';
            $multi_setup = ((new WPOC_Multi_Admin())->setup());
            $confirm = ((new WPOC_Multi_Admin())->confirm());
        }
        if (is_multisite()) {
            if (!isset($multi_setup)) {
                echo '<br><div style="background-color:#e82c2c; padding:15px; color:#fff; font-weight:bold;">' . __('It appears you are trying to use our plugin on a multisite installation. In order for our plugin to work properly with multisites, you need to download our multisite addon.', 'onlinecontract') . '</div><br>';
            }
        }

        $version = explode('.', PHP_VERSION);
        if ($version[0] < 7) {
            echo '<br><div style="background-color:#e82c2c; padding:15px; color:#fff; font-weight:bold;">' . __('You are not using PHP 7. Our plugin will not work for your current version. Please upgrade your hosting server to PHP7+ to use our plugin as intended. This is due to WordPress requirements and insecurities patched in PHP7. If you see an error with ??, this is the reason.', 'onlinecontract') . '</div><br>';
        } else {
            if ($version[1] < 4) {
                echo '<br><div style="background-color:#e82c2c; padding:15px; color:#fff; font-weight:bold;">' . __('You are currently using PHP7, but our plugin works better with at least PHP7.4. If possible, please upgrade your server to be able to use our plugin as intended. Your installation should work, however, we developed our plugin to utilize newer code so you may experience issues in the future.', 'onlinecontract') . '</div><br>';
            }
        }
        echo '<p>' . __('In order to use our plugin you must enter your purchase code below. Failure to do this or if you are using a hacked version of our plugin could result in a permanent disable of your installation.', 'onlinecontract') . '</p>';
        if (is_multisite()) {
            if (!isset($multi_setup)) {
                echo '<br><div style="background-color:#e82c2c; padding:15px; color:#fff; font-weight:bold;">' . __('You cannot add your purchase code for this plugin as it is now. You either need to install it on a single site or purchase our Multisite addon to see your settings and add your purchase code.', 'onlinecontract') . '</div><br>';
            } else {
                echo $form->text('Purchase Code')->setLabel(__('Purchase Code', 'onlinecontract'))->setDefault($this->setup->purchaseCode);
                if ($this->setup->validatePurchaseCode() == 1) {
                    echo '<small style="color:green;">' . __('You purchase code is valid', 'onlinecontract') . '</small>';
                } else {
                    echo '<small style="color:red;">' . __('You purchase code is invalid', 'onlinecontract') . '</small>';
                }
                if (is_multisite()) {
                    echo $confirm;
                }
                echo $form->submit(__('Update Key', 'onlinecontract'));
            }
        } else {
            echo $form->text('Purchase Code')->setLabel(__('Purchase Code', 'onlinecontract'))->setDefault($this->setup->purchaseCode);
            if ($this->setup->validatePurchaseCode() == 1) {
                echo '<small style="color:green;">' . __('You purchase code is valid', 'onlinecontract') . '</small>';
            } else {
                echo '<small style="color:red;">' . __('You purchase code is invalid', 'onlinecontract') . '</small>';
            }
            if (is_multisite()) {
                echo $confirm;
            }
            echo $form->submit(__('Update Key', 'onlinecontract'));
        }
        echo '<p>' . __('If you do not know where your purchase code is? Take a look at our instructions below to retrieve it from CodeCanyon.', 'onlinecontract') . '</p>
        <ul>
            <li>' . __('Log into your Envato Market account.', 'onlinecontract') . '</li>
            <li>' . __('Hover the mouse over your username at the top of the screen.', 'onlinecontract') . '</li>
            <li>' . __('Click "Downloads" from the drop down menu.', 'onlinecontract') . '</li>
            <li>' . __('Click "License certificate & purchase code" (available as PDF or text file).', 'onlinecontract') . '</li>
        </ul>
        <p>' . __('You can read these instructions as well as see a video and a sample of the license file at the following URL', 'onlinecontract') . ':
        <br>
        <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Can-I-Find-my-Purchase-Code" target="_blank">https://help.market.envato.com/hc/en-us/articles/202822600-Where-Can-I-Find-my-Purchase-Code</a>';
        include(ONLINE_CONTRACT_DIR . 'gethelp.php');
        echo '<p style="text-align:right">' . __('Version', 'onlinecontract') . ' ' . ONLINE_CONTRACT_VERSION_NUMBER . '</p>';
    };

    $about = function () use ($form) {
        include(ONLINE_CONTRACT_DIR . 'about.php');
    };



    // Layout
    tr_tabs()
        ->addTab(__('Purchase Confirmation', 'onlinecontract'), $auth)
        ->addTab(__('About', 'onlinecontract'), $about)
        ->render('box');
    echo $form->close();
    ?>

</div>