<?php
if (!function_exists('add_action')) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

// Setup Form
$form = tr_form()->useJson()->setGroup('fdg_shortcodes');
?>

<h1><?php echo __('Shortcodes', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php
    echo $form->open();
    $shortcodes = function () use ($form) {
        $options = [];
        $options[__('All', 'onlinecontract')] = '';
        foreach (tr_options_field('fdg_template_options.contract_templates') as $template) {
            $options[$template['contract_name']] = $template['contract_name'];
        }
        echo '<p>' . __('Add your custom shortcodes here. If you do not understand what a field is, please refer to the information icon next to the field.', 'onlinecontract') . '</p>';
        $repeater = $form->repeater('Contract Shortcodes')
            ->setLabel(__('Contract Shortcodes', 'onlinecontract'))
            ->setFields(array(
                $form->row(
                    $form->text('Label')->setLabel(__('Label', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('This is the text that shows with the input.', 'onlinecontract') . '</span></em>'),
                    $form->text('Shortcode')->setLabel(__('Shortcode', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('This is how your shortcodes will be used in your templates. Remember to add brackets ([shortcodesname]) around your shortcodes and do not use spaces or special characters.', 'onlinecontract') . '</span></em>'),
                    $form->text('Function')->setLabel(__('Function', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Use standard math functions for the shortcodes you add. For example, "([shortcode1] + [shortcode2]) / 2" would add shortcode1 and shortcode2 then divide by 2.', 'onlinecontract') . '</span></em>'),
                    $form->text('Options')->setLabel(__('Options', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Add options to your select box. So, if you add "red, blue, green, yellow" in the text box, the add new or edit contract window will display a drop down box with these options.', 'onlinecontract') . '</span></em>'),
                    $form->select('Data Type')
                        ->setOptions(
                            array(
                                'Text' => 'text',
                                'Select Box' => 'select',
                                'Text Area' => 'textarea',
                                'Date' => 'date',
                                'Check Box' => 'checkbox',
                                'Radio Select' => 'radio',
                                'Editor' => 'editor'
                            )
                        )
                        ->setLabel(__('Data Type', 'onlinecontract'))
                ),
                $form->textarea('Descriptive Text')->setLabel(__('Descriptive Text', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Visible description for the shortcode. Displayed on the admin and client input form to describe the form input.', 'onlinecontract') . '</span></em>'),
                $form->select('Template')
                    ->setOptions($options)
                    ->setLabel(__('Select Template', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Choose a template this shortcode is associated with', 'onlinecontract') . '</span></em>'),
                $form->checkbox('Function Only')
                    ->setSetting('default', false)
                    ->setLabel(__('Function Only', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('This option allows you to set a shortcode that is not used for input but only for calculations. Typically used with the Function option.', 'onlinecontract') . '</span></em>'),
                $form->checkbox('Visible on Front')
                    ->setSetting('default', false)
                    ->setLabel(__('Visible on Front', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Check this box to show this shortcode as a form field on the client input form.', 'onlinecontract') . '</span></em>'),
                $form->checkbox('Required Input on Front')
                    ->setSetting('default', false)
                    ->setLabel(__('Required?', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Check this box to force this field to a required input.', 'onlinecontract') . '</span></em>'),
                $form->checkbox('Prepared Field')
                    ->setSetting('default', false)
                    ->setLabel(__('Prepared Field', 'onlinecontract') . ' <em class="tooltip"><span class="icon">?</span><span class="tooltiptext">' . __('Check this box to show this field as a required item that must be filled out during the contract signing. Since a printed name can be required on the contract, it is not necessary to force the client name to be a prepared field unless you need it to be.', 'onlinecontract') . '</span></em>')
            ));
        echo $repeater;
    };
    $woocommerce = function () use ($form) {
        if (is_plugin_active('wp-online-contract-woocommerce/online-contract-woocommerce.php')) {
            require_once WP_PLUGIN_DIR . '/wp-online-contract-woocommerce/woocommerce_shortcodes.php';
        } else {
            echo  '<p>' . __('You do not have this addon currently installed. You can purchase it here', 'onlinecontract') . ': <a href="https://codecanyon.net/item/wp-online-contract-skrill-payments/8198739?ref=futuredesigngrp" target="_blank">Purchase Addon</a></p>';
        }
    };

    $save = $form->submit(__('Modify Shortcodes', 'onlinecontract'));

    // Layout
    tr_tabs()->setSidebar($save)
        ->addTab(__('Contract Shortcodes', 'onlinecontract'), $shortcodes)
        //->addTab( 'WooCommerce', $woocommerce )
        ->render('box');
    echo $form->close();
    ?>

</div>