<?php

namespace WeDevs\PM_Pro\Core\Validator;

use WP_REST_Request;

interface Validator {
    /**
     * Perform validation tasks i.e this will check whether all the rules
     * that are applied to a specific data key are satisfied or not.
     *
     * @param WP_REST_Request $request (Current request to the application.)
     *
     * @param string $key (Data key under validation.)
     *
     * @return boolean (If all the rules are satified, this method will
     * return true; otherwise false.)
     */
    public function validate( WP_REST_Request $request, $key );

    /**
     * Generation of messages for wrong data passed to the application.
     *
     * @return array (Associative array of error messages where keys are
     * data keys and corresponding values are error messages. Values can
     * be array of error messages.)
     */
    public function messages();

    /**
     * Rules for validating data passed to the application will be
     * defined and returned as an associative array.
     *
     * @return array (Associative array where keys are data keys and
     * values are rules. Multiple rules will be separated by piple line.)
     */
    public function rules();

    /**
     * Check whether the data passed to the application under a specific
     * key contain error or not if the key is supplied; otherwise it
     * will check for errors under all keys in the request object.
     *
     * @param string $key (Key of data field in the request object.)
     *
     * @return boolean (If data contains error, this will return true;
     * otherwise false.)
     */
    public function has_error( $key = null );

    /**
     * Array of errors under a key generated by the validate method will
     * be returned if a data key is supplied; otherwise it will return
     * errors under all data keys.
     *
     * @param string $key (Key of data field in the request object.)
     *
     * @return array (Associative array of error where keys are data key
     * and corresponding values are error messages. Values can be an
     * array in the case of multiple errors for the same data value.)
     */
    public function get_errors( $key = null );
}